/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.stubs;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyModuleNameIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> NAME = ID.create((String)"Py.module.name");
    private final EnumeratorStringDescriptor myKeyDescriptor = new EnumeratorStringDescriptor();
    private final DataIndexer<String, Void, FileContent> myDataIndexer = new DataIndexer<String, Void, FileContent>(){

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/jetbrains/python/psi/stubs/PyModuleNameIndex$1", "map"));
            }
            VirtualFile file = inputData.getFile();
            String name = file.getName();
            if ("__init__.py".equals(name)) {
                VirtualFile parent = file.getParent();
                if (parent != null && parent.isDirectory()) {
                    Map<String, Object> map = Collections.singletonMap(parent.getName(), null);
                    if (map == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PyModuleNameIndex$1", "map"));
                    }
                    return map;
                }
            } else {
                Map<String, Object> map = Collections.singletonMap(FileUtil.getNameWithoutExtension((String)name), null);
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PyModuleNameIndex$1", "map"));
                }
                return map;
            }
            Map<String, Void> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PyModuleNameIndex$1", "map"));
            }
            return map;
        }
    };

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PyModuleNameIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PyModuleNameIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = this.myKeyDescriptor;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PyModuleNameIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{PythonFileType.INSTANCE});
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PyModuleNameIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }

    @NotNull
    public static Collection<String> getAllKeys(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/stubs/PyModuleNameIndex", "getAllKeys"));
        }
        Collection collection = FileBasedIndex.getInstance().getAllKeys(NAME, project);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PyModuleNameIndex", "getAllKeys"));
        }
        return collection;
    }

    @NotNull
    public static List<PyFile> find(@NotNull String name, @NotNull Project project, boolean includeNonProjectItems) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/stubs/PyModuleNameIndex", "find"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/stubs/PyModuleNameIndex", "find"));
        }
        ArrayList<PyFile> results = new ArrayList<PyFile>();
        GlobalSearchScope scope = includeNonProjectItems ? PyProjectScopeBuilder.excludeSdkTestsScope(project) : GlobalSearchScope.projectScope((Project)project);
        Collection files = FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)name, scope);
        for (VirtualFile virtualFile : files) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (!(psiFile instanceof PyFile) || PyUserSkeletonsUtil.isUnderUserSkeletonsDirectory(psiFile)) continue;
            results.add((PyFile)psiFile);
        }
        ArrayList<PyFile> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PyModuleNameIndex", "find"));
        }
        return arrayList;
    }
}

