/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.stubs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyClassNameIndex
extends StringStubIndexExtension<PyClass> {
    public static final StubIndexKey<String, PyClass> KEY = StubIndexKey.createIndexKey((String)"Py.class.shortName");

    @NotNull
    public StubIndexKey<String, PyClass> getKey() {
        StubIndexKey<String, PyClass> stubIndexKey = KEY;
        if (stubIndexKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PyClassNameIndex", "getKey"));
        }
        return stubIndexKey;
    }

    public static Collection<PyClass> find(String name, Project project, GlobalSearchScope scope) {
        return StubIndex.getElements(KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, PyClass.class);
    }

    public static Collection<PyClass> find(String name, Project project, boolean includeNonProjectItems) {
        GlobalSearchScope scope = includeNonProjectItems ? PyProjectScopeBuilder.excludeSdkTestsScope(project) : GlobalSearchScope.projectScope((Project)project);
        return PyClassNameIndex.find(name, project, scope);
    }

    @Nullable
    public static PyClass findClass(@NotNull String qName, Project project, GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/jetbrains/python/psi/stubs/PyClassNameIndex", "findClass"));
        }
        int pos = qName.lastIndexOf(".");
        String shortName = pos > 0 ? qName.substring(pos + 1) : qName;
        for (PyClass pyClass : PyClassNameIndex.find(shortName, project, scope)) {
            if (!qName.equals(pyClass.getQualifiedName())) continue;
            return pyClass;
        }
        return null;
    }

    @Nullable
    public static PyClass findClass(@Nullable String qName, Project project) {
        if (qName == null) {
            return null;
        }
        return PyClassNameIndex.findClass(qName, project, ProjectScope.getAllScope((Project)project));
    }

    public static Collection<String> allKeys(Project project) {
        return StubIndex.getInstance().getAllKeys(KEY, project);
    }
}

