/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.stubs;

import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.io.StringRef;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.impl.PropertyBunch;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStub;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStubType;
import com.jetbrains.python.psi.impl.stubs.PropertyStubType;
import com.jetbrains.python.toolbox.Maybe;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyStubStorage
extends PropertyBunch<String>
implements CustomTargetExpressionStub {
    private static final String IMPOSSIBLE_NAME = "#";
    private static final Maybe<String> unknown = new Maybe();
    private static final Maybe<String> none = new Maybe<Object>(null);

    @Override
    @NotNull
    protected Maybe<String> translate(@Nullable PyExpression ref) {
        if (ref != null) {
            String name = ref.getName();
            Maybe<String> maybe = name != null ? new Maybe<String>(name) : unknown;
            if (maybe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PropertyStubStorage", "translate"));
            }
            return maybe;
        }
        Maybe<String> maybe = none;
        if (maybe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PropertyStubStorage", "translate"));
        }
        return maybe;
    }

    private static void writeOne(Maybe<String> what, StubOutputStream stream) throws IOException {
        if (what.isDefined()) {
            stream.writeName(what.value());
        } else {
            stream.writeName(IMPOSSIBLE_NAME);
        }
    }

    @Override
    @NotNull
    public Class<? extends CustomTargetExpressionStubType> getTypeClass() {
        if (PropertyStubType.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/stubs/PropertyStubStorage", "getTypeClass"));
        }
        return PropertyStubType.class;
    }

    @Override
    public void serialize(StubOutputStream stream) throws IOException {
        PropertyStubStorage.writeOne(this.myGetter, stream);
        PropertyStubStorage.writeOne(this.mySetter, stream);
        PropertyStubStorage.writeOne(this.myDeleter, stream);
        stream.writeName(this.myDoc);
    }

    @Override
    public QualifiedName getCalleeName() {
        return null;
    }

    public static PropertyStubStorage deserialize(StubInputStream stream) throws IOException {
        PropertyStubStorage me = new PropertyStubStorage();
        me.myGetter = PropertyStubStorage.readOne(stream);
        me.mySetter = PropertyStubStorage.readOne(stream);
        me.myDeleter = PropertyStubStorage.readOne(stream);
        StringRef ref = stream.readName();
        me.myDoc = ref != null ? ref.getString() : null;
        return me;
    }

    @Nullable
    private static Maybe<String> readOne(StubInputStream stream) throws IOException {
        StringRef ref = stream.readName();
        if (ref == null) {
            return none;
        }
        String s = ref.getString();
        if (IMPOSSIBLE_NAME.equals(s)) {
            return unknown;
        }
        return new Maybe<String>(s);
    }

    @Nullable
    public static PropertyStubStorage fromCall(@Nullable PyExpression expr) {
        PropertyStubStorage prop = new PropertyStubStorage();
        boolean success = PropertyStubStorage.fillFromCall(expr, prop);
        return success ? prop : null;
    }
}

