/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PySuperMethodsSearchExecutor
implements QueryExecutor<PsiElement, PySuperMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull PySuperMethodsSearch.SearchParameters queryParameters, @NotNull Processor<PsiElement> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/jetbrains/python/psi/search/PySuperMethodsSearchExecutor", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/python/psi/search/PySuperMethodsSearchExecutor", "execute"));
        }
        PyFunction func = queryParameters.getDerivedMethod();
        String name = func.getName();
        PyClass containingClass = func.getContainingClass();
        HashSet<PyClass> foundMethodContainingClasses = new HashSet<PyClass>();
        if (name != null && containingClass != null) {
            for (PyClass superClass : containingClass.getAncestorClasses()) {
                PyFunction superMethod;
                if (!queryParameters.isDeepSearch()) {
                    boolean isAlreadyFound = false;
                    for (PyClass alreadyFound : foundMethodContainingClasses) {
                        if (!alreadyFound.isSubclass(superClass)) continue;
                        isAlreadyFound = true;
                    }
                    if (isAlreadyFound) continue;
                }
                if ((superMethod = superClass.findMethodByName(name, false)) != null) {
                    Property property = func.getProperty();
                    Property superProperty = superMethod.getProperty();
                    if (property != null && superProperty != null) {
                        AccessDirection direction = PyUtil.getPropertyAccessDirection(func);
                        Callable callable = superProperty.getByDirection(direction).valueOrNull();
                        PyFunction pyFunction = superMethod = callable instanceof PyFunction ? (PyFunction)callable : null;
                    }
                }
                if (superMethod == null) continue;
                foundMethodContainingClasses.add(superClass);
                if (consumer.process((Object)superMethod)) continue;
                return false;
            }
        }
        return true;
    }
}

