/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Query;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import java.util.ArrayList;
import java.util.List;

public class PySuperMethodsSearch
extends ExtensibleQueryFactory<PsiElement, SearchParameters> {
    public static PySuperMethodsSearch INSTANCE = new PySuperMethodsSearch();

    private static PyFunction getBaseMethod(List<PsiElement> superMethods, PyClass containingClass) {
        for (PyClass ancestor : containingClass.getAncestorClasses()) {
            for (PsiElement method : superMethods) {
                if (!ancestor.equals(((PyFunction)method).getContainingClass())) continue;
                return (PyFunction)method;
            }
        }
        return (PyFunction)superMethods.get(superMethods.size() - 1);
    }

    public static PyFunction findDeepestSuperMethod(PyFunction function) {
        ArrayList<Object> superMethods = new ArrayList<PsiElement>(PySuperMethodsSearch.search(function, true).findAll());
        while (superMethods.size() > 0) {
            function = PySuperMethodsSearch.getBaseMethod(superMethods, function.getContainingClass());
            superMethods = new ArrayList(PySuperMethodsSearch.search(function, true).findAll());
        }
        return function;
    }

    private PySuperMethodsSearch() {
        super("Pythonid");
    }

    public static Query<PsiElement> search(PyFunction derivedMethod) {
        SearchParameters parameters = new SearchParameters(derivedMethod, false);
        return INSTANCE.createUniqueResultsQuery(parameters);
    }

    public static Query<PsiElement> search(PyFunction derivedMethod, boolean deepSearch) {
        SearchParameters parameters = new SearchParameters(derivedMethod, deepSearch);
        return INSTANCE.createUniqueResultsQuery(parameters);
    }

    public static class SearchParameters {
        private final PyFunction myDerivedMethod;
        private final boolean myDeepSearch;

        public SearchParameters(PyFunction derivedMethod, boolean deepSearch) {
            this.myDerivedMethod = derivedMethod;
            this.myDeepSearch = deepSearch;
        }

        public PyFunction getDerivedMethod() {
            return this.myDerivedMethod;
        }

        public boolean isDeepSearch() {
            return this.myDeepSearch;
        }
    }
}

