/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;

public class PyStringReferenceSearch
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public PyStringReferenceSearch() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters params, @NotNull Processor<PsiReference> consumer) {
        String name;
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/jetbrains/python/psi/search/PyStringReferenceSearch", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/python/psi/search/PyStringReferenceSearch", "processQuery"));
        }
        PsiElement element = params.getElementToSearch();
        if (!(element instanceof PyElement) && !(element instanceof PsiDirectory)) {
            return;
        }
        SearchScope searchScope = params.getEffectiveSearchScope();
        if (searchScope instanceof GlobalSearchScope) {
            searchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)searchScope), (FileType[])new FileType[]{PythonFileType.INSTANCE});
        }
        if (StringUtil.isEmpty((String)(name = PyUtil.computeElementNameForStringSearch(element)))) {
            return;
        }
        params.getOptimizer().searchWord(name, searchScope, (short)4, true, element);
    }
}

