/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.ProjectScopeBuilderImpl;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.psi.search.SearchScope;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyProjectScopeBuilder
extends ProjectScopeBuilderImpl {
    public PyProjectScopeBuilder(Project project) {
        super(project);
    }

    @Override
    @NotNull
    public GlobalSearchScope buildAllScope() {
        ProjectAndLibrariesScope projectAndLibrariesScope = new ProjectAndLibrariesScope(this.myProject){

            public boolean isSearchOutsideRootModel() {
                return true;
            }
        };
        if (projectAndLibrariesScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/search/PyProjectScopeBuilder", "buildAllScope"));
        }
        return projectAndLibrariesScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope buildProjectScope() {
        final FileIndexFacade fileIndex = FileIndexFacade.getInstance((Project)this.myProject);
        ProjectScopeImpl projectScopeImpl = new ProjectScopeImpl(this.myProject, fileIndex){

            @Override
            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/search/PyProjectScopeBuilder$2", "contains"));
                }
                if (file instanceof VirtualFileWindow) {
                    return true;
                }
                return fileIndex.isInContent(file);
            }
        };
        if (projectScopeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/search/PyProjectScopeBuilder", "buildProjectScope"));
        }
        return projectScopeImpl;
    }

    public static GlobalSearchScope excludeSdkTestsScope(Project project) {
        Sdk sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        GlobalSearchScope scope = PyProjectScopeBuilder.excludeSdkTestsScope(project, sdk);
        return scope != null ? ProjectScope.getAllScope((Project)project).intersectWith(scope) : ProjectScope.getAllScope((Project)project);
    }

    public static GlobalSearchScope excludeSdkTestsScope(PsiElement anchor) {
        GlobalSearchScope excludeScope;
        Sdk sdk;
        Project project = anchor.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)anchor);
        if (module != null && (sdk = PythonSdkType.findPythonSdk(module)) != null && (excludeScope = PyProjectScopeBuilder.excludeSdkTestsScope(project, sdk)) != null) {
            return GlobalSearchScope.allScope((Project)project).intersectWith(excludeScope);
        }
        return PyProjectScopeBuilder.excludeSdkTestsScope(project);
    }

    @Nullable
    public static GlobalSearchScope excludeSdkTestsScope(Project project, Sdk sdk) {
        List<VirtualFile> testDirs;
        VirtualFile libDir;
        if (sdk != null && sdk.getSdkType() instanceof PythonSdkType && (libDir = PyProjectScopeBuilder.findLibDir(sdk)) != null && !(testDirs = PyProjectScopeBuilder.findTestDirs(libDir, "test", "bsddb/test", "ctypes/test", "distutils/tests", "email/test", "importlib/test", "json/tests", "lib2to3/tests", "sqlite3/test", "tkinter/test", "idlelib/testcode.py")).isEmpty()) {
            GlobalSearchScope scope = PyProjectScopeBuilder.buildUnionScope(project, testDirs);
            return GlobalSearchScope.notScope((GlobalSearchScope)scope);
        }
        return null;
    }

    private static GlobalSearchScope buildUnionScope(Project project, List<VirtualFile> testDirs) {
        GlobalSearchScope scope = GlobalSearchScopes.directoryScope((Project)project, (VirtualFile)testDirs.get(0), (boolean)true);
        for (int i = 1; i < testDirs.size(); ++i) {
            scope = scope.union((SearchScope)GlobalSearchScopes.directoryScope((Project)project, (VirtualFile)testDirs.get(i), (boolean)true));
        }
        return scope;
    }

    private static List<VirtualFile> findTestDirs(VirtualFile baseDir, String ... relativePaths) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (String path : relativePaths) {
            VirtualFile child = baseDir.findFileByRelativePath(path);
            if (child == null) continue;
            result.add(child);
        }
        return result;
    }

    @Nullable
    public static VirtualFile findLibDir(Sdk sdk) {
        return PyProjectScopeBuilder.findLibDir(sdk.getRootProvider().getFiles(OrderRootType.CLASSES));
    }

    public static VirtualFile findVirtualEnvLibDir(Sdk sdk) {
        File root;
        VirtualFile[] classVFiles = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        String homePath = sdk.getHomePath();
        if (homePath != null && (root = PythonSdkType.getVirtualEnvRoot(homePath)) != null) {
            File libRoot = new File(root, "lib");
            File[] versionRoots = libRoot.listFiles();
            if (versionRoots != null && versionRoots.length == 1) {
                libRoot = versionRoots[0];
            }
            for (VirtualFile file : classVFiles) {
                if (!FileUtil.pathsEqual((String)file.getPath(), (String)libRoot.getPath())) continue;
                return file;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile findLibDir(VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (!file.isValid()) continue;
            if ((file.findChild("__future__.py") != null || file.findChild("__future__.pyc") != null) && file.findChild("xml") != null && file.findChild("email") != null) {
                return file;
            }
            if (!ApplicationManager.getApplication().isUnitTestMode() || !file.getName().equals("Lib")) continue;
            return file;
        }
        return null;
    }
}

