/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import org.jetbrains.annotations.NotNull;

public class PyOverridingMethodsSearchExecutor
implements QueryExecutor<PyFunction, PyOverridingMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull PyOverridingMethodsSearch.SearchParameters queryParameters, final @NotNull Processor<PyFunction> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/jetbrains/python/psi/search/PyOverridingMethodsSearchExecutor", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/python/psi/search/PyOverridingMethodsSearchExecutor", "execute"));
        }
        final PyFunction baseMethod = queryParameters.getFunction();
        PyClass containingClass = baseMethod.getContainingClass();
        return PyClassInheritorsSearch.search(containingClass, queryParameters.isCheckDeep()).forEach((Processor)new Processor<PyClass>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean process(PyClass pyClass) {
                PyFunction overridingMethod;
                AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
                try {
                    overridingMethod = pyClass.findMethodByName(baseMethod.getName(), false);
                    if (overridingMethod != null) {
                        Property baseProperty = baseMethod.getProperty();
                        Property overridingProperty = overridingMethod.getProperty();
                        if (baseProperty != null && overridingProperty != null) {
                            AccessDirection direction = PyUtil.getPropertyAccessDirection(baseMethod);
                            Callable callable = overridingProperty.getByDirection(direction).valueOrNull();
                            overridingMethod = callable instanceof PyFunction ? (PyFunction)callable : null;
                        }
                    }
                }
                finally {
                    accessToken.finish();
                }
                if (overridingMethod != null) {
                    return consumer.process((Object)overridingMethod);
                }
                return true;
            }
        });
    }
}

