/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import org.jetbrains.annotations.NotNull;

public class PyKeywordArgumentSearchExecutor
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, final @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/jetbrains/python/psi/search/PyKeywordArgumentSearchExecutor", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/python/psi/search/PyKeywordArgumentSearchExecutor", "processQuery"));
        }
        final PsiElement element = queryParameters.getElementToSearch();
        if (!(element instanceof PyNamedParameter)) {
            return;
        }
        ScopeOwner owner = (ScopeOwner)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ScopeOwner>(){

            public ScopeOwner compute() {
                return ScopeUtil.getScopeOwner(element);
            }
        });
        if (!(owner instanceof PyFunction)) {
            return;
        }
        ReferencesSearch.search((PsiElement)owner, (SearchScope)queryParameters.getScopeDeterminedByUser()).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                PyKeywordArgument keywordArgument;
                PyArgumentList argumentList;
                PsiElement refElement = reference.getElement();
                PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)refElement, PyCallExpression.class);
                if (call != null && PsiTreeUtil.isAncestor((PsiElement)call.getCallee(), (PsiElement)refElement, (boolean)false) && (argumentList = call.getArgumentList()) != null && (keywordArgument = argumentList.getKeywordArgument(((PyNamedParameter)element).getName())) != null) {
                    return consumer.process((Object)keywordArgument.getReference());
                }
                return true;
            }
        });
    }
}

