/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import org.jetbrains.annotations.NotNull;

public class PyInitReferenceSearchExecutor
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        SearchScope searchScope;
        String className;
        PyFunction function;
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/jetbrains/python/psi/search/PyInitReferenceSearchExecutor", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/python/psi/search/PyInitReferenceSearchExecutor", "processQuery"));
        }
        PsiElement element = queryParameters.getElementToSearch();
        if (!(element instanceof PyFunction)) {
            return;
        }
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            function = (PyFunction)element;
            if (!"__init__".equals(function.getName())) {
                return;
            }
            PyClass pyClass = function.getContainingClass();
            if (pyClass == null) {
                return;
            }
            className = pyClass.getName();
            if (className == null) {
                return;
            }
            searchScope = queryParameters.getEffectiveSearchScope();
            if (searchScope instanceof GlobalSearchScope) {
                searchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)searchScope), (FileType[])new FileType[]{PythonFileType.INSTANCE});
            }
        }
        finally {
            accessToken.finish();
        }
        queryParameters.getOptimizer().searchWord(className, searchScope, (short)1, true, (PsiElement)function);
    }
}

