/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import org.jetbrains.annotations.NotNull;

public class PyDefinitionsSearch
implements QueryExecutor<PsiElement, PsiElement> {
    public boolean execute(@NotNull PsiElement queryParameters, final @NotNull Processor<PsiElement> consumer) {
        PsiElement parent;
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/jetbrains/python/psi/search/PyDefinitionsSearch", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/python/psi/search/PyDefinitionsSearch", "execute"));
        }
        if (queryParameters instanceof PyClass) {
            Query<PyClass> query = PyClassInheritorsSearch.search((PyClass)queryParameters, true);
            return query.forEach((Processor)new Processor<PyClass>(){

                public boolean process(PyClass pyClass) {
                    return consumer.process((Object)pyClass);
                }
            });
        }
        if (queryParameters instanceof PyFunction) {
            Query<PyFunction> query = PyOverridingMethodsSearch.search((PyFunction)queryParameters, true);
            return query.forEach((Processor)new Processor<PyFunction>(){

                public boolean process(PyFunction pyFunction) {
                    return consumer.process((Object)pyFunction);
                }
            });
        }
        if (queryParameters instanceof PyTargetExpression && (parent = queryParameters.getParent()) instanceof PyAssignmentStatement) {
            return consumer.process((Object)parent);
        }
        return true;
    }
}

