/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.HashSet;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import com.jetbrains.python.psi.stubs.PySuperClassIndex;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyClassInheritorsSearchExecutor
implements QueryExecutor<PyClass, PyClassInheritorsSearch.SearchParameters> {
    protected static final ImmutableSet<String> IGNORED_BASES = ImmutableSet.of((Object)"object", (Object)"BaseException", (Object)"Exception");

    public boolean execute(@NotNull PyClassInheritorsSearch.SearchParameters queryParameters, @NotNull Processor<PyClass> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/jetbrains/python/psi/search/PyClassInheritorsSearchExecutor", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/python/psi/search/PyClassInheritorsSearchExecutor", "execute"));
        }
        HashSet processed = new HashSet();
        return PyClassInheritorsSearchExecutor.processDirectInheritors(queryParameters.getSuperClass(), consumer, queryParameters.isCheckDeepInheritance(), (Set<PyClass>)processed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processDirectInheritors(PyClass superClass, Processor<PyClass> consumer, boolean checkDeep, Set<PyClass> processed) {
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            String superClassName = superClass.getName();
            if (superClassName == null || IGNORED_BASES.contains((Object)superClassName)) {
                boolean bl = true;
                return bl;
            }
            if (processed.contains(superClass)) {
                boolean bl = true;
                return bl;
            }
            processed.add(superClass);
            Project project = superClass.getProject();
            Collection candidates = StubIndex.getElements(PySuperClassIndex.KEY, (Object)superClassName, (Project)project, (GlobalSearchScope)ProjectScope.getAllScope((Project)project), PyClass.class);
            block7: for (PyClass candidate : candidates) {
                PyClass[] classes;
                for (PyClass superClassCandidate : classes = candidate.getSuperClasses()) {
                    if (!superClassCandidate.isEquivalentTo(superClass)) continue;
                    if (!consumer.process((Object)candidate)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!checkDeep || PyClassInheritorsSearchExecutor.processDirectInheritors(candidate, consumer, checkDeep, processed)) continue block7;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            accessToken.finish();
        }
        return true;
    }
}

