/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VariantsProcessor
implements PsiScopeProcessor {
    protected final PsiElement myContext;
    protected Condition<PsiElement> myNodeFilter;
    protected Condition<String> myNameFilter;
    protected boolean myPlainNamesOnly = false;
    private List<String> myAllowedNames;
    private final List<String> mySeenNames = new ArrayList<String>();

    public VariantsProcessor(PsiElement context) {
        this.myContext = context;
    }

    public VariantsProcessor(PsiElement context, @Nullable Condition<PsiElement> nodeFilter, @Nullable Condition<String> nameFilter) {
        this.myContext = context;
        this.myNodeFilter = nodeFilter;
        this.myNameFilter = nameFilter;
    }

    public boolean isPlainNamesOnly() {
        return this.myPlainNamesOnly;
    }

    public void setPlainNamesOnly(boolean plainNamesOnly) {
        this.myPlainNamesOnly = plainNamesOnly;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState substitutor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/resolve/VariantsProcessor", "execute"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/jetbrains/python/psi/resolve/VariantsProcessor", "execute"));
        }
        if (this.myNodeFilter != null && !this.myNodeFilter.value((Object)element)) {
            return true;
        }
        if (element instanceof PsiNamedElement) {
            PsiNamedElement psiNamedElement = (PsiNamedElement)element;
            String name = PyUtil.getElementNameWithoutExtension(psiNamedElement);
            if (name != null && this.nameIsAcceptable(name)) {
                this.addElement(name, (PsiElement)psiNamedElement);
            }
        } else if (element instanceof PyReferenceExpression) {
            PyReferenceExpression expr = (PyReferenceExpression)element;
            String referencedName = expr.getReferencedName();
            if (this.nameIsAcceptable(referencedName)) {
                this.addElement(referencedName, (PsiElement)expr);
            }
        } else if (element instanceof NameDefiner) {
            boolean handledAsImported = false;
            if (element instanceof PyImportElement) {
                PyImportElement importElement = (PyImportElement)element;
                handledAsImported = this.handleImportElement(importElement);
            }
            if (!handledAsImported) {
                NameDefiner definer = (NameDefiner)element;
                for (PyElement expr : definer.iterateNames()) {
                    if (expr == null || expr == this.myContext) continue;
                    if (!expr.isValid()) {
                        throw new PsiInvalidElementAccessException((PsiElement)expr, "Definer: " + definer);
                    }
                    String referencedName = expr instanceof PyFile ? FileUtil.getNameWithoutExtension((String)((PyFile)expr).getName()) : expr.getName();
                    if (referencedName == null || !this.nameIsAcceptable(referencedName)) continue;
                    this.addImportedElement(referencedName, definer, expr);
                }
            }
        }
        return true;
    }

    protected boolean handleImportElement(PyImportElement importElement) {
        QualifiedName qName = importElement.getImportedQName();
        if (qName != null && qName.getComponentCount() == 1) {
            PsiElement resolved;
            String name;
            String string = name = importElement.getAsName() != null ? importElement.getAsName() : qName.getLastComponent();
            if (name != null && this.nameIsAcceptable(name) && (resolved = importElement.resolve()) instanceof PsiNamedElement) {
                this.addElement(name, resolved);
                return true;
            }
        }
        return false;
    }

    protected void addElement(String name, PsiElement psiNamedElement) {
        this.mySeenNames.add(name);
    }

    protected void addImportedElement(String referencedName, NameDefiner definer, PyElement expr) {
        this.addElement(referencedName, (PsiElement)expr);
    }

    private boolean nameIsAcceptable(String name) {
        if (name == null) {
            return false;
        }
        if (this.mySeenNames.contains(name)) {
            return false;
        }
        if (this.myNameFilter != null && !this.myNameFilter.value((Object)name)) {
            return false;
        }
        return this.myAllowedNames == null || this.myAllowedNames.contains(name);
    }

    @Nullable
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/jetbrains/python/psi/resolve/VariantsProcessor", "getHint"));
        }
        return null;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/resolve/VariantsProcessor", "handleEvent"));
        }
    }

    public void setAllowedNames(List<String> namesFilter) {
        this.myAllowedNames = namesFilter;
    }
}

