/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.python.psi.resolve.RootVisitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RootVisitorHost {
    public static void visitRoots(@NotNull PsiElement elt, @NotNull RootVisitor visitor) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/jetbrains/python/psi/resolve/RootVisitorHost", "visitRoots"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/psi/resolve/RootVisitorHost", "visitRoots"));
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)elt);
        if (module != null) {
            RootVisitorHost.visitRoots(module, false, visitor);
        } else {
            PsiFile containingFile = elt.getContainingFile();
            if (containingFile != null) {
                RootVisitorHost.visitSdkRoots(containingFile, visitor);
            }
        }
    }

    public static void visitRoots(@NotNull Module module, boolean skipSdk, final RootVisitor visitor) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/psi/resolve/RootVisitorHost", "visitRoots"));
        }
        OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)module).recursively();
        if (skipSdk) {
            enumerator = enumerator.withoutSdk();
        }
        enumerator.forEach((Processor)new Processor<OrderEntry>(){

            public boolean process(OrderEntry orderEntry) {
                if (orderEntry instanceof ModuleSourceOrderEntry) {
                    return RootVisitorHost.visitModuleContentEntries(((ModuleSourceOrderEntry)orderEntry).getRootModel(), visitor);
                }
                return RootVisitorHost.visitOrderEntryRoots(visitor, orderEntry);
            }
        });
    }

    static void visitSdkRoots(PsiFile file, RootVisitor visitor) {
        Sdk sdk;
        VirtualFile elt_vfile = file.getOriginalFile().getVirtualFile();
        List orderEntries = null;
        if (elt_vfile != null) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex();
            orderEntries = fileIndex.getOrderEntriesForFile(elt_vfile);
            if (orderEntries.size() > 0) {
                OrderEntry entry;
                Iterator i$ = orderEntries.iterator();
                while (i$.hasNext() && RootVisitorHost.visitOrderEntryRoots(visitor, entry = (OrderEntry)i$.next())) {
                }
            } else {
                orderEntries = null;
            }
        }
        if (orderEntries == null && (sdk = ProjectRootManager.getInstance((Project)file.getProject()).getProjectSdk()) != null) {
            RootVisitorHost.visitSdkRoots(sdk, visitor);
        }
    }

    public static boolean visitSdkRoots(@NotNull Sdk sdk, @NotNull RootVisitor visitor) {
        VirtualFile[] roots;
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/psi/resolve/RootVisitorHost", "visitSdkRoots"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/psi/resolve/RootVisitorHost", "visitSdkRoots"));
        }
        for (VirtualFile root : roots = sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
            if (visitor.visitRoot(root, null, sdk, false)) continue;
            return true;
        }
        return false;
    }

    private static boolean visitModuleContentEntries(ModuleRootModel rootModel, RootVisitor visitor) {
        HashSet contentRoots = Sets.newHashSet();
        for (ContentEntry entry : rootModel.getContentEntries()) {
            VirtualFile rootFile = entry.getFile();
            if (rootFile != null && !visitor.visitRoot(rootFile, null, null, true)) {
                return false;
            }
            contentRoots.add(rootFile);
            for (VirtualFile folder : entry.getSourceFolderFiles()) {
                if (visitor.visitRoot(folder, rootModel.getModule(), null, true)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean visitOrderEntryRoots(RootVisitor visitor, OrderEntry entry) {
        LinkedHashSet allRoots = new LinkedHashSet();
        Collections.addAll(allRoots, entry.getFiles(OrderRootType.SOURCES));
        Collections.addAll(allRoots, entry.getFiles(OrderRootType.CLASSES));
        Module module = entry instanceof ModuleOrderEntry ? ((ModuleOrderEntry)entry).getModule() : null;
        Sdk sdk = entry instanceof JdkOrderEntry ? ((JdkOrderEntry)entry).getJdk() : null;
        for (VirtualFile root : allRoots) {
            if (visitor.visitRoot(root, module, sdk, false)) continue;
            return false;
        }
        return true;
    }
}

