/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveProcessor
implements PsiScopeProcessor {
    @NotNull
    private final String myName;
    private PsiElement myResult;
    private final List<PsiElement> myDefiners;
    private boolean myLocalResolve;

    public ResolveProcessor(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/resolve/ResolveProcessor", "<init>"));
        }
        this.myResult = null;
        this.myLocalResolve = false;
        this.myName = name;
        this.myDefiners = new ArrayList<PsiElement>(2);
    }

    public PsiElement getResult() {
        return this.myResult;
    }

    protected void addNameDefiner(PsiElement definer) {
        this.myDefiners.add(definer);
    }

    public List<PsiElement> getDefiners() {
        return this.myDefiners;
    }

    public void setLocalResolve() {
        this.myLocalResolve = true;
    }

    public String toString() {
        return PyUtil.nvl(this.myName) + ", " + PyUtil.nvl(this.myResult);
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState substitutor) {
        PsiElement source;
        PyFromImportStatement fromImportStatement;
        QualifiedName qName;
        PyReferenceExpression expr;
        String referencedName;
        VirtualFile file;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/resolve/ResolveProcessor", "execute"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/jetbrains/python/psi/resolve/ResolveProcessor", "execute"));
        }
        if (element instanceof PyFile && (file = ((PyFile)element).getVirtualFile()) != null) {
            VirtualFile dir;
            if (this.myName.equals(file.getNameWithoutExtension())) {
                return this.setResult((PsiElement)element, null);
            }
            if ("__init__.py".equals(file.getName()) && (dir = file.getParent()) != null && this.myName.equals(dir.getName())) {
                return this.setResult((PsiElement)element, null);
            }
        }
        if (element instanceof PsiNamedElement && this.myName.equals(((PsiNamedElement)element).getName())) {
            return this.setResult((PsiElement)element, null);
        }
        if (element instanceof PyReferenceExpression && (referencedName = (expr = (PyReferenceExpression)element).getReferencedName()) != null && referencedName.equals(this.myName)) {
            return this.setResult((PsiElement)element, null);
        }
        if (element instanceof NameDefiner) {
            NameDefiner definer = (NameDefiner)element;
            PsiElement byName = this.resolveFromNameDefiner(definer);
            if (byName != null) {
                if (byName instanceof PyImportedModule && this.myResult instanceof PyImportedModule && ((PyImportedModule)byName).isAncestorOf((PyImportedModule)this.myResult)) {
                    return false;
                }
                this.setResult(byName, definer);
                if (!PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)byName, (boolean)true)) {
                    this.addNameDefiner(definer);
                }
                if (!(this.myResult instanceof PyImportedModule) && PsiTreeUtil.getParentOfType((PsiElement)element, PyExceptPart.class) == null) {
                    return false;
                }
            } else if (element instanceof PyImportElement) {
                String definedName;
                PsiElement packageElement;
                PyImportElement importElement = (PyImportElement)element;
                QualifiedName qName2 = importElement.getImportedQName();
                if (qName2 != null && qName2.getComponentCount() > 1 && this.myName.equals(qName2.getLastComponent()) && "__init__.py".equals(importElement.getContainingFile().getName()) && PyUtil.turnDirIntoInit(packageElement = ResolveImportUtil.resolveImportElement(importElement, qName2.removeLastComponent())) == importElement.getContainingFile()) {
                    this.myResult = PyUtil.turnDirIntoInit(importElement.resolve());
                    this.addNameDefiner(importElement);
                }
                if ((definedName = importElement.getAsName()) == null && qName2 != null && qName2.getComponentCount() == 1) {
                    definedName = (String)qName2.getComponents().get(0);
                }
                if (this.myName.equals(definedName)) {
                    this.addNameDefiner(importElement);
                }
                element = importElement.getContainingImportStatement();
            }
        }
        if (element instanceof PyFromImportStatement && "__init__.py".equals(element.getContainingFile().getName()) && (qName = (fromImportStatement = (PyFromImportStatement)element).getImportSourceQName()) != null && qName.endsWith(this.myName) && (source = PyUtil.turnInitIntoDir(fromImportStatement.resolveImportSource())) != null && source.getParent() == element.getContainingFile().getContainingDirectory()) {
            this.myResult = source;
            this.addNameDefiner((PsiElement)fromImportStatement);
        }
        return true;
    }

    @Nullable
    private PsiElement resolveFromNameDefiner(NameDefiner definer) {
        if (this.myLocalResolve) {
            if (definer instanceof PyImportElement) {
                return ((PyImportElement)definer).getElementNamed(this.myName, false);
            }
            if (definer instanceof PyStarImportElement) {
                return null;
            }
        }
        return definer.getElementNamed(this.myName);
    }

    @Nullable
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/jetbrains/python/psi/resolve/ResolveProcessor", "getHint"));
        }
        return null;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/resolve/ResolveProcessor", "handleEvent"));
        }
    }

    private boolean setResult(PsiElement result, @Nullable PsiElement definer) {
        if (this.myResult == null || ScopeUtil.getScopeOwner(this.myResult) == ScopeUtil.getScopeOwner(result) || definer != null && ScopeUtil.getScopeOwner(this.myResult) == ScopeUtil.getScopeOwner(definer)) {
            this.myResult = result;
        }
        return false;
    }
}

