/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.HashSet;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyFileImpl;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.impl.PyResolveResultRater;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.PointInImport;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PythonModulePathCache;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.QualifiedNameResolver;
import com.jetbrains.python.psi.resolve.QualifiedNameResolverImpl;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveImportUtil {
    private static final ThreadLocal<Set<String>> ourBeingImported = new ThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return new HashSet();
        }
    };

    private ResolveImportUtil() {
    }

    public static boolean isAbsoluteImportEnabledFor(PsiElement foothold) {
        PsiFile file;
        if (foothold != null && (file = foothold.getContainingFile()) instanceof PyFile) {
            PyFile pyFile = (PyFile)file;
            if (pyFile.getLanguageLevel().isPy3K()) {
                return true;
            }
            return pyFile.hasImportFromFuture(FutureFeature.ABSOLUTE_IMPORT);
        }
        return false;
    }

    @Nullable
    public static PsiDirectory stepBackFrom(PsiFile base, int depth) {
        if (depth == 0) {
            return base.getContainingDirectory();
        }
        if (base != null) {
            base = base.getOriginalFile();
            PsiDirectory result = base.getContainingDirectory();
            int count = 1;
            while (result != null && PyUtil.isPackage(result, (PsiElement)base)) {
                if (count >= depth) {
                    return result;
                }
                result = result.getParentDirectory();
                ++count;
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement resolveImportElement(PyImportElement importElement, @NotNull QualifiedName qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "resolveImportElement"));
        }
        PyStatement importStatement = importElement.getContainingImportStatement();
        List<RatedResolveResult> targets = importStatement instanceof PyFromImportStatement ? ResolveImportUtil.resolveNameInFromImport((PyFromImportStatement)importStatement, qName) : ResolveImportUtil.resolveNameInImportStatement(importElement, qName);
        List<RatedResolveResult> resultList = RatedResolveResult.sorted(targets);
        return resultList.size() > 0 ? resultList.get(0).getElement() : null;
    }

    public static List<RatedResolveResult> resolveNameInImportStatement(PyImportElement importElement, @NotNull QualifiedName qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "resolveNameInImportStatement"));
        }
        PsiFile file = importElement.getContainingFile().getOriginalFile();
        boolean absoluteImportEnabled = ResolveImportUtil.isAbsoluteImportEnabledFor(importElement);
        List<PsiElement> modules = ResolveImportUtil.resolveModule(qName, file, absoluteImportEnabled, 0);
        return ResolveImportUtil.rateResults(modules);
    }

    public static List<RatedResolveResult> resolveNameInFromImport(PyFromImportStatement importStatement, @NotNull QualifiedName qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "resolveNameInFromImport"));
        }
        PsiFile file = importStatement.getContainingFile().getOriginalFile();
        String name = (String)qName.getComponents().get(0);
        List<PsiElement> candidates = importStatement.resolveImportSourceCandidates();
        ArrayList<PsiElement> resultList = new ArrayList<PsiElement>();
        for (PsiElement candidate : candidates) {
            PsiElement result;
            if (!candidate.isValid()) {
                throw new PsiInvalidElementAccessException(candidate, "Got an invalid candidate from resolveImportSourceCandidates(): " + candidate.getClass());
            }
            if (candidate instanceof PsiDirectory) {
                candidate = PyUtil.getPackageElement((PsiDirectory)candidate, (PsiElement)importStatement);
            }
            if ((result = ResolveImportUtil.resolveChild(candidate, name, file, false, true)) == null) continue;
            if (!result.isValid()) {
                throw new PsiInvalidElementAccessException(result, "Got an invalid candidate from resolveChild(): " + result.getClass());
            }
            resultList.add(result);
        }
        if (!resultList.isEmpty()) {
            return ResolveImportUtil.rateResults(resultList);
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<PsiElement> resolveFromImportStatementSource(PyFromImportStatement from_import_statement, QualifiedName qName) {
        boolean absoluteImportEnabled = ResolveImportUtil.isAbsoluteImportEnabledFor((PsiElement)from_import_statement);
        PsiFile file = from_import_statement.getContainingFile();
        List<PsiElement> list = ResolveImportUtil.resolveModule(qName, file, absoluteImportEnabled, from_import_statement.getRelativeLevel());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "resolveFromImportStatementSource"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<PsiElement> resolveModule(@Nullable QualifiedName qualifiedName, PsiFile sourceFile, boolean importIsAbsolute, int relativeLevel) {
        if (qualifiedName == null || sourceFile == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "resolveModule"));
            }
            return list;
        }
        String marker = StringUtil.join((Collection)qualifiedName.getComponents(), (String)".") + "#" + Integer.toString(relativeLevel);
        Set<String> beingImported = ourBeingImported.get();
        if (beingImported.contains(marker)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "resolveModule"));
            }
            return list;
        }
        beingImported.add(marker);
        QualifiedNameResolver visitor = new QualifiedNameResolverImpl(qualifiedName).fromElement((PsiElement)sourceFile);
        if (relativeLevel > 0) {
            visitor.withRelative(relativeLevel).withoutRoots();
        } else if (!importIsAbsolute) {
            visitor.withRelative(0);
        }
        List<PsiElement> results = visitor.resultsAsList();
        if (results.isEmpty() && relativeLevel == 0 && !importIsAbsolute) {
            results = ResolveImportUtil.resolveRelativeImportAsAbsolute(sourceFile, qualifiedName);
        }
        List<PsiElement> list = results;
        List<PsiElement> list2 = list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "resolveModule"));
        }
        return list2;
        finally {
            beingImported.remove(marker);
        }
    }

    @NotNull
    private static List<PsiElement> resolveRelativeImportAsAbsolute(@NotNull PsiFile foothold, @NotNull QualifiedName qualifiedName) {
        QualifiedName containingPath;
        if (foothold == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foothold", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "resolveRelativeImportAsAbsolute"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "resolveRelativeImportAsAbsolute"));
        }
        PsiDirectory containingDirectory = foothold.getContainingDirectory();
        if (containingDirectory != null && (containingPath = QualifiedNameFinder.findCanonicalImportPath((PsiElement)containingDirectory, null)) != null && containingPath.getComponentCount() > 0) {
            QualifiedName absolutePath = containingPath.append(qualifiedName.toString());
            QualifiedNameResolver absoluteVisitor = new QualifiedNameResolverImpl(absolutePath).fromElement((PsiElement)foothold);
            List<PsiElement> list = absoluteVisitor.resultsAsList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "resolveRelativeImportAsAbsolute"));
            }
            return list;
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "resolveRelativeImportAsAbsolute"));
        }
        return list;
    }

    @Nullable
    public static PsiElement resolveModuleInRoots(@NotNull QualifiedName moduleQualifiedName, @Nullable PsiElement foothold) {
        if (moduleQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleQualifiedName", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "resolveModuleInRoots"));
        }
        if (foothold == null) {
            return null;
        }
        QualifiedNameResolver visitor = new QualifiedNameResolverImpl(moduleQualifiedName).fromElement(foothold);
        return visitor.firstResult();
    }

    @Nullable
    static PythonPathCache getPathCache(PsiElement foothold) {
        PythonPathCache cache = null;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)foothold);
        if (module != null) {
            cache = PythonModulePathCache.getInstance(module);
        } else {
            Sdk sdk = PyBuiltinCache.findSdkForFile((PsiFileSystemItem)foothold.getContainingFile());
            if (sdk != null) {
                cache = PythonSdkPathCache.getInstance(foothold.getProject(), sdk);
            }
        }
        return cache;
    }

    @Nullable
    public static PsiElement resolveChild(@Nullable PsiElement parent, @NotNull String referencedName, @Nullable PsiFile containingFile, boolean fileOnly, boolean checkForPackage) {
        List<? extends RatedResolveResult> result;
        PyType refType;
        if (referencedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedName", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "resolveChild"));
        }
        PsiDirectory dir = null;
        PsiElement ret = null;
        PsiElement possible_ret = null;
        PyResolveContext resolveContext = PyResolveContext.defaultContext();
        if (parent instanceof PyFileImpl) {
            PyModuleType moduleType;
            List<? extends RatedResolveResult> results;
            PsiElement moduleMember;
            if ("__init__.py".equals(((PyFile)parent).getName())) {
                dir = ((PyFile)parent).getContainingDirectory();
                possible_ret = ResolveImportUtil.resolveInDirectory(referencedName, containingFile, dir, fileOnly, checkForPackage);
            }
            PsiElement psiElement = moduleMember = (results = (moduleType = new PyModuleType((PyFile)parent)).resolveMember(referencedName, null, AccessDirection.READ, resolveContext)) != null && !results.isEmpty() ? results.get(0).getElement() : null;
            if (!fileOnly || PyUtil.instanceOf(moduleMember, PsiFile.class, PsiDirectory.class)) {
                ret = moduleMember;
            }
            if (ret != null && !PyUtil.instanceOf(ret, PsiFile.class, PsiDirectory.class) && PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)ret, PyExceptPart.class) == null) {
                return ret;
            }
            if (possible_ret != null) {
                return possible_ret;
            }
        } else if (parent instanceof PsiDirectory) {
            dir = (PsiDirectory)parent;
        } else if (parent != null && (refType = PyReferenceExpressionImpl.getReferenceTypeFromProviders(parent, resolveContext.getTypeEvalContext(), null)) != null && (result = refType.resolveMember(referencedName, null, AccessDirection.READ, resolveContext)) != null && !result.isEmpty()) {
            return result.get(0).getElement();
        }
        if (dir != null) {
            List<PsiElement> items;
            PsiElement result2 = ResolveImportUtil.resolveInDirectory(referencedName, containingFile, dir, fileOnly, checkForPackage);
            if (result2 != null) {
                return result2;
            }
            if (parent instanceof PsiFile && !(items = ResolveImportUtil.resolveRelativeImportAsAbsolute((PsiFile)parent, QualifiedName.fromComponents((String[])new String[]{referencedName}))).isEmpty()) {
                return items.get(0);
            }
        }
        return ret;
    }

    @Nullable
    private static PsiElement resolveInDirectory(String referencedName, @Nullable PsiFile containingFile, PsiDirectory dir, boolean isFileOnly, boolean checkForPackage) {
        if (referencedName == null) {
            return null;
        }
        PsiDirectory subdir = dir.findSubdirectory(referencedName);
        if (subdir != null && (!checkForPackage || PyUtil.isPackage(subdir, (PsiElement)containingFile))) {
            return subdir;
        }
        PsiFile module = ResolveImportUtil.findPyFileInDir(dir, referencedName);
        if (module != null) {
            return module;
        }
        if (!isFileOnly) {
            PsiFile initPy = dir.findFile("__init__.py");
            if (initPy == containingFile) {
                return null;
            }
            if (initPy instanceof PyFile) {
                return ((PyFile)initPy).getElementNamed(referencedName);
            }
        }
        return null;
    }

    @Nullable
    private static PsiFile findPyFileInDir(PsiDirectory dir, String referencedName) {
        PsiFile file = dir.findFile(referencedName + ".py");
        if (file == null) {
            FileNameMatcher association;
            List associations = FileTypeManager.getInstance().getAssociations((FileType)PythonFileType.INSTANCE);
            Iterator i$ = associations.iterator();
            while (i$.hasNext() && (!((association = (FileNameMatcher)i$.next()) instanceof ExtensionFileNameMatcher) || (file = dir.findFile(referencedName + "." + ((ExtensionFileNameMatcher)association).getExtension())) == null)) {
            }
        }
        if (file != null && FileUtil.getNameWithoutExtension((String)file.getName()).equals(referencedName)) {
            return file;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static ResolveResultList rateResults(List<? extends PsiElement> targets) {
        ResolveResultList ret = new ResolveResultList();
        for (PsiElement psiElement : targets) {
            void var3_3;
            if (psiElement instanceof PsiDirectory) {
                PsiElement psiElement2 = PyUtil.getPackageElement((PsiDirectory)psiElement, null);
            }
            if (var3_3 == null) continue;
            int rate = 1000;
            if (var3_3 instanceof PyFile) {
                VirtualFile vFile = ((PyFile)var3_3).getVirtualFile();
                if (vFile != null && vFile.getLength() > 0L) {
                    rate += 100;
                }
                for (PyResolveResultRater rater : (PyResolveResultRater[])Extensions.getExtensions(PyResolveResultRater.EP_NAME)) {
                    rate += rater.getRate((PsiElement)var3_3);
                }
            }
            ret.poke((PsiElement)var3_3, rate);
        }
        return ret;
    }

    @NotNull
    public static PointInImport getPointInImport(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "getPointInImport"));
        }
        PsiElement parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PyImportElement.class, PyFromImportStatement.class});
        if (parent instanceof PyFromImportStatement) {
            PointInImport pointInImport = PointInImport.AS_MODULE;
            if (pointInImport == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "getPointInImport"));
            }
            return pointInImport;
        }
        if (parent instanceof PyImportElement) {
            PsiElement statement = parent.getParent();
            if (statement instanceof PyImportStatement) {
                PointInImport pointInImport = PointInImport.AS_MODULE;
                if (pointInImport == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "getPointInImport"));
                }
                return pointInImport;
            }
            if (statement instanceof PyFromImportStatement) {
                PointInImport pointInImport = PointInImport.AS_NAME;
                if (pointInImport == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "getPointInImport"));
                }
                return pointInImport;
            }
        }
        PointInImport pointInImport = PointInImport.NONE;
        if (pointInImport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/ResolveImportUtil", "getPointInImport"));
        }
        return pointInImport;
    }
}

