/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.facet.PythonPathContributingFacet;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyImportResolver;
import com.jetbrains.python.psi.resolve.PythonModulePathCache;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.QualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameResolver;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.resolve.RootVisitor;
import com.jetbrains.python.psi.resolve.RootVisitorHost;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifiedNameResolverImpl
implements RootVisitor,
QualifiedNameResolver {
    boolean myCheckForPackage;
    private final QualifiedNameResolveContext myContext;
    @NotNull
    private final QualifiedName myQualifiedName;
    final Set<PsiElement> mySourceResults;
    final Set<PsiElement> myLibResults;
    final Set<PsiElement> myForeignResults;
    private boolean myVisitAllModules;
    private int myRelativeLevel;
    private boolean myWithoutRoots;
    private boolean myWithoutForeign;
    private boolean myWithMembers;

    public QualifiedNameResolverImpl(@NotNull String qNameString) {
        if (qNameString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qNameString", "com/jetbrains/python/psi/resolve/QualifiedNameResolverImpl", "<init>"));
        }
        this.myCheckForPackage = true;
        this.myContext = new QualifiedNameResolveContext();
        this.mySourceResults = Sets.newLinkedHashSet();
        this.myLibResults = Sets.newLinkedHashSet();
        this.myForeignResults = Sets.newLinkedHashSet();
        this.myVisitAllModules = false;
        this.myRelativeLevel = -1;
        this.myQualifiedName = QualifiedName.fromDottedString((String)qNameString);
    }

    public QualifiedNameResolverImpl(@NotNull QualifiedName qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/jetbrains/python/psi/resolve/QualifiedNameResolverImpl", "<init>"));
        }
        this.myCheckForPackage = true;
        this.myContext = new QualifiedNameResolveContext();
        this.mySourceResults = Sets.newLinkedHashSet();
        this.myLibResults = Sets.newLinkedHashSet();
        this.myForeignResults = Sets.newLinkedHashSet();
        this.myVisitAllModules = false;
        this.myRelativeLevel = -1;
        this.myQualifiedName = qName;
    }

    @Override
    public QualifiedNameResolver withContext(QualifiedNameResolveContext context) {
        this.myContext.copyFrom(context);
        return this;
    }

    @Override
    public QualifiedNameResolver fromElement(@NotNull PsiElement foothold) {
        if (foothold == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foothold", "com/jetbrains/python/psi/resolve/QualifiedNameResolverImpl", "fromElement"));
        }
        this.myContext.setFromElement(foothold);
        if (PydevConsoleRunner.isInPydevConsole(foothold)) {
            this.withAllModules();
            Sdk sdk = PydevConsoleRunner.getConsoleSdk(foothold);
            if (sdk != null) {
                this.myContext.setSdk(sdk);
            }
        }
        return this;
    }

    @Override
    public QualifiedNameResolver fromModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/psi/resolve/QualifiedNameResolverImpl", "fromModule"));
        }
        this.myContext.setFromModule(module);
        return this;
    }

    @Override
    public QualifiedNameResolver fromSdk(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/resolve/QualifiedNameResolverImpl", "fromSdk"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/psi/resolve/QualifiedNameResolverImpl", "fromSdk"));
        }
        this.myContext.setFromSdk(project, sdk);
        return this;
    }

    private boolean isAcceptRootAsTopLevelPackage() {
        Module module = this.myContext.getModule();
        if (module != null) {
            Facet[] facets;
            for (Facet facet : facets = FacetManager.getInstance((Module)module).getAllFacets()) {
                if (!(facet instanceof PythonPathContributingFacet) || !((PythonPathContributingFacet)facet).acceptRootAsTopLevelPackage()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public QualifiedNameResolver withAllModules() {
        this.myVisitAllModules = true;
        return this;
    }

    @Override
    public QualifiedNameResolver withSdk(Sdk sdk) {
        this.myContext.setSdk(sdk);
        return this;
    }

    @Override
    public QualifiedNameResolver withRelative(int relativeLevel) {
        this.myRelativeLevel = relativeLevel;
        return this;
    }

    @Override
    public QualifiedNameResolver withoutRoots() {
        this.myWithoutRoots = true;
        return this;
    }

    @Override
    public QualifiedNameResolver withoutForeign() {
        this.myWithoutForeign = true;
        return this;
    }

    @Override
    public QualifiedNameResolver withMembers() {
        this.myWithMembers = true;
        return this;
    }

    @Override
    public QualifiedNameResolver withPlainDirectories() {
        this.myCheckForPackage = false;
        return this;
    }

    @Override
    public boolean visitRoot(VirtualFile root, @Nullable Module module, @Nullable Sdk sdk, boolean isModuleSource) {
        if (!root.isValid()) {
            return true;
        }
        if (root.equals(PyUserSkeletonsUtil.getUserSkeletonsDirectory())) {
            return true;
        }
        PsiElement resolveResult = this.resolveInRoot(root);
        if (resolveResult != null) {
            this.addRoot(resolveResult, isModuleSource);
        }
        if (this.isAcceptRootAsTopLevelPackage() && this.myQualifiedName.matchesPrefix(QualifiedName.fromDottedString((String)root.getName())) && (resolveResult = this.resolveInRoot(root.getParent())) != null) {
            this.addRoot(resolveResult, isModuleSource);
        }
        return true;
    }

    private void addRoot(PsiElement resolveResult, boolean isModuleSource) {
        if (isModuleSource) {
            this.mySourceResults.add(resolveResult);
        } else {
            this.myLibResults.add(resolveResult);
        }
    }

    @Override
    @NotNull
    public List<PsiElement> resultsAsList() {
        List<PsiElement> cachedResults;
        PythonPathCache cache;
        boolean mayCache;
        if (!this.myContext.isValid()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/QualifiedNameResolverImpl", "resultsAsList"));
            }
            return list;
        }
        PsiFile footholdFile = this.myContext.getFootholdFile();
        if (this.myRelativeLevel >= 0 && footholdFile != null && !PyUserSkeletonsUtil.isUnderUserSkeletonsDirectory(footholdFile)) {
            PsiElement module;
            PsiDirectory dir = footholdFile.getContainingDirectory();
            if (this.myRelativeLevel > 0) {
                dir = ResolveImportUtil.stepBackFrom(footholdFile, this.myRelativeLevel);
            }
            if ((module = this.resolveModuleAt(dir)) != null) {
                this.addRoot(module, true);
            }
        }
        boolean bl = mayCache = (cache = this.findMyCache()) != null && !this.myWithoutRoots && !this.myWithoutForeign;
        if (mayCache && (cachedResults = cache.get(this.myQualifiedName)) != null) {
            this.mySourceResults.addAll(cachedResults);
            ArrayList arrayList = Lists.newArrayList(this.mySourceResults);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/QualifiedNameResolverImpl", "resultsAsList"));
            }
            return arrayList;
        }
        if (!this.myWithoutRoots) {
            this.addResultsFromRoots();
        } else if (footholdFile != null) {
            this.addRelativeImportResultsFromSkeletons(footholdFile);
        }
        this.mySourceResults.addAll(this.myLibResults);
        this.myLibResults.clear();
        if (!this.myWithoutForeign) {
            for (PyImportResolver resolver : (PyImportResolver[])Extensions.getExtensions(PyImportResolver.EP_NAME)) {
                PsiElement foreign = resolver.resolveImportReference(this.myQualifiedName, this.myContext);
                if (foreign == null) continue;
                this.myForeignResults.add(foreign);
            }
            this.mySourceResults.addAll(this.myForeignResults);
            this.myForeignResults.clear();
        }
        ArrayList results = Lists.newArrayList(this.mySourceResults);
        if (mayCache) {
            cache.put(this.myQualifiedName, results);
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/QualifiedNameResolverImpl", "resultsAsList"));
        }
        return arrayList;
    }

    private void addRelativeImportResultsFromSkeletons(@NotNull PsiFile foothold) {
        QualifiedName containingQName;
        if (foothold == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foothold", "com/jetbrains/python/psi/resolve/QualifiedNameResolverImpl", "addRelativeImportResultsFromSkeletons"));
        }
        boolean inSource = FileIndexFacade.getInstance((Project)foothold.getProject()).isInContent(foothold.getVirtualFile());
        if (inSource) {
            return;
        }
        PsiDirectory containingDirectory = foothold.getContainingDirectory();
        if (this.myRelativeLevel > 0) {
            containingDirectory = ResolveImportUtil.stepBackFrom(foothold, this.myRelativeLevel);
        }
        if (containingDirectory != null && (containingQName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)containingDirectory, null)) != null && containingQName.getComponentCount() > 0) {
            QualifiedName absoluteQName = containingQName.append(this.myQualifiedName.toString());
            QualifiedNameResolverImpl absoluteVisitor = (QualifiedNameResolverImpl)new QualifiedNameResolverImpl(absoluteQName).fromElement((PsiElement)foothold);
            Sdk sdk = PythonSdkType.getSdk((PsiElement)foothold);
            if (sdk == null) {
                return;
            }
            VirtualFile skeletonsDir = PySdkUtil.findSkeletonsDir(sdk);
            if (skeletonsDir == null) {
                return;
            }
            PsiDirectory directory = this.myContext.getPsiManager().findDirectory(skeletonsDir);
            PsiElement psiElement = absoluteVisitor.resolveModuleAt(directory);
            if (psiElement != null) {
                this.myLibResults.add(psiElement);
            }
        }
    }

    private void addResultsFromRoots() {
        if (this.myVisitAllModules) {
            for (Module mod : ModuleManager.getInstance((Project)this.myContext.getProject()).getModules()) {
                RootVisitorHost.visitRoots(mod, true, this);
            }
            if (this.myContext.getSdk() != null) {
                RootVisitorHost.visitSdkRoots(this.myContext.getSdk(), (RootVisitor)this);
            } else if (this.myContext.getFootholdFile() != null) {
                RootVisitorHost.visitSdkRoots(this.myContext.getFootholdFile(), (RootVisitor)this);
            }
        } else if (this.myContext.getModule() != null) {
            boolean otherSdk = this.withOtherSdk();
            RootVisitorHost.visitRoots(this.myContext.getModule(), otherSdk, this);
            if (otherSdk) {
                RootVisitorHost.visitSdkRoots(this.myContext.getSdk(), (RootVisitor)this);
            }
        } else if (this.myContext.getFootholdFile() != null) {
            RootVisitorHost.visitSdkRoots(this.myContext.getFootholdFile(), (RootVisitor)this);
        } else if (this.myContext.getSdk() != null) {
            RootVisitorHost.visitSdkRoots(this.myContext.getSdk(), (RootVisitor)this);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    @Nullable
    public PsiElement firstResult() {
        List<PsiElement> results = this.resultsAsList();
        return results.size() > 0 ? results.get(0) : null;
    }

    @Override
    @NotNull
    public <T extends PsiElement> List<T> resultsOfType(Class<T> clazz) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement element : this.resultsAsList()) {
            if (!clazz.isInstance(element)) continue;
            result.add(element);
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/QualifiedNameResolverImpl", "resultsOfType"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public <T extends PsiElement> T firstResultOfType(Class<T> clazz) {
        List<T> list = this.resultsOfType(clazz);
        return (T)(list.size() > 0 ? (PsiElement)list.get(0) : null);
    }

    private boolean withOtherSdk() {
        return this.myContext.getSdk() != null && this.myContext.getSdk() != PythonSdkType.findPythonSdk(this.myContext.getModule());
    }

    @Nullable
    private PythonPathCache findMyCache() {
        Sdk sdk;
        if (this.myVisitAllModules) {
            return null;
        }
        if (this.myContext.getModule() != null) {
            return this.withOtherSdk() ? null : PythonModulePathCache.getInstance(this.myContext.getModule());
        }
        if (this.myContext.getFootholdFile() != null && (sdk = PyBuiltinCache.findSdkForNonModuleFile((PsiFileSystemItem)this.myContext.getFootholdFile())) != null) {
            return PythonSdkPathCache.getInstance(this.myContext.getProject(), sdk);
        }
        return null;
    }

    @Nullable
    private PsiElement resolveInRoot(VirtualFile root) {
        if (!root.isDirectory()) {
            return null;
        }
        return this.resolveModuleAt(this.myContext.getPsiManager().findDirectory(root));
    }

    @Nullable
    public PsiElement resolveModuleAt(@Nullable PsiDirectory directory) {
        if (directory == null || !directory.isValid()) {
            return null;
        }
        PsiDirectory seeker = directory;
        for (String name : this.myQualifiedName.getComponents()) {
            if (name == null) {
                return null;
            }
            seeker = ResolveImportUtil.resolveChild((PsiElement)seeker, name, this.myContext.getFootholdFile(), !this.myWithMembers, this.myCheckForPackage);
        }
        return seeker;
    }

    @Override
    public Module getModule() {
        return this.myContext.getModule();
    }

    @Override
    @Nullable
    public <T extends PsiNamedElement> T resolveTopLevelMember(@NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/python/psi/resolve/QualifiedNameResolverImpl", "resolveTopLevelMember"));
        }
        Preconditions.checkState((this.getModule() != null ? 1 : 0) != 0, (Object)"Module is not set");
        String memberName = this.myQualifiedName.getLastComponent();
        if (memberName == null) {
            return null;
        }
        PyFile file = new QualifiedNameResolverImpl(this.myQualifiedName.removeLastComponent()).fromModule(this.getModule()).firstResultOfType(PyFile.class);
        if (file == null) {
            return null;
        }
        for (PsiNamedElement element : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)file, aClass)) {
            if (!memberName.equals(element.getName())) continue;
            return (T)element;
        }
        return null;
    }
}

