/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifiedNameResolveContext {
    @Nullable
    private Module myModule;
    private PsiFile myFootholdFile;
    @NotNull
    PsiManager myPsiManager;
    private Sdk mySdk;

    public void copyFrom(QualifiedNameResolveContext context) {
        this.myModule = context.getModule();
        this.myPsiManager = context.getPsiManager();
        this.mySdk = context.getSdk();
        this.myFootholdFile = context.getFootholdFile();
    }

    public void setFromElement(PsiElement foothold) {
        this.myFootholdFile = foothold instanceof PsiDirectory ? ((PsiDirectory)foothold).findFile("__init__.py") : foothold.getContainingFile().getOriginalFile();
        this.myPsiManager = foothold.getManager();
        this.myModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)foothold);
    }

    public void setFromModule(Module module) {
        this.myModule = module;
        this.myPsiManager = PsiManager.getInstance((Project)module.getProject());
    }

    public void setFromSdk(Project project, Sdk sdk) {
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.mySdk = sdk;
    }

    public void setSdk(Sdk sdk) {
        this.mySdk = sdk;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    public boolean isValid() {
        if (this.myFootholdFile != null) {
            return this.myFootholdFile.isValid();
        }
        return true;
    }

    @Nullable
    public PsiFile getFootholdFile() {
        return this.myFootholdFile;
    }

    @NotNull
    public PsiManager getPsiManager() {
        PsiManager psiManager = this.myPsiManager;
        if (psiManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/QualifiedNameResolveContext", "getPsiManager"));
        }
        return psiManager;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myPsiManager.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/QualifiedNameResolveContext", "getProject"));
        }
        return project;
    }

    public Sdk getSdk() {
        return this.mySdk;
    }
}

