/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyCanonicalPathProvider;
import com.jetbrains.python.psi.resolve.PythonModulePathCache;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.resolve.RootVisitor;
import com.jetbrains.python.psi.resolve.RootVisitorHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifiedNameFinder {
    @Nullable
    public static String findShortestImportableName(@NotNull PsiElement foothold, @NotNull VirtualFile vfile) {
        if (foothold == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foothold", "com/jetbrains/python/psi/resolve/QualifiedNameFinder", "findShortestImportableName"));
        }
        if (vfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfile", "com/jetbrains/python/psi/resolve/QualifiedNameFinder", "findShortestImportableName"));
        }
        QualifiedName qName = QualifiedNameFinder.findShortestImportableQName(foothold, vfile);
        return qName == null ? null : qName.toString();
    }

    @Nullable
    public static QualifiedName findShortestImportableQName(@Nullable PsiFileSystemItem fsItem) {
        VirtualFile vFile = fsItem != null ? fsItem.getVirtualFile() : null;
        return vFile != null ? QualifiedNameFinder.findShortestImportableQName((PsiElement)fsItem, vFile) : null;
    }

    @Nullable
    public static QualifiedName findShortestImportableQName(@NotNull PsiElement foothold, @NotNull VirtualFile vfile) {
        if (foothold == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foothold", "com/jetbrains/python/psi/resolve/QualifiedNameFinder", "findShortestImportableQName"));
        }
        if (vfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfile", "com/jetbrains/python/psi/resolve/QualifiedNameFinder", "findShortestImportableQName"));
        }
        return QualifiedNameFinder.shortestQName(QualifiedNameFinder.findImportableQNames(foothold, vfile));
    }

    @NotNull
    public static List<QualifiedName> findImportableQNames(@NotNull PsiElement foothold, @NotNull VirtualFile vfile) {
        List<QualifiedName> names;
        if (foothold == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foothold", "com/jetbrains/python/psi/resolve/QualifiedNameFinder", "findImportableQNames"));
        }
        if (vfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfile", "com/jetbrains/python/psi/resolve/QualifiedNameFinder", "findImportableQNames"));
        }
        PythonPathCache cache = ResolveImportUtil.getPathCache(foothold);
        List<QualifiedName> list = names = cache != null ? cache.getNames(vfile) : null;
        if (names != null) {
            List<QualifiedName> list2 = names;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/QualifiedNameFinder", "findImportableQNames"));
            }
            return list2;
        }
        PathChoosingVisitor visitor = new PathChoosingVisitor(vfile);
        RootVisitorHost.visitRoots(foothold, visitor);
        List<QualifiedName> results = visitor.getResults();
        if (cache != null) {
            cache.putNames(vfile, results);
        }
        List<QualifiedName> list3 = results;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/QualifiedNameFinder", "findImportableQNames"));
        }
        return list3;
    }

    @Nullable
    private static QualifiedName shortestQName(@NotNull List<QualifiedName> qNames) {
        if (qNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qNames", "com/jetbrains/python/psi/resolve/QualifiedNameFinder", "shortestQName"));
        }
        QualifiedName result = null;
        for (QualifiedName name : qNames) {
            if (result != null && name.getComponentCount() >= result.getComponentCount()) continue;
            result = name;
        }
        return result;
    }

    @Nullable
    public static String findShortestImportableName(Module module, @NotNull VirtualFile vfile) {
        if (vfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfile", "com/jetbrains/python/psi/resolve/QualifiedNameFinder", "findShortestImportableName"));
        }
        PythonPathCache cache = PythonModulePathCache.getInstance(module);
        List<QualifiedName> names = cache.getNames(vfile);
        if (names != null) {
            return names.toString();
        }
        PathChoosingVisitor visitor = new PathChoosingVisitor(vfile);
        RootVisitorHost.visitRoots(module, false, visitor);
        List<QualifiedName> results = visitor.getResults();
        cache.putNames(vfile, results);
        QualifiedName qName = QualifiedNameFinder.shortestQName(results);
        return qName == null ? null : qName.toString();
    }

    @Nullable
    public static QualifiedName findCanonicalImportPath(@NotNull PsiElement symbol, @Nullable PsiElement foothold) {
        QualifiedName qname;
        PsiFileSystemItem srcfile;
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/python/psi/resolve/QualifiedNameFinder", "findCanonicalImportPath"));
        }
        Object object = srcfile = symbol instanceof PsiFileSystemItem ? (PsiFileSystemItem)symbol : symbol.getContainingFile();
        if (srcfile == null) {
            return null;
        }
        VirtualFile virtualFile = srcfile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (srcfile instanceof PsiFile && symbol instanceof PsiNamedElement && !(symbol instanceof PsiFileSystemItem)) {
            PsiFile initPy;
            PyClass containingClass;
            PsiElement toplevel = symbol;
            if (symbol instanceof PyFunction && (containingClass = ((PyFunction)symbol).getContainingClass()) != null) {
                toplevel = containingClass;
            }
            for (PsiDirectory dir = ((PsiFile)srcfile).getContainingDirectory(); dir != null && (initPy = dir.findFile("__init__.py")) != null; dir = dir.getParentDirectory()) {
                if (!(initPy instanceof PyFile) || !toplevel.equals(((PyFile)initPy).getElementNamed(((PsiNamedElement)toplevel).getName()))) continue;
                virtualFile = dir.getVirtualFile();
            }
        }
        if ((qname = QualifiedNameFinder.findShortestImportableQName(foothold != null ? foothold : symbol, virtualFile)) != null) {
            for (PyCanonicalPathProvider provider : (PyCanonicalPathProvider[])Extensions.getExtensions(PyCanonicalPathProvider.EP_NAME)) {
                QualifiedName restored = provider.getCanonicalPath(qname, foothold);
                if (restored == null) continue;
                return restored;
            }
        }
        return qname;
    }

    @Nullable
    public static String getQualifiedName(@NotNull PyElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/resolve/QualifiedNameFinder", "getQualifiedName"));
        }
        String name = element.getName();
        if (name != null) {
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)element);
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance((PsiElement)element);
            if (owner instanceof PyClass) {
                String classQName = ((PyClass)owner).getQualifiedName();
                if (classQName != null) {
                    return classQName + "." + name;
                }
            } else if (owner instanceof PyFile) {
                String fileQName;
                if (builtinCache.isBuiltin((PsiElement)element)) {
                    return name;
                }
                VirtualFile virtualFile = ((PyFile)owner).getVirtualFile();
                if (virtualFile != null && (fileQName = QualifiedNameFinder.findShortestImportableName((PsiElement)element, virtualFile)) != null) {
                    return fileQName + "." + name;
                }
            }
        }
        return null;
    }

    private static class PathChoosingVisitor
    implements RootVisitor {
        @Nullable
        private final VirtualFile myVFile;
        @NotNull
        private final List<QualifiedName> myResults;

        private PathChoosingVisitor(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/resolve/QualifiedNameFinder$PathChoosingVisitor", "<init>"));
            }
            this.myResults = new ArrayList<QualifiedName>();
            this.myVFile = !file.isDirectory() && file.getName().equals("__init__.py") ? file.getParent() : file;
        }

        @Override
        public boolean visitRoot(VirtualFile root, Module module, Sdk sdk, boolean isModuleSource) {
            String relativePath;
            if (this.myVFile != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)this.myVFile, (VirtualFile)root, (char)'/')) != null && !relativePath.isEmpty()) {
                List result = StringUtil.split((String)relativePath, (String)"/");
                if (result.size() > 0) {
                    result.set(result.size() - 1, FileUtil.getNameWithoutExtension((String)((String)result.get(result.size() - 1))));
                }
                for (String component : result) {
                    if (PyNames.isIdentifier(component)) continue;
                    return true;
                }
                this.myResults.add(QualifiedName.fromComponents((Collection)result));
            }
            return true;
        }

        @NotNull
        public List<QualifiedName> getResults() {
            List<QualifiedName> list = this.myResults;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/QualifiedNameFinder$PathChoosingVisitor", "getResults"));
            }
            return list;
        }
    }
}

