/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.WeakHashMap;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PythonModulePathCache;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class PythonSdkPathCache
extends PythonPathCache
implements Disposable {
    private static final Key<Map<Project, PythonSdkPathCache>> KEY = Key.create((String)"PythonPathCache");
    private final Project myProject;
    private final Sdk mySdk;
    private final AtomicReference<PyBuiltinCache> myBuiltins;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PythonSdkPathCache getInstance(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/resolve/PythonSdkPathCache", "getInstance"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/psi/resolve/PythonSdkPathCache", "getInstance"));
        }
        Key<Map<Project, PythonSdkPathCache>> key = KEY;
        synchronized (key) {
            PythonSdkPathCache cache;
            Map cacheMap = (Map)sdk.getUserData(KEY);
            if (cacheMap == null) {
                cacheMap = new WeakHashMap();
                sdk.putUserData(KEY, (Object)cacheMap);
            }
            if ((cache = (PythonSdkPathCache)cacheMap.get(project)) == null) {
                cache = new PythonSdkPathCache(project, sdk);
                cacheMap.put(project, cache);
            }
            return cache;
        }
    }

    public PythonSdkPathCache(final @NotNull Project project, final @NotNull Sdk sdk) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/resolve/PythonSdkPathCache", "<init>"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/psi/resolve/PythonSdkPathCache", "<init>"));
        }
        this.myBuiltins = new AtomicReference();
        this.myProject = project;
        this.mySdk = sdk;
        sdk.getRootProvider().addRootSetChangedListener(new RootProvider.RootSetChangedListener(){

            public void rootSetChanged(RootProvider wrapper) {
                PythonSdkPathCache.this.clearCache();
                if (!project.isDisposed()) {
                    Module[] modules;
                    for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                        PythonModulePathCache.getInstance(module).clearCache();
                    }
                }
                PythonSdkPathCache.this.myBuiltins.set(null);
            }
        }, (Disposable)this);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new PythonPathCache.MyVirtualFileAdapter(), (Disposable)this);
        if (!project.isDisposed()) {
            project.getMessageBus().connect((Disposable)this).subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)new ProjectJdkTable.Listener(){

                public void jdkAdded(Sdk jdk) {
                }

                public void jdkRemoved(Sdk jdk) {
                    if (jdk == sdk) {
                        Disposer.dispose((Disposable)PythonSdkPathCache.this);
                    }
                }

                public void jdkNameChanged(Sdk jdk, String previousName) {
                }
            });
            Disposer.register((Disposable)project, (Disposable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.mySdk != null) {
            Key<Map<Project, PythonSdkPathCache>> key = KEY;
            synchronized (key) {
                Map cacheMap = (Map)this.mySdk.getUserData(KEY);
                if (cacheMap != null) {
                    cacheMap.remove(this.myProject);
                }
            }
        }
    }

    @NotNull
    public PyBuiltinCache getBuiltins() {
        PyBuiltinCache pyBuiltinCache;
        while ((pyBuiltinCache = this.myBuiltins.get()) == null || !pyBuiltinCache.isValid()) {
            PyBuiltinCache newCache = new PyBuiltinCache(PyBuiltinCache.getBuiltinsForSdk(this.myProject, this.mySdk), PyBuiltinCache.getSkeletonFile(this.myProject, this.mySdk, "exceptions.py"));
            if (!this.myBuiltins.compareAndSet(pyBuiltinCache, newCache)) continue;
            PyBuiltinCache pyBuiltinCache2 = newCache;
            if (pyBuiltinCache2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/PythonSdkPathCache", "getBuiltins"));
            }
            return pyBuiltinCache2;
        }
        PyBuiltinCache pyBuiltinCache3 = pyBuiltinCache;
        if (pyBuiltinCache3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/PythonSdkPathCache", "getBuiltins"));
        }
        return pyBuiltinCache3;
    }

    public void clearBuiltins() {
        this.myBuiltins.set(null);
    }
}

