/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class PythonPathCache {
    private final Map<QualifiedName, List<PsiElement>> myCache = new HashMap<QualifiedName, List<PsiElement>>();
    private final Map<VirtualFile, List<QualifiedName>> myQNameCache = new HashMap<VirtualFile, List<QualifiedName>>();

    public void clearCache() {
        this.myCache.clear();
        this.myQNameCache.clear();
    }

    public synchronized List<PsiElement> get(QualifiedName qualifiedName) {
        return this.myCache.get(qualifiedName);
    }

    public synchronized void put(QualifiedName qualifiedName, List<PsiElement> results) {
        this.myCache.put(qualifiedName, results);
    }

    public synchronized List<QualifiedName> getNames(VirtualFile vFile) {
        return this.myQNameCache.get(vFile);
    }

    public synchronized void putNames(VirtualFile vFile, List<QualifiedName> qNames) {
        this.myQNameCache.put(vFile, qNames);
    }

    protected class MyVirtualFileAdapter
    extends VirtualFileAdapter {
        protected MyVirtualFileAdapter() {
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/resolve/PythonPathCache$MyVirtualFileAdapter", "fileCreated"));
            }
            PythonPathCache.this.clearCache();
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/resolve/PythonPathCache$MyVirtualFileAdapter", "fileDeleted"));
            }
            PythonPathCache.this.clearCache();
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/resolve/PythonPathCache$MyVirtualFileAdapter", "fileMoved"));
            }
            PythonPathCache.this.clearCache();
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/resolve/PythonPathCache$MyVirtualFileAdapter", "fileCopied"));
            }
            PythonPathCache.this.clearCache();
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/resolve/PythonPathCache$MyVirtualFileAdapter", "propertyChanged"));
            }
            if (event.getPropertyName().equals("name")) {
                PythonPathCache.this.clearCache();
            }
        }
    }
}

