/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.sdk.PythonSdkType;

public class PythonModulePathCache
extends PythonPathCache
implements Disposable {
    public static PythonPathCache getInstance(Module module) {
        return (PythonPathCache)ModuleServiceManager.getService((Module)module, PythonPathCache.class);
    }

    public PythonModulePathCache(final Module module) {
        module.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                PythonModulePathCache.updateCacheForSdk(module);
                PythonModulePathCache.this.clearCache();
            }
        });
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new PythonPathCache.MyVirtualFileAdapter(this), (Disposable)this);
        PythonModulePathCache.updateCacheForSdk(module);
    }

    private static void updateCacheForSdk(Module module) {
        Sdk sdk = PythonSdkType.findPythonSdk(module);
        if (sdk != null) {
            PythonSdkPathCache.getInstance(module.getProject(), sdk);
        }
    }

    public void dispose() {
    }
}

