/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.PyReferenceResolveProvider;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PythonBuiltinReferenceResolveProvider
implements PyReferenceResolveProvider {
    @Override
    @NotNull
    public List<RatedResolveResult> resolveName(@NotNull PyQualifiedExpression element, @NotNull List<PsiElement> definers) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/resolve/PythonBuiltinReferenceResolveProvider", "resolveName"));
        }
        if (definers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definers", "com/jetbrains/python/psi/resolve/PythonBuiltinReferenceResolveProvider", "resolveName"));
        }
        ArrayList<RatedResolveResult> result = new ArrayList<RatedResolveResult>();
        PsiElement realContext = PyPsiUtils.getRealContext((PsiElement)element);
        String referencedName = element.getReferencedName();
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(realContext);
        PyFile bfile = builtinCache.getBuiltinsFile();
        if (bfile != null && !PyUtil.isClassPrivateName(referencedName)) {
            PsiElement resultElement = bfile.getElementNamed(referencedName);
            if (resultElement == null && "__builtins__".equals(referencedName)) {
                resultElement = bfile;
            }
            if (resultElement != null) {
                result.add(new ImportedResolveResult(resultElement, PyReferenceImpl.getRate(resultElement), definers));
            }
        }
        ArrayList<RatedResolveResult> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/PythonBuiltinReferenceResolveProvider", "resolveName"));
        }
        return arrayList;
    }
}

