/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.ResolveProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyResolveUtil {
    private PyResolveUtil() {
    }

    @Nullable
    private static PsiElement getPrevNodeOf(PsiElement elt, TokenSet elementTypes) {
        ASTNode seeker = elt.getNode();
        while (seeker != null) {
            ASTNode feeler = seeker.getTreePrev();
            if (feeler != null && (feeler.getElementType() == PyElementTypes.FUNCTION_DECLARATION || feeler.getElementType() == PyElementTypes.CLASS_DECLARATION) && elementTypes.contains(feeler.getElementType())) {
                return feeler.getPsi();
            }
            if (feeler != null) {
                seeker = TreeUtil.getLastChild(feeler);
            } else if ((seeker = seeker.getTreeParent()) instanceof FileASTNode) {
                return null;
            }
            if (seeker == null || !elementTypes.contains(seeker.getElementType())) continue;
            return seeker.getPsi();
        }
        return null;
    }

    @Nullable
    private static PsiElement getPrevNodeOf(PsiElement elt) {
        if (elt instanceof PsiFile) {
            return null;
        }
        return PyResolveUtil.getPrevNodeOf(elt, PythonDialectsTokenSetProvider.INSTANCE.getNameDefinerTokens());
    }

    public static void scopeCrawlUp(@NotNull PsiScopeProcessor processor, @NotNull PsiElement element, @Nullable String name, @Nullable PsiElement roof) {
        ScopeOwner outerScopeOwner;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/psi/resolve/PyResolveUtil", "scopeCrawlUp"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/resolve/PyResolveUtil", "scopeCrawlUp"));
        }
        PsiElement realContext = PyPsiUtils.getRealContext(element);
        ScopeOwner originalOwner = realContext != element && realContext instanceof PyFile ? (PyFile)realContext : ScopeUtil.getScopeOwner(realContext);
        PsiElement parent = element.getParent();
        boolean isGlobalOrNonlocal = parent instanceof PyGlobalStatement || parent instanceof PyNonlocalStatement;
        ScopeOwner owner = originalOwner;
        if (isGlobalOrNonlocal && (outerScopeOwner = ScopeUtil.getScopeOwner((PsiElement)owner)) != null) {
            owner = outerScopeOwner;
        }
        PyResolveUtil.scopeCrawlUp(processor, owner, originalOwner, name, roof, realContext);
    }

    public static void scopeCrawlUp(@NotNull PsiScopeProcessor processor, @NotNull ScopeOwner scopeOwner, @Nullable String name, @Nullable PsiElement roof) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/psi/resolve/PyResolveUtil", "scopeCrawlUp"));
        }
        if (scopeOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeOwner", "com/jetbrains/python/psi/resolve/PyResolveUtil", "scopeCrawlUp"));
        }
        PyResolveUtil.scopeCrawlUp(processor, scopeOwner, scopeOwner, name, roof, null);
    }

    public static void scopeCrawlUp(@NotNull PsiScopeProcessor processor, @Nullable ScopeOwner scopeOwner, @Nullable ScopeOwner originalScopeOwner, @Nullable String name, @Nullable PsiElement roof, final @Nullable PsiElement anchor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/psi/resolve/PyResolveUtil", "scopeCrawlUp"));
        }
        while (scopeOwner != null) {
            block7: {
                boolean found;
                Scope scope;
                block9: {
                    block8: {
                        if (scopeOwner instanceof PyClass && scopeOwner != originalScopeOwner) break block7;
                        scope = ControlFlowCache.getScope(scopeOwner);
                        found = false;
                        if (name == null) break block8;
                        boolean includeNestedGlobals = scopeOwner instanceof PyFile;
                        PsiNamedElement resolved = scope.getNamedElement(name, includeNestedGlobals);
                        if (resolved == null || processor.execute((PsiElement)resolved, ResolveState.initial())) break block9;
                        found = true;
                        break block9;
                    }
                    for (PsiNamedElement element : scope.getNamedElements()) {
                        if (processor.execute((PsiElement)element, ResolveState.initial())) continue;
                        found = true;
                        break;
                    }
                }
                ArrayList<PyImportedNameDefiner> definers = new ArrayList<PyImportedNameDefiner>(scope.getImportedNameDefiners());
                if (anchor != null && ScopeUtil.getScopeOwner(anchor) == scopeOwner) {
                    Comparator<NameDefiner> nearestDefinerComparator = new Comparator<NameDefiner>(){

                        @Override
                        public int compare(NameDefiner a, NameDefiner b) {
                            boolean aIsBefore = PyPsiUtils.isBefore(a, anchor);
                            boolean bIsBefore = PyPsiUtils.isBefore(b, anchor);
                            int diff = a.getTextOffset() - b.getTextOffset();
                            if (aIsBefore && bIsBefore) {
                                return -diff;
                            }
                            if (aIsBefore) {
                                return -1;
                            }
                            if (bIsBefore) {
                                return 1;
                            }
                            return diff;
                        }
                    };
                    Collections.sort(definers, nearestDefinerComparator);
                }
                for (NameDefiner nameDefiner : definers) {
                    if (processor.execute((PsiElement)nameDefiner, ResolveState.initial())) continue;
                    found = true;
                    break;
                }
                if (found) {
                    return;
                }
            }
            if (scopeOwner == roof) {
                return;
            }
            scopeOwner = ScopeUtil.getScopeOwner((PsiElement)scopeOwner);
        }
    }

    @Deprecated
    @Nullable
    public static PsiElement treeCrawlUp(PsiScopeProcessor processor, PsiElement elt) {
        if (elt == null || !elt.isValid()) {
            return null;
        }
        PsiElement seeker = elt;
        PsiElement cap = PyUtil.getConcealingParent(elt);
        PyFunction capFunction = cap != null ? (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)cap, PyFunction.class, (boolean)false) : null;
        boolean is_outside_param_list = PsiTreeUtil.getParentOfType((PsiElement)elt, PyParameterList.class) == null;
        do {
            PsiElement local_cap;
            ProgressManager.checkCanceled();
            seeker = PyResolveUtil.getPrevNodeOf(seeker);
            if (seeker instanceof NameDefiner && ((NameDefiner)seeker).mustResolveOutside() && PsiTreeUtil.isAncestor((PsiElement)seeker, (PsiElement)elt, (boolean)true)) {
                seeker = PyResolveUtil.getPrevNodeOf(seeker);
            }
            while (!((local_cap = PyUtil.getConcealingParent(seeker)) == null || local_cap == cap || cap != null && PsiTreeUtil.isAncestor((PsiElement)local_cap, (PsiElement)cap, (boolean)true) || local_cap == elt || cap != null && PsiTreeUtil.isAncestor((PsiElement)local_cap, (PsiElement)cap, (boolean)true))) {
                if (local_cap instanceof NameDefiner) {
                    seeker = local_cap;
                    continue;
                }
                seeker = PyResolveUtil.getPrevNodeOf(local_cap);
            }
            if (is_outside_param_list && PyResolveUtil.refersFromMethodToClass(capFunction, seeker) || seeker instanceof PyComprehensionElement && !PsiTreeUtil.isAncestor((PsiElement)seeker, (PsiElement)elt, (boolean)false) || seeker == null || processor.execute(seeker, ResolveState.initial())) continue;
            if (processor instanceof ResolveProcessor) {
                return ((ResolveProcessor)processor).getResult();
            }
            return seeker;
        } while (seeker != null);
        if (processor instanceof ResolveProcessor) {
            return ((ResolveProcessor)processor).getResult();
        }
        return null;
    }

    private static boolean refersFromMethodToClass(PyFunction innerFunction, PsiElement outer) {
        if (innerFunction == null) {
            return false;
        }
        PsiElement outerClass = PyUtil.getConcealingParent(outer);
        return outerClass instanceof PyClass && innerFunction.getContainingClass() == outerClass;
    }

    public static class FilterNotInstance
    implements Condition<PsiElement> {
        Object instance;

        public FilterNotInstance(Object instance) {
            this.instance = instance;
        }

        public boolean value(PsiElement target) {
            return this.instance != target;
        }
    }
}

