/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import com.jetbrains.python.codeInsight.completion.PyClassInsertHandler;
import com.jetbrains.python.codeInsight.completion.PyFunctionInsertHandler;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.VariantsProcessor;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class CompletionVariantsProcessor
extends VariantsProcessor {
    private final Map<String, LookupElement> myVariants = new HashMap<String, LookupElement>();
    private boolean mySuppressParentheses = false;

    public CompletionVariantsProcessor(PsiElement context) {
        super(context);
    }

    public CompletionVariantsProcessor(PsiElement context, @Nullable Condition<PsiElement> nodeFilter, @Nullable Condition<String> nameFilter) {
        super(context, nodeFilter, nameFilter);
    }

    public void suppressParentheses() {
        this.mySuppressParentheses = true;
    }

    protected LookupElementBuilder setupItem(LookupElementBuilder item) {
        Object object = item.getObject();
        if (!this.myPlainNamesOnly) {
            if (!this.mySuppressParentheses && object instanceof PyFunction && ((PyFunction)object).getProperty() == null && !PyUtil.hasCustomDecorators((PyFunction)object) && !CompletionVariantsProcessor.isSingleArgDecoratorCall(this.myContext, (PyFunction)object)) {
                Project project = ((PyFunction)object).getProject();
                item = item.withInsertHandler((InsertHandler)PyFunctionInsertHandler.INSTANCE);
                TypeEvalContext context = TypeEvalContext.userInitiated(project, this.myContext != null ? this.myContext.getContainingFile() : null);
                List<PyParameter> parameters = PyUtil.getParameters((PyFunction)object, context);
                String params = StringUtil.join(parameters, (Function)new Function<PyParameter, String>(){

                    public String fun(PyParameter pyParameter) {
                        return pyParameter.getName();
                    }
                }, (String)", ");
                item = item.withTailText("(" + params + ")");
            } else if (object instanceof PyClass) {
                item = item.withInsertHandler((InsertHandler)PyClassInsertHandler.INSTANCE);
            }
        }
        String source = null;
        if (object instanceof PsiElement) {
            QualifiedName path;
            ScopeOwner owner;
            PsiElement element = (PsiElement)object;
            PyClass cls = null;
            if (element instanceof PyFunction) {
                cls = ((PyFunction)element).getContainingClass();
            } else if (element instanceof PyTargetExpression) {
                PyTargetExpression expr = (PyTargetExpression)element;
                if (expr.isQualified() || ScopeUtil.getScopeOwner((PsiElement)expr) instanceof PyClass) {
                    cls = expr.getContainingClass();
                }
            } else if (element instanceof PyClass && (owner = ScopeUtil.getScopeOwner(element)) instanceof PyClass) {
                cls = (PyClass)owner;
            }
            if (cls != null) {
                source = cls.getName();
            } else if (!(this.myContext != null && PyUtil.inSameFile(this.myContext, element) || (path = QualifiedNameFinder.findCanonicalImportPath(element, null)) == null)) {
                if (element instanceof PyFile) {
                    path = path.removeLastComponent();
                }
                source = path.toString();
            }
        }
        if (source != null) {
            item = item.withTypeText(source);
        }
        return item;
    }

    private static boolean isSingleArgDecoratorCall(PsiElement elementInCall, PyFunction callee) {
        PyClass containingClass = callee.getContainingClass();
        if (containingClass != null && "property".equals(containingClass.getName()) && PyBuiltinCache.getInstance(elementInCall).isBuiltin(containingClass)) {
            return true;
        }
        if (callee.getParameterList().getParameters().length > 1) {
            return false;
        }
        PyDecorator decorator = (PyDecorator)PsiTreeUtil.getParentOfType((PsiElement)elementInCall, PyDecorator.class);
        if (decorator == null) {
            return false;
        }
        return PsiTreeUtil.isAncestor((PsiElement)decorator.getCallee(), (PsiElement)elementInCall, (boolean)false);
    }

    protected static LookupElementBuilder setItemNotice(LookupElementBuilder item, String notice) {
        return item.withTypeText(notice);
    }

    public LookupElement[] getResult() {
        Collection<LookupElement> variants = this.myVariants.values();
        return variants.toArray(new LookupElement[variants.size()]);
    }

    public List<LookupElement> getResultList() {
        return new ArrayList<LookupElement>(this.myVariants.values());
    }

    @Override
    protected void addElement(String name, PsiElement element) {
        if (PyUtil.isClassPrivateName(name) && !PyUtil.inSameFile(element, this.myContext)) {
            return;
        }
        this.myVariants.put(name, (LookupElement)this.setupItem(LookupElementBuilder.create((Object)element, (String)name).withIcon(element.getIcon(0))));
    }

    @Override
    protected void addImportedElement(String referencedName, NameDefiner definer, PyElement expr) {
        Icon icon = expr.getIcon(0);
        if (icon == null) {
            icon = PlatformIcons.VARIABLE_ICON;
        }
        LookupElementBuilder lookupItem = this.setupItem(LookupElementBuilder.create((Object)expr, (String)referencedName).withIcon(icon));
        this.myVariants.put(referencedName, (LookupElement)lookupItem);
    }
}

