/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AssignmentCollectProcessor
implements PsiScopeProcessor {
    private final QualifiedName myQualifier;
    private final List<PyExpression> myResult;
    private final Set<String> mySeenNames;

    public AssignmentCollectProcessor(@NotNull QualifiedName qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/jetbrains/python/psi/resolve/AssignmentCollectProcessor", "<init>"));
        }
        assert (qualifier.getComponentCount() > 0);
        this.myQualifier = qualifier;
        this.myResult = new ArrayList<PyExpression>();
        this.mySeenNames = new HashSet<String>();
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/resolve/AssignmentCollectProcessor", "execute"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/python/psi/resolve/AssignmentCollectProcessor", "execute"));
        }
        if (element instanceof PyAssignmentStatement) {
            PyAssignmentStatement assignment = (PyAssignmentStatement)element;
            for (PyExpression ex : assignment.getTargets()) {
                String last_elt_name;
                PyTargetExpression target;
                QualifiedName qualifiedName;
                if (!(ex instanceof PyTargetExpression) || (qualifiedName = (target = (PyTargetExpression)ex).asQualifiedName()) == null || qualifiedName.getComponentCount() != this.myQualifier.getComponentCount() + 1 || !qualifiedName.matchesPrefix(this.myQualifier) || this.mySeenNames.contains(last_elt_name = target.getName())) continue;
                this.myResult.add(target);
                this.mySeenNames.add(last_elt_name);
            }
        }
        return true;
    }

    @NotNull
    public Collection<PyExpression> getResult() {
        List<PyExpression> list = this.myResult;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/resolve/AssignmentCollectProcessor", "getResult"));
        }
        return list;
    }

    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/jetbrains/python/psi/resolve/AssignmentCollectProcessor", "getHint"));
        }
        return null;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/resolve/AssignmentCollectProcessor", "handleEvent"));
        }
    }
}

