/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.io.StringRef;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.documentation.DocStringUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStubElementType;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyTargetExpressionImpl;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStub;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStubType;
import com.jetbrains.python.psi.impl.stubs.PyTargetExpressionStubImpl;
import com.jetbrains.python.psi.stubs.PyFileStub;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import com.jetbrains.python.psi.stubs.PyInstanceAttributeIndex;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.stubs.PyVariableNameIndex;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PyTargetExpressionElementType
extends PyStubElementType<PyTargetExpressionStub, PyTargetExpression> {
    private CustomTargetExpressionStubType[] myCustomStubTypes;

    public PyTargetExpressionElementType() {
        super("TARGET_EXPRESSION");
    }

    private CustomTargetExpressionStubType[] getCustomStubTypes() {
        if (this.myCustomStubTypes == null) {
            this.myCustomStubTypes = (CustomTargetExpressionStubType[])Extensions.getExtensions(CustomTargetExpressionStubType.EP_NAME);
        }
        return this.myCustomStubTypes;
    }

    @Override
    public PsiElement createElement(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/psi/impl/stubs/PyTargetExpressionElementType", "createElement"));
        }
        return new PyTargetExpressionImpl(node);
    }

    public PyTargetExpression createPsi(@NotNull PyTargetExpressionStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/jetbrains/python/psi/impl/stubs/PyTargetExpressionElementType", "createPsi"));
        }
        return new PyTargetExpressionImpl(stub);
    }

    public PyTargetExpressionStub createStub(@NotNull PyTargetExpression psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/jetbrains/python/psi/impl/stubs/PyTargetExpressionElementType", "createStub"));
        }
        String name = psi.getName();
        PyExpression assignedValue = psi.findAssignedValue();
        String docString = DocStringUtil.getDocStringValue(psi);
        for (CustomTargetExpressionStubType customStubType : this.getCustomStubTypes()) {
            Object customStub = customStubType.createStub(psi);
            if (customStub == null) continue;
            return new PyTargetExpressionStubImpl(name, docString, (CustomTargetExpressionStub)customStub, parentStub);
        }
        PyTargetExpressionStub.InitializerType initializerType = PyTargetExpressionStub.InitializerType.Other;
        QualifiedName initializer = null;
        if (assignedValue instanceof PyReferenceExpression) {
            initializerType = PyTargetExpressionStub.InitializerType.ReferenceExpression;
            initializer = ((PyReferenceExpression)assignedValue).asQualifiedName();
        } else if (assignedValue instanceof PyCallExpression) {
            initializerType = PyTargetExpressionStub.InitializerType.CallExpression;
            PyExpression callee = ((PyCallExpression)assignedValue).getCallee();
            if (callee instanceof PyReferenceExpression) {
                initializer = ((PyReferenceExpression)callee).asQualifiedName();
            }
        }
        return new PyTargetExpressionStubImpl(name, docString, initializerType, initializer, psi.isQualified(), parentStub);
    }

    public void serialize(@NotNull PyTargetExpressionStub stub, @NotNull StubOutputStream stream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/jetbrains/python/psi/impl/stubs/PyTargetExpressionElementType", "serialize"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/jetbrains/python/psi/impl/stubs/PyTargetExpressionElementType", "serialize"));
        }
        stream.writeName(stub.getName());
        String docString = stub.getDocString();
        stream.writeUTFFast(docString != null ? docString : "");
        stream.writeVarInt(stub.getInitializerType().getIndex());
        CustomTargetExpressionStub customStub = stub.getCustomStub(CustomTargetExpressionStub.class);
        if (customStub != null) {
            stream.writeName(customStub.getTypeClass().getCanonicalName());
            customStub.serialize(stream);
        } else {
            QualifiedName.serialize((QualifiedName)stub.getInitializer(), (StubOutputStream)stream);
            stream.writeBoolean(stub.isQualified());
        }
    }

    @NotNull
    public PyTargetExpressionStub deserialize(@NotNull StubInputStream stream, StubElement parentStub) throws IOException {
        PyTargetExpressionStub.InitializerType initializerType;
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/jetbrains/python/psi/impl/stubs/PyTargetExpressionElementType", "deserialize"));
        }
        String name = StringRef.toString((StringRef)stream.readName());
        String docString = stream.readUTFFast();
        if (docString.isEmpty()) {
            docString = null;
        }
        if ((initializerType = PyTargetExpressionStub.InitializerType.fromIndex(stream.readVarInt())) == PyTargetExpressionStub.InitializerType.Custom) {
            String typeName = stream.readName().getString();
            for (CustomTargetExpressionStubType type : this.getCustomStubTypes()) {
                if (!type.getClass().getCanonicalName().equals(typeName)) continue;
                Object stub = type.deserializeStub(stream);
                PyTargetExpressionStubImpl pyTargetExpressionStubImpl = new PyTargetExpressionStubImpl(name, docString, (CustomTargetExpressionStub)stub, parentStub);
                if (pyTargetExpressionStubImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/stubs/PyTargetExpressionElementType", "deserialize"));
                }
                return pyTargetExpressionStubImpl;
            }
            throw new IOException("Unknown custom stub type " + typeName);
        }
        QualifiedName initializer = QualifiedName.deserialize((StubInputStream)stream);
        boolean isQualified = stream.readBoolean();
        PyTargetExpressionStubImpl pyTargetExpressionStubImpl = new PyTargetExpressionStubImpl(name, docString, initializerType, initializer, isQualified, parentStub);
        if (pyTargetExpressionStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/stubs/PyTargetExpressionElementType", "deserialize"));
        }
        return pyTargetExpressionStubImpl;
    }

    public boolean shouldCreateStub(ASTNode node) {
        if (PsiTreeUtil.getParentOfType((PsiElement)node.getPsi(), PyComprehensionElement.class, (boolean)true, (Class[])new Class[]{PyDocStringOwner.class}) != null) {
            return false;
        }
        ASTNode functionNode = TreeUtil.findParent(node, PyElementTypes.FUNCTION_DECLARATION);
        ASTNode qualifierNode = node.findChildByType(PythonDialectsTokenSetProvider.INSTANCE.getReferenceExpressionTokens());
        if (functionNode != null && qualifierNode != null) {
            PsiElement function = functionNode.getPsi();
            if (function instanceof PyFunction && "__new__".equals(((PyFunction)function).getName())) {
                return true;
            }
            ASTNode parameterList = functionNode.findChildByType(PyElementTypes.PARAMETER_LIST);
            assert (parameterList != null);
            ASTNode[] children = parameterList.getChildren(PyElementTypes.FORMAL_PARAMETER_SET);
            if (children.length > 0 && children[0].getText().equals(qualifierNode.getText())) {
                return true;
            }
        }
        return functionNode == null && qualifierNode == null;
    }

    @Override
    public void indexStub(@NotNull PyTargetExpressionStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/jetbrains/python/psi/impl/stubs/PyTargetExpressionElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/jetbrains/python/psi/impl/stubs/PyTargetExpressionElementType", "indexStub"));
        }
        String name = stub.getName();
        if (name != null && PyUtil.getInitialUnderscores(name) == 0) {
            if (stub.getParentStub() instanceof PyFileStub) {
                sink.occurrence(PyVariableNameIndex.KEY, (Object)name);
            } else if (PyTargetExpressionElementType.isInstanceAttributeStub(stub)) {
                sink.occurrence(PyInstanceAttributeIndex.KEY, (Object)name);
            }
        }
        for (CustomTargetExpressionStubType stubType : this.getCustomStubTypes()) {
            stubType.indexStub(stub, sink);
        }
    }

    private static boolean isInstanceAttributeStub(PyTargetExpressionStub stub) {
        StubElement parent = stub.getParentStub();
        return parent instanceof PyFunctionStub;
    }
}

