/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyStubElementType;
import com.jetbrains.python.psi.impl.PyNamedParameterImpl;
import com.jetbrains.python.psi.impl.stubs.PyNamedParameterStubImpl;
import com.jetbrains.python.psi.stubs.PyNamedParameterStub;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PyNamedParameterElementType
extends PyStubElementType<PyNamedParameterStub, PyNamedParameter> {
    private static final int POSITIONAL_CONTAINER = 1;
    private static final int KEYWORD_CONTAINER = 2;
    private static final int HAS_DEFAULT_VALUE = 4;

    public PyNamedParameterElementType() {
        this("NAMED_PARAMETER");
    }

    public PyNamedParameterElementType(String debugName) {
        super(debugName);
    }

    public PyNamedParameter createPsi(@NotNull PyNamedParameterStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/jetbrains/python/psi/impl/stubs/PyNamedParameterElementType", "createPsi"));
        }
        return new PyNamedParameterImpl(stub);
    }

    public PyNamedParameterStub createStub(@NotNull PyNamedParameter psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/jetbrains/python/psi/impl/stubs/PyNamedParameterElementType", "createStub"));
        }
        return new PyNamedParameterStubImpl(psi.getName(), psi.isPositionalContainer(), psi.isKeywordContainer(), psi.hasDefaultValue(), parentStub, this.getStubElementType());
    }

    @Override
    public PsiElement createElement(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/psi/impl/stubs/PyNamedParameterElementType", "createElement"));
        }
        return new PyNamedParameterImpl(node);
    }

    public void serialize(@NotNull PyNamedParameterStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/jetbrains/python/psi/impl/stubs/PyNamedParameterElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/jetbrains/python/psi/impl/stubs/PyNamedParameterElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        byte flags = 0;
        if (stub.isPositionalContainer()) {
            flags = (byte)(flags | 1);
        }
        if (stub.isKeywordContainer()) {
            flags = (byte)(flags | 2);
        }
        if (stub.hasDefaultValue()) {
            flags = (byte)(flags | 4);
        }
        dataStream.writeByte((int)flags);
    }

    @NotNull
    public PyNamedParameterStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/jetbrains/python/psi/impl/stubs/PyNamedParameterElementType", "deserialize"));
        }
        String name = StringRef.toString((StringRef)dataStream.readName());
        byte flags = dataStream.readByte();
        PyNamedParameterStubImpl pyNamedParameterStubImpl = new PyNamedParameterStubImpl(name, (flags & 1) != 0, (flags & 2) != 0, (flags & 4) != 0, parentStub, this.getStubElementType());
        if (pyNamedParameterStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/stubs/PyNamedParameterElementType", "deserialize"));
        }
        return pyNamedParameterStubImpl;
    }

    public boolean shouldCreateStub(ASTNode node) {
        ASTNode container;
        ASTNode paramList = node.getTreeParent();
        if (paramList != null && (container = paramList.getTreeParent()) != null && container.getElementType() == PyElementTypes.LAMBDA_EXPRESSION) {
            return false;
        }
        return super.shouldCreateStub(node);
    }

    protected IStubElementType getStubElementType() {
        return PyElementTypes.NAMED_PARAMETER;
    }
}

