/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStubElementType;
import com.jetbrains.python.psi.impl.PyFunctionImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.stubs.PyFunctionStubImpl;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PyFunctionElementType
extends PyStubElementType<PyFunctionStub, PyFunction> {
    public PyFunctionElementType() {
        this("FUNCTION_DECLARATION");
    }

    public PyFunctionElementType(String debugName) {
        super(debugName);
    }

    @Override
    public PsiElement createElement(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/psi/impl/stubs/PyFunctionElementType", "createElement"));
        }
        return new PyFunctionImpl(node);
    }

    public PyFunction createPsi(@NotNull PyFunctionStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/jetbrains/python/psi/impl/stubs/PyFunctionElementType", "createPsi"));
        }
        return new PyFunctionImpl(stub);
    }

    public PyFunctionStub createStub(@NotNull PyFunction psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/jetbrains/python/psi/impl/stubs/PyFunctionElementType", "createStub"));
        }
        PyFunctionImpl function = (PyFunctionImpl)psi;
        String message = function.extractDeprecationMessage();
        PyStringLiteralExpression docStringExpression = function.getDocStringExpression();
        return new PyFunctionStubImpl(psi.getName(), PyPsiUtils.strValue(docStringExpression), message == null ? null : StringRef.fromString((String)message), parentStub, this.getStubElementType());
    }

    public void serialize(@NotNull PyFunctionStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/jetbrains/python/psi/impl/stubs/PyFunctionElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/jetbrains/python/psi/impl/stubs/PyFunctionElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeUTFFast(stub.getDocString() != null ? stub.getDocString() : "");
        dataStream.writeName(stub.getDeprecationMessage());
    }

    @NotNull
    public PyFunctionStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/jetbrains/python/psi/impl/stubs/PyFunctionElementType", "deserialize"));
        }
        String name = StringRef.toString((StringRef)dataStream.readName());
        String docString = dataStream.readUTFFast();
        StringRef deprecationMessage = dataStream.readName();
        PyFunctionStubImpl pyFunctionStubImpl = new PyFunctionStubImpl(name, docString.length() > 0 ? docString : null, deprecationMessage, parentStub, this.getStubElementType());
        if (pyFunctionStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/stubs/PyFunctionElementType", "deserialize"));
        }
        return pyFunctionStubImpl;
    }

    @Override
    public void indexStub(@NotNull PyFunctionStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/jetbrains/python/psi/impl/stubs/PyFunctionElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/jetbrains/python/psi/impl/stubs/PyFunctionElementType", "indexStub"));
        }
        String name = stub.getName();
        if (name != null) {
            sink.occurrence(PyFunctionNameIndex.KEY, (Object)name);
        }
    }

    protected IStubElementType getStubElementType() {
        return PyElementTypes.FUNCTION_DECLARATION;
    }
}

