/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.io.StringRef;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFileElementType;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStubElementType;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.stubs.PyClassStubImpl;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyClassNameIndexInsensitive;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.stubs.PySuperClassIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyClassElementType
extends PyStubElementType<PyClassStub, PyClass> {
    public PyClassElementType() {
        this("CLASS_DECLARATION");
    }

    public PyClassElementType(String debugName) {
        super(debugName);
    }

    @Override
    public PsiElement createElement(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/psi/impl/stubs/PyClassElementType", "createElement"));
        }
        return new PyClassImpl(node);
    }

    public PyClass createPsi(@NotNull PyClassStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/jetbrains/python/psi/impl/stubs/PyClassElementType", "createPsi"));
        }
        return new PyClassImpl(stub);
    }

    public PyClassStub createStub(@NotNull PyClass psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/jetbrains/python/psi/impl/stubs/PyClassElementType", "createStub"));
        }
        PyExpression[] exprs = psi.getSuperClassExpressions();
        ArrayList<QualifiedName> superClasses = new ArrayList<QualifiedName>();
        for (PyExpression expression : exprs) {
            if (expression instanceof PyKeywordArgument) continue;
            expression = PyClassImpl.unfoldClass(expression);
            superClasses.add(PyPsiUtils.asQualifiedName(expression));
        }
        PyStringLiteralExpression docStringExpression = psi.getDocStringExpression();
        return new PyClassStubImpl(psi.getName(), parentStub, superClasses.toArray(new QualifiedName[superClasses.size()]), PyPsiUtils.asQualifiedName(psi.getMetaClassExpression()), psi.getOwnSlots(), PyPsiUtils.strValue(docStringExpression), this.getStubElementType());
    }

    public void serialize(@NotNull PyClassStub pyClassStub, @NotNull StubOutputStream dataStream) throws IOException {
        if (pyClassStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClassStub", "com/jetbrains/python/psi/impl/stubs/PyClassElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/jetbrains/python/psi/impl/stubs/PyClassElementType", "serialize"));
        }
        dataStream.writeName(pyClassStub.getName());
        QualifiedName[] classes = pyClassStub.getSuperClasses();
        dataStream.writeByte(classes.length);
        for (QualifiedName s : classes) {
            QualifiedName.serialize((QualifiedName)s, (StubOutputStream)dataStream);
        }
        QualifiedName.serialize((QualifiedName)pyClassStub.getMetaClass(), (StubOutputStream)dataStream);
        PyFileElementType.writeNullableList(dataStream, pyClassStub.getSlots());
        String docString = pyClassStub.getDocString();
        dataStream.writeUTFFast(docString != null ? docString : "");
    }

    @NotNull
    public PyClassStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/jetbrains/python/psi/impl/stubs/PyClassElementType", "deserialize"));
        }
        String name = StringRef.toString((StringRef)dataStream.readName());
        int superClassCount = dataStream.readByte();
        QualifiedName[] superClasses = new QualifiedName[superClassCount];
        for (int i = 0; i < superClassCount; ++i) {
            superClasses[i] = QualifiedName.deserialize((StubInputStream)dataStream);
        }
        QualifiedName metaClass = QualifiedName.deserialize((StubInputStream)dataStream);
        List<String> slots = PyFileElementType.readNullableList(dataStream);
        String docString = dataStream.readUTFFast();
        PyClassStubImpl pyClassStubImpl = new PyClassStubImpl(name, parentStub, superClasses, metaClass, slots, docString.length() > 0 ? docString : null, this.getStubElementType());
        if (pyClassStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/stubs/PyClassElementType", "deserialize"));
        }
        return pyClassStubImpl;
    }

    @Override
    public void indexStub(@NotNull PyClassStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/jetbrains/python/psi/impl/stubs/PyClassElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/jetbrains/python/psi/impl/stubs/PyClassElementType", "indexStub"));
        }
        String name = stub.getName();
        if (name != null) {
            sink.occurrence(PyClassNameIndex.KEY, (Object)name);
            sink.occurrence(PyClassNameIndexInsensitive.KEY, (Object)name.toLowerCase());
        }
        for (QualifiedName s : stub.getSuperClasses()) {
            String className;
            if (s == null || (className = s.getLastComponent()) == null) continue;
            sink.occurrence(PySuperClassIndex.KEY, (Object)className);
        }
    }

    protected IStubElementType getStubElementType() {
        return PyElementTypes.CLASS_DECLARATION;
    }
}

