/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.references;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PsiReferenceEx;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.impl.references.KeywordArgumentCompletionUtil;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.ImplicitResolveResult;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.PyReferenceResolveProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveProcessor;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyDefUseUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyReferenceImpl
implements PsiReferenceEx,
PsiPolyVariantReference {
    protected final PyQualifiedExpression myElement;
    protected final PyResolveContext myContext;
    private static boolean USE_CACHE = true;

    public PyReferenceImpl(PyQualifiedExpression element, @NotNull PyResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "<init>"));
        }
        this.myElement = element;
        this.myContext = context;
    }

    public TextRange getRangeInElement() {
        ASTNode nameElement = this.myElement.getNameElement();
        TextRange range = nameElement != null ? nameElement.getTextRange() : this.myElement.getNode().getTextRange();
        return range.shiftRight(-this.myElement.getNode().getStartOffset());
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length >= 1 && !(results[0] instanceof ImplicitResolveResult) ? results[0].getElement() : null;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        if (USE_CACHE) {
            ResolveCache cache = ResolveCache.getInstance(this.getElement().getProject());
            ResolveResult[] resolveResultArray = cache.resolveWithCaching(this, CachingResolver.INSTANCE, false, incompleteCode);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "multiResolve"));
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = this.multiResolveInner();
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    private ResolveResult[] multiResolveInner() {
        String referencedName = this.myElement.getReferencedName();
        if (referencedName == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "multiResolveInner"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        List<RatedResolveResult> targets = this.resolveInner();
        if (targets.size() == 0) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "multiResolveInner"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (this.myElement.getParent() instanceof PyCallExpression) {
            ListIterator<RatedResolveResult> it = targets.listIterator();
            block0: while (it.hasNext()) {
                RatedResolveResult rrr = it.next();
                PsiElement elt = rrr.getElement();
                if (!(elt instanceof PyClass)) continue;
                PyClass cls = (PyClass)elt;
                PyFunction init = cls.findMethodByName("__init__", false);
                if (init != null) {
                    it.set(rrr.replace(init));
                    continue;
                }
                for (PyClass ancestor : cls.getAncestorClasses(this.myContext.getTypeEvalContext())) {
                    init = ancestor.findMethodByName("__init__", false);
                    if (init == null) continue;
                    it.add(new RatedResolveResult(-1000, init));
                    continue block0;
                }
            }
        }
        List<RatedResolveResult> ret = RatedResolveResult.sorted(targets);
        ResolveResult[] resolveResultArray = ret.toArray(new ResolveResult[ret.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "multiResolveInner"));
        }
        return resolveResultArray;
    }

    @NotNull
    private static ResolveResultList resolveToLatestDefs(@NotNull List<ReadWriteInstruction> instructions, @NotNull PsiElement element, @NotNull String name) {
        if (instructions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructions", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "resolveToLatestDefs"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "resolveToLatestDefs"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "resolveToLatestDefs"));
        }
        ResolveResultList ret = new ResolveResultList();
        for (ReadWriteInstruction instruction : instructions) {
            PsiElement definition = instruction.getElement();
            NameDefiner definer = null;
            if (PyReferenceImpl.isInnerComprehension(element, definition)) continue;
            if (definition instanceof NameDefiner && !(definition instanceof PsiNamedElement)) {
                definer = (NameDefiner)definition;
                definition = definer.getElementNamed(name);
            }
            if (definer != null) {
                if (definer instanceof PyImportElement || definer instanceof PyStarImportElement || definer instanceof PyImportedModule) {
                    ret.add(new ImportedResolveResult(definition, PyReferenceImpl.getRate(definition), Collections.singletonList(definer)));
                } else {
                    ret.poke(definition, PyReferenceImpl.getRate(definition));
                }
                if (definition == null) continue;
                ret.poke(definer, -1000);
                continue;
            }
            ret.poke(definition, PyReferenceImpl.getRate(definition));
        }
        ResolveResultList results = new ResolveResultList();
        for (RatedResolveResult r : ret) {
            PsiElement e = r.getElement();
            if (e == element || element instanceof PyTargetExpression && PyPsiUtils.isBefore(element, e)) continue;
            results.add(r);
        }
        ResolveResultList resolveResultList = results;
        if (resolveResultList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "resolveToLatestDefs"));
        }
        return resolveResultList;
    }

    private static boolean isInnerComprehension(PsiElement referenceElement, PsiElement definition) {
        PyComprehensionElement elementComprehension;
        PyComprehensionElement definitionComprehension = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)definition, PyComprehensionElement.class);
        return definitionComprehension != null && PyUtil.isOwnScopeComprehension(definitionComprehension) && ((elementComprehension = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PyComprehensionElement.class)) == null || !PsiTreeUtil.isAncestor((PsiElement)definitionComprehension, (PsiElement)elementComprehension, (boolean)false));
    }

    private static boolean isInOwnScopeComprehension(PsiElement uexpr) {
        PyComprehensionElement comprehensionElement = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)uexpr, PyComprehensionElement.class);
        return comprehensionElement != null && PyUtil.isOwnScopeComprehension(comprehensionElement);
    }

    @NotNull
    protected List<RatedResolveResult> resolveInner() {
        ResolveResultList ret = new ResolveResultList();
        String referencedName = this.myElement.getReferencedName();
        if (referencedName == null) {
            ResolveResultList resolveResultList = ret;
            if (resolveResultList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "resolveInner"));
            }
            return resolveResultList;
        }
        if (this.myElement instanceof PyTargetExpression && PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyComprehensionElement.class) != null) {
            ret.poke((PsiElement)this.myElement, PyReferenceImpl.getRate((PsiElement)this.myElement));
            ResolveResultList resolveResultList = ret;
            if (resolveResultList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "resolveInner"));
            }
            return resolveResultList;
        }
        ResolveProcessor processor = new ResolveProcessor(referencedName);
        PsiElement realContext = PyPsiUtils.getRealContext((PsiElement)this.myElement);
        PsiElement roof = this.findResolveRoof(referencedName, realContext);
        PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor, (PsiElement)this.myElement, referencedName, roof);
        List<RatedResolveResult> list = this.getResultsFromProcessor(referencedName, processor, realContext, roof);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "resolveInner"));
        }
        return list;
    }

    protected List<RatedResolveResult> getResultsFromProcessor(String referencedName, ResolveProcessor processor, PsiElement realContext, PsiElement roof) {
        PyClassType objectType;
        String name;
        ResolveResultList ret = new ResolveResultList();
        PsiElement uexpr = processor.getResult();
        List<PsiElement> definers = processor.getDefiners();
        if (uexpr != null) {
            if (definers.isEmpty()) {
                ScopeOwner originalOwner = ScopeUtil.getScopeOwner(realContext);
                ScopeOwner owner = ScopeUtil.getScopeOwner(uexpr);
                if (owner != null) {
                    Scope originalScope;
                    Scope scope = ControlFlowCache.getScope(owner);
                    if (uexpr == originalOwner && originalOwner instanceof PyClass) {
                        uexpr = null;
                    } else if (owner == originalOwner && !scope.isGlobal(referencedName)) {
                        List<ReadWriteInstruction> instructions = PyDefUseUtil.getLatestDefs(owner, referencedName, realContext, false);
                        ResolveResultList latest = PyReferenceImpl.resolveToLatestDefs(instructions, realContext, referencedName);
                        if (!latest.isEmpty()) {
                            return latest;
                        }
                        if (owner instanceof PyClass || instructions.isEmpty() && PyReferenceImpl.isInOwnScopeComprehension(uexpr)) {
                            ScopeOwner parentOwner = ScopeUtil.getScopeOwner((PsiElement)owner);
                            if (parentOwner != null) {
                                processor = new ResolveProcessor(referencedName);
                                PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor, parentOwner, referencedName, roof);
                                uexpr = processor.getResult();
                                definers = processor.getDefiners();
                            }
                        } else {
                            uexpr = null;
                        }
                    } else if (owner != originalOwner && originalOwner != null && !scope.isGlobal(referencedName) && (originalScope = ControlFlowCache.getScope(originalOwner)).containsDeclaration(referencedName)) {
                        uexpr = null;
                    }
                }
            }
            for (PsiElement hit : definers) {
                ret.poke(hit, PyReferenceImpl.getRate(hit));
            }
            PsiElement packageInit = PyUtil.turnDirIntoInit(uexpr);
            if (packageInit != null) {
                uexpr = packageInit;
            }
        } else if (!definers.isEmpty()) {
            ret.add(new ImportedResolveResult(null, -1000, definers));
        }
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(realContext);
        if (uexpr == null && PyModuleType.MODULE_MEMBERS.contains((Object)(name = this.myElement.getName())) && (objectType = builtinCache.getObjectType()) != null && name != null) {
            ret.addAll(objectType.resolveMember(name, null, AccessDirection.READ, this.myContext));
        }
        if (uexpr != null) {
            ret.add(new ImportedResolveResult(uexpr, PyReferenceImpl.getRate(uexpr), definers));
        } else {
            for (PyReferenceResolveProvider provider : (PyReferenceResolveProvider[])Extensions.getExtensions(PyReferenceResolveProvider.EP_NAME)) {
                List<RatedResolveResult> results = provider.resolveName(this.myElement, definers);
                for (RatedResolveResult res : results) {
                    ret.add(res);
                }
            }
        }
        return ret;
    }

    private PsiElement findResolveRoof(String referencedName, PsiElement realContext) {
        ScopeOwner scopeOwner;
        if (PyUtil.isClassPrivateName(referencedName)) {
            PyArgumentList superClassExpressionList;
            PyQualifiedExpression one = this.myElement;
            while ((one = PyUtil.getConcealingParent((PsiElement)one)) instanceof PyFunction) {
            }
            if (one instanceof PyClass && ((superClassExpressionList = ((PyClass)((Object)one)).getSuperClassExpressionList()) == null || !PsiTreeUtil.isAncestor((PsiElement)superClassExpressionList, (PsiElement)this.myElement, (boolean)false))) {
                return one;
            }
        }
        if (this.myElement instanceof PyTargetExpression && (scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, ScopeOwner.class)) != null) {
            ScopeOwner nonlocalOwner;
            String name;
            Scope scope = ControlFlowCache.getScope(scopeOwner);
            if (scope.isNonlocal(name = this.myElement.getName()) && (nonlocalOwner = ScopeUtil.getDeclarationScopeOwner((PsiElement)this.myElement, referencedName)) != null && !(nonlocalOwner instanceof PyFile)) {
                return nonlocalOwner;
            }
            if (!scope.isGlobal(name)) {
                return scopeOwner;
            }
        }
        return realContext.getContainingFile();
    }

    public static int getRate(PsiElement elt) {
        int rate = elt instanceof PyImportedNameDefiner || elt instanceof PyReferenceExpression ? -1000 : (elt instanceof PyFile ? 1000 : 0);
        return rate;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeInElement().substring(this.getElement().getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ASTNode nameElement = this.myElement.getNameElement();
        if (newElementName.endsWith(".py")) {
            newElementName = newElementName.substring(0, newElementName.length() - ".py".length());
        }
        if (nameElement != null && PyNames.isIdentifier(newElementName)) {
            ASTNode newNameElement = PyUtil.createNewName(this.myElement, newElementName);
            this.myElement.getNode().replaceChild(nameElement, newNameElement);
        }
        return this.myElement;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "bindToElement"));
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            PsiDirectory directory;
            PyFile file;
            PsiElement resolveResult = this.resolve();
            if (resolveResult instanceof PyImportedModule) {
                resolveResult = resolveResult.getNavigationElement();
            }
            if (element instanceof PsiDirectory && (resolveResult instanceof PyFile ? PyUtil.isPackage(file = (PyFile)resolveResult) && file.getContainingDirectory() == element : resolveResult instanceof PsiDirectory && PyUtil.isPackage(directory = (PsiDirectory)resolveResult, null) && directory == element)) {
                return true;
            }
            return resolveResult == element;
        }
        if (element instanceof PsiNamedElement) {
            String elementName = ((PsiNamedElement)element).getName();
            if (Comparing.equal((String)this.myElement.getReferencedName(), (String)elementName) || "__init__".equals(elementName)) {
                if (!this.haveQualifiers(element)) {
                    ScopeOwner ourScopeOwner = ScopeUtil.getScopeOwner(this.getElement());
                    ScopeOwner theirScopeOwner = ScopeUtil.getScopeOwner(element);
                    if ((element instanceof PyParameter || element instanceof PyTargetExpression) && this.resolvesToSameLocal(element, elementName, ourScopeOwner, theirScopeOwner)) {
                        return true;
                    }
                    PsiElement resolveResult = this.resolve();
                    if (resolveResult == element) {
                        return true;
                    }
                    if (resolveResult instanceof PsiNamedElement && resolveResult instanceof ScopeOwner && element instanceof ScopeOwner && theirScopeOwner == ScopeUtil.getScopeOwner(resolveResult)) {
                        return true;
                    }
                    if (!this.haveQualifiers(element) && ourScopeOwner != null && theirScopeOwner != null && this.resolvesToSameGlobal(element, elementName, ourScopeOwner, theirScopeOwner, resolveResult)) {
                        return true;
                    }
                    if (this.resolvesToWrapper(element, resolveResult)) {
                        return true;
                    }
                }
                if (element instanceof PyExpression) {
                    PyExpression expr = (PyExpression)element;
                    if (PyUtil.isClassAttribute((PsiElement)this.myElement) && (PyUtil.isClassAttribute((PsiElement)expr) || PyUtil.isInstanceAttribute(expr))) {
                        PyClass c1 = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
                        PyClass c2 = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyClass.class);
                        if (c1 != null && c2 != null && (c1.isSubclass(c2) || c2.isSubclass(c1))) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean resolvesToSameLocal(PsiElement element, String elementName, ScopeOwner ourScopeOwner, ScopeOwner theirScopeOwner) {
        PsiElement ourContainer = PyReferenceImpl.findContainer(this.getElement());
        PsiElement theirContainer = PyReferenceImpl.findContainer(element);
        if (ourContainer != null) {
            if (ourContainer == theirContainer) {
                return true;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)theirContainer, (PsiElement)ourContainer, (boolean)true) && ourScopeOwner != theirScopeOwner) {
                boolean shadowsName = false;
                ScopeOwner owner = ourScopeOwner;
                while (owner != theirScopeOwner && owner != null) {
                    if (ControlFlowCache.getScope(owner).containsDeclaration(elementName)) {
                        shadowsName = true;
                        break;
                    }
                    owner = ScopeUtil.getScopeOwner((PsiElement)owner);
                }
                if (!shadowsName) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private static PsiElement findContainer(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "findContainer"));
        }
        PyElement parent = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{ScopeOwner.class, PyComprehensionElement.class});
        if (parent instanceof PyListCompExpression && LanguageLevel.forElement(element).isOlderThan(LanguageLevel.PYTHON30)) {
            return PyReferenceImpl.findContainer((PsiElement)parent);
        }
        return parent;
    }

    private boolean resolvesToSameGlobal(PsiElement element, String elementName, ScopeOwner ourScopeOwner, ScopeOwner theirScopeOwner, PsiElement resolveResult) {
        PsiFile theirFile;
        PsiFile ourFile = this.getElement().getContainingFile();
        if (ourFile == (theirFile = element.getContainingFile())) {
            boolean ourIsGlobal = ControlFlowCache.getScope(ourScopeOwner).isGlobal(elementName);
            boolean theirIsGlobal = ControlFlowCache.getScope(theirScopeOwner).isGlobal(elementName);
            if (ourIsGlobal && theirIsGlobal) {
                return true;
            }
        }
        return ScopeUtil.getScopeOwner(resolveResult) == ourFile && ControlFlowCache.getScope(theirScopeOwner).isGlobal(elementName);
    }

    protected boolean resolvesToWrapper(PsiElement element, PsiElement resolveResult) {
        PyCallExpression call;
        Pair<String, PyFunction> functionPair;
        PyExpression assignedValue;
        return element instanceof PyFunction && ((PyFunction)element).getContainingClass() != null && resolveResult instanceof PyTargetExpression && (assignedValue = ((PyTargetExpression)resolveResult).findAssignedValue()) instanceof PyCallExpression && (functionPair = PyCallExpressionHelper.interpretAsModifierWrappingCall(call = (PyCallExpression)assignedValue, (PsiElement)this.myElement)) != null && functionPair.second == element;
    }

    private boolean haveQualifiers(PsiElement element) {
        if (this.myElement.isQualified()) {
            return true;
        }
        return element instanceof PyQualifiedExpression && ((PyQualifiedExpression)element).isQualified();
    }

    @NotNull
    public Object[] getVariants() {
        PsiFile f;
        ScopeOwner owner;
        ArrayList ret = Lists.newArrayList();
        PyQualifiedExpression originalElement = CompletionUtil.getOriginalElement(this.myElement);
        PyQualifiedExpression element = originalElement instanceof PyQualifiedExpression ? originalElement : this.myElement;
        PsiElement realContext = PyPsiUtils.getRealContext((PsiElement)element);
        int underscores = PyUtil.getInitialUnderscores(element.getName());
        CompletionVariantsProcessor processor = new CompletionVariantsProcessor((PsiElement)element);
        ScopeOwner scopeOwner = owner = realContext instanceof ScopeOwner ? (ScopeOwner)realContext : ScopeUtil.getScopeOwner(realContext);
        if (owner != null) {
            PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor, owner, null, null);
        }
        KeywordArgumentCompletionUtil.collectFunctionArgNames(element, ret);
        PyFile builtinsFile = PyBuiltinCache.getInstance((PsiElement)element).getBuiltinsFile();
        if (builtinsFile != null) {
            PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor, builtinsFile, null, null);
        }
        if (underscores >= 2 && (f = realContext.getContainingFile()) instanceof PyFile) {
            for (String name : PyModuleType.getPossibleInstanceMembers()) {
                ret.add(LookupElementBuilder.create((String)name).withIcon(PlatformIcons.FIELD_ICON));
            }
        }
        for (LookupElement e : processor.getResultList()) {
            PsiElement original;
            Object o = e.getObject();
            if (o instanceof PsiElement && (original = CompletionUtil.getOriginalElement((PsiElement)o)) == null) continue;
            ret.add(e);
        }
        Object[] objectArray = ret.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyReferenceImpl", "getVariants"));
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public HighlightSeverity getUnresolvedHighlightSeverity(TypeEvalContext context) {
        if (this.isBuiltInConstant()) {
            return null;
        }
        PyExpression qualifier = this.myElement.getQualifier();
        if (qualifier == null) {
            return HighlightSeverity.ERROR;
        }
        if (context.getType(qualifier) != null) {
            return HighlightSeverity.WARNING;
        }
        return null;
    }

    private boolean isBuiltInConstant() {
        String name = this.myElement.getReferencedName();
        return "None".equals(name) || "True".equals(name) || "False".equals(name);
    }

    @Override
    @Nullable
    public String getUnresolvedDescription() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyReferenceImpl that = (PyReferenceImpl)o;
        if (!this.myElement.equals(that.myElement)) {
            return false;
        }
        return this.myContext.equals(that.myContext);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    protected static Object[] getTypeCompletionVariants(PyExpression pyExpression, PyType type) {
        ProcessingContext context = new ProcessingContext();
        context.put(PyType.CTX_NAMES, new HashSet());
        return type.getCompletionVariants(pyExpression.getName(), (PsiElement)pyExpression, context);
    }

    private static class CachingResolver
    implements ResolveCache.PolyVariantResolver<PyReferenceImpl> {
        public static CachingResolver INSTANCE = new CachingResolver();
        private ThreadLocal<AtomicInteger> myNesting = new ThreadLocal<AtomicInteger>(){

            @Override
            protected AtomicInteger initialValue() {
                return new AtomicInteger();
            }
        };
        private static final int MAX_NESTING_LEVEL = 30;

        private CachingResolver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull PyReferenceImpl ref, boolean incompleteCode) {
            ResolveResult[] resolveResultArray;
            block5: {
                if (ref == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/jetbrains/python/psi/impl/references/PyReferenceImpl$CachingResolver", "resolve"));
                }
                if (this.myNesting.get().getAndIncrement() >= 30) {
                    System.out.println("Stack overflow pending");
                }
                resolveResultArray = ref.multiResolveInner();
                if (resolveResultArray != null) break block5;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyReferenceImpl$CachingResolver", "resolve"));
            }
            return resolveResultArray;
            finally {
                this.myNesting.get().getAndDecrement();
            }
        }
    }
}

