/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.references;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.ImplicitResolveResult;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import com.jetbrains.python.psi.stubs.PyClassNameIndexInsensitive;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.stubs.PyInstanceAttributeIndex;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyQualifiedReference
extends PyReferenceImpl {
    private static final Logger LOG = Logger.getInstance(PyQualifiedReference.class);

    public PyQualifiedReference(PyQualifiedExpression element, PyResolveContext context) {
        super(element, context);
    }

    @Override
    @NotNull
    protected List<RatedResolveResult> resolveInner() {
        ResolveResultList ret = new ResolveResultList();
        String referencedName = this.myElement.getReferencedName();
        if (referencedName == null) {
            ResolveResultList resolveResultList = ret;
            if (resolveResultList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyQualifiedReference", "resolveInner"));
            }
            return resolveResultList;
        }
        PyExpression qualifier = this.myElement.getQualifier();
        if (qualifier == null) {
            ResolveResultList resolveResultList = ret;
            if (resolveResultList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyQualifiedReference", "resolveInner"));
            }
            return resolveResultList;
        }
        PyType qualifierType = this.myContext.getTypeEvalContext().getType(qualifier);
        if (PyUtil.isClassPrivateName(referencedName) && qualifierType instanceof PyClassType && PyQualifiedReference.isOtherClassQualifying(qualifier, (PyClassType)qualifierType)) {
            List<RatedResolveResult> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyQualifiedReference", "resolveInner"));
            }
            return list;
        }
        if (qualifierType != null) {
            qualifierType.assertValid("qualifier: " + qualifier);
            AccessDirection ctx = AccessDirection.of(this.myElement);
            List<? extends RatedResolveResult> membersOfQualifier = qualifierType.resolveMember(referencedName, qualifier, ctx, this.myContext);
            if (membersOfQualifier == null) {
                ResolveResultList resolveResultList = ret;
                if (resolveResultList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyQualifiedReference", "resolveInner"));
                }
                return resolveResultList;
            }
            ret.addAll(membersOfQualifier);
        }
        if (qualifier instanceof PyQualifiedExpression && ret.isEmpty() && PyQualifiedReference.addAssignedAttributes(ret, referencedName, (PyQualifiedExpression)qualifier)) {
            ResolveResultList resolveResultList = ret;
            if (resolveResultList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyQualifiedReference", "resolveInner"));
            }
            return resolveResultList;
        }
        if (PyTypeChecker.isUnknown(qualifierType) && this.myContext.allowImplicits() && PyQualifiedReference.canQualifyAnImplicitName(qualifier, qualifierType)) {
            this.addImplicitResolveResults(referencedName, ret);
        }
        if ("__doc__".equals(referencedName)) {
            this.addDocReference(ret, qualifier, qualifierType);
        }
        ResolveResultList resolveResultList = ret;
        if (resolveResultList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyQualifiedReference", "resolveInner"));
        }
        return resolveResultList;
    }

    private static boolean isOtherClassQualifying(PyExpression qualifier, PyClassType qualifierType) {
        PsiElement theirClass;
        PyClass ourClass;
        List<PsiElement> match = PyUtil.searchForWrappingMethod((PsiElement)qualifier, true);
        if (match == null) {
            return true;
        }
        return match.size() > 1 && (ourClass = qualifierType.getPyClass()) != (theirClass = CompletionUtil.getOriginalOrSelf(match.get(match.size() - 1)));
    }

    private void addImplicitResolveResults(String referencedName, ResolveResultList ret) {
        Project project = this.myElement.getProject();
        GlobalSearchScope scope = PyProjectScopeBuilder.excludeSdkTestsScope(project);
        Collection<PyFunction> functions = PyFunctionNameIndex.find(referencedName, project, scope);
        PsiFile containingFile = this.myElement.getContainingFile();
        List<Object> imports = containingFile instanceof PyFile ? PyQualifiedReference.collectImports((PyFile)containingFile) : Collections.emptyList();
        for (PyFunction function : functions) {
            if (!(function instanceof PyFunction)) {
                FileBasedIndex.getInstance().scheduleRebuild(StubUpdatingIndex.INDEX_ID, new Throwable("found non-function object " + function + " in function list"));
                break;
            }
            PyFunction pyFunction = function;
            if (pyFunction.getContainingClass() == null) continue;
            ret.add(new ImplicitResolveResult(pyFunction, this.getImplicitResultRate(pyFunction, imports)));
        }
        Collection<PyTargetExpression> attributes = PyInstanceAttributeIndex.find(referencedName, project, scope);
        for (PyTargetExpression attribute : attributes) {
            if (!(attribute instanceof PyTargetExpression)) {
                FileBasedIndex.getInstance().scheduleRebuild(StubUpdatingIndex.INDEX_ID, new Throwable("found non-target expression object " + attribute + " in target expression list"));
                break;
            }
            ret.add(new ImplicitResolveResult((PsiElement)attribute, this.getImplicitResultRate(attribute, imports)));
        }
    }

    private static List<QualifiedName> collectImports(PyFile containingFile) {
        ArrayList<QualifiedName> imports = new ArrayList<QualifiedName>();
        for (PyFromImportStatement anImport : containingFile.getFromImports()) {
            QualifiedName source = anImport.getImportSourceQName();
            if (source == null) continue;
            imports.add(source);
        }
        for (PyImportElement importElement : containingFile.getImportTargets()) {
            QualifiedName qName = importElement.getImportedQName();
            if (qName == null) continue;
            imports.add(qName.removeLastComponent());
        }
        return imports;
    }

    private int getImplicitResultRate(PyElement target, List<QualifiedName> imports) {
        int rate = -1000;
        if (target.getContainingFile() == this.myElement.getContainingFile()) {
            rate += 200;
        } else {
            VirtualFile vFile = target.getContainingFile().getVirtualFile();
            if (vFile != null) {
                QualifiedName qName;
                if (ProjectScope.getProjectScope((Project)this.myElement.getProject()).contains(vFile)) {
                    rate += 80;
                }
                if ((qName = QualifiedNameFinder.findShortestImportableQName((PsiElement)this.myElement, vFile)) != null && imports.contains(qName)) {
                    rate += 70;
                }
            }
        }
        if (this.myElement.getParent() instanceof PyCallExpression) {
            if (target instanceof PyFunction) {
                rate += 50;
            }
        } else if (!(target instanceof PyFunction)) {
            rate += 50;
        }
        return rate;
    }

    private static boolean canQualifyAnImplicitName(@NotNull PyExpression qualifier, @Nullable PyType qualType) {
        PsiElement target;
        PyExpression callee;
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/jetbrains/python/psi/impl/references/PyQualifiedReference", "canQualifyAnImplicitName"));
        }
        return qualType != null || !(qualifier instanceof PyCallExpression) || !((callee = ((PyCallExpression)qualifier).getCallee()) instanceof PyReferenceExpression) || !"super".equals(callee.getName()) || (target = ((PyReferenceExpression)callee).getReference().resolve()) == null || !PyBuiltinCache.getInstance((PsiElement)qualifier).isBuiltin(target);
    }

    private static boolean addAssignedAttributes(ResolveResultList ret, String referencedName, PyQualifiedExpression qualifier) {
        for (PyExpression ex : PyQualifiedReference.collectAssignedAttributes(qualifier)) {
            if (!referencedName.equals(ex.getName())) continue;
            ret.poke((PsiElement)ex, 0);
            return true;
        }
        return false;
    }

    private void addDocReference(ResolveResultList ret, PyExpression qualifier, PyType qualifierType) {
        PsiElement qual_object;
        PyStringLiteralExpression docstring = null;
        if (qualifierType instanceof PyClassType) {
            PyClass qualClass = ((PyClassType)qualifierType).getPyClass();
            docstring = qualClass.getDocStringExpression();
        } else if (qualifierType instanceof PyModuleType) {
            PyFile qualModule = ((PyModuleType)qualifierType).getModule();
            docstring = qualModule.getDocStringExpression();
        } else if (qualifier instanceof PyReferenceExpression && (qual_object = ((PyReferenceExpression)qualifier).getReference(this.myContext).resolve()) instanceof PyDocStringOwner) {
            docstring = ((PyDocStringOwner)qual_object).getDocStringExpression();
        }
        ret.poke(docstring, 1000);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        PyExpression qualifier = this.myElement.getQualifier();
        if (qualifier != null) {
            qualifier = CompletionUtil.getOriginalOrSelf(qualifier);
        }
        if (qualifier == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyQualifiedReference", "getVariants"));
            }
            return EMPTY_ARRAY;
        }
        PyQualifiedExpression element = CompletionUtil.getOriginalOrSelf(this.myElement);
        PyType qualifierType = TypeEvalContext.userInitiated(element.getProject(), element.getContainingFile()).getType(qualifier);
        ProcessingContext ctx = new ProcessingContext();
        HashSet<String> namesAlready = new HashSet<String>();
        ctx.put(PyType.CTX_NAMES, namesAlready);
        if (qualifierType != null) {
            ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>();
            Collections.addAll(variants, this.getVariantFromHasAttr(qualifier));
            if (qualifier instanceof PyQualifiedExpression) {
                Collection<PyExpression> attrs = PyQualifiedReference.collectAssignedAttributes((PyQualifiedExpression)qualifier);
                for (PyExpression ex : attrs) {
                    String name = ex.getName();
                    if (name != null && name.endsWith(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED)) continue;
                    if (ex instanceof PsiNamedElement && qualifierType instanceof PyClassType) {
                        variants.add(LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)ex)).withTypeText(qualifierType.getName()).withIcon(PlatformIcons.FIELD_ICON));
                    }
                    if (ex instanceof PyReferenceExpression) {
                        PyReferenceExpression refExpr = (PyReferenceExpression)ex;
                        namesAlready.add(refExpr.getReferencedName());
                        continue;
                    }
                    if (!(ex instanceof PyTargetExpression)) continue;
                    PyTargetExpression targetExpr = (PyTargetExpression)ex;
                    namesAlready.add(targetExpr.getName());
                }
                Collections.addAll(variants, qualifierType.getCompletionVariants(element.getName(), (PsiElement)element, ctx));
                Object[] objectArray = variants.toArray();
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyQualifiedReference", "getVariants"));
                }
                return objectArray;
            }
            Object[] objectArray = qualifierType.getCompletionVariants(element.getName(), (PsiElement)element, ctx);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyQualifiedReference", "getVariants"));
            }
            return objectArray;
        }
        Object[] objectArray = this.getUntypedVariants();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyQualifiedReference", "getVariants"));
        }
        return objectArray;
    }

    private Object[] getVariantFromHasAttr(PyExpression qualifier) {
        ArrayList<String> variants = new ArrayList<String>();
        PyIfStatement ifStatement = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyIfStatement.class);
        while (ifStatement != null) {
            PyStringLiteralExpression string;
            PyCallExpression call;
            PyExpression condition = ifStatement.getIfPart().getCondition();
            if (condition instanceof PyCallExpression && ((PyCallExpression)condition).isCalleeText("hasattr") && (call = (PyCallExpression)condition).getArguments().length > 1 && call.getArguments()[0].getText().equals(qualifier.getText()) && (string = call.getArgument(1, PyStringLiteralExpression.class)) != null && StringUtil.isJavaIdentifier((String)string.getStringValue())) {
                variants.add(string.getStringValue());
            }
            ifStatement = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)ifStatement, PyIfStatement.class);
        }
        return variants.toArray();
    }

    private Object[] getUntypedVariants() {
        PyExpression qualifierElement = this.myElement.getQualifier();
        if (qualifierElement instanceof PyReferenceExpression) {
            PyReferenceExpression qualifier = (PyReferenceExpression)qualifierElement;
            String className = qualifier.getReferencedName();
            if (className != null) {
                Collection<PyClass> classes = PyClassNameIndexInsensitive.find(className, this.getElement().getProject());
                if ((classes = PyQualifiedReference.filterByImports(classes, this.myElement.getContainingFile())).size() == 1) {
                    PyClassTypeImpl classType = new PyClassTypeImpl(classes.iterator().next(), false);
                    return PyQualifiedReference.getTypeCompletionVariants(this.myElement, classType);
                }
            }
            return this.collectSeenMembers(qualifier.getText());
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static Collection<PyClass> filterByImports(Collection<PyClass> classes, PsiFile containingFile) {
        if (classes.size() <= 1) {
            return classes;
        }
        ArrayList<PyClass> result = new ArrayList<PyClass>();
        for (PyClass pyClass : classes) {
            if (pyClass.getContainingFile() == containingFile) {
                result.add(pyClass);
                continue;
            }
            PsiElement exportedClass = ((PyFile)containingFile).getElementNamed(pyClass.getName());
            if (exportedClass != pyClass) continue;
            result.add(pyClass);
        }
        return result;
    }

    private Object[] collectSeenMembers(final String text) {
        final HashSet members = new HashSet();
        this.myElement.getContainingFile().accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(PyReferenceExpression node) {
                String refName;
                PyExpression qualifier;
                super.visitPyReferenceExpression(node);
                if (node != PyQualifiedReference.this.myElement && (qualifier = node.getQualifier()) != null && qualifier.getText().equals(text) && (refName = node.getReferencedName()) != null) {
                    members.add(refName);
                }
            }
        });
        ArrayList<LookupElement> results = new ArrayList<LookupElement>(members.size());
        for (String member : members) {
            results.add(AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy((LookupElement)LookupElementBuilder.create((String)member)));
        }
        return results.toArray(new Object[results.size()]);
    }

    private static Collection<PyExpression> collectAssignedAttributes(PyQualifiedExpression qualifier) {
        HashSet<String> names = new HashSet<String>();
        QualifiedName qualifierQName = qualifier.asQualifiedName();
        if (qualifierQName != null) {
            ArrayList<PyExpression> results = new ArrayList<PyExpression>();
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)qualifier);
            while (owner != null) {
                Scope scope = ControlFlowCache.getScope(owner);
                for (PyTargetExpression target : scope.getTargetExpressions()) {
                    String name;
                    QualifiedName targetQName = target.asQualifiedName();
                    if (targetQName == null || targetQName.getComponentCount() != qualifierQName.getComponentCount() + 1 || !targetQName.matchesPrefix(qualifierQName) || names.contains(name = target.getName())) continue;
                    names.add(name);
                    results.add(target);
                }
                owner = ScopeUtil.getScopeOwner((PsiElement)owner);
            }
            return results;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        PyType qualifierType;
        PyExpression qualifier;
        if (PyQualifiedReference.isLocalScope(element)) {
            return false;
        }
        String referencedName = this.myElement.getReferencedName();
        PyResolveContext resolveContext = this.myContext.withoutImplicits();
        if (resolveContext.getTypeEvalContext().getOrigin() == null) {
            PsiFile containingFile = this.myElement.getContainingFile();
            if (containingFile instanceof StubBasedPsiElement) assert (((StubBasedPsiElement)containingFile).getStub() == null) : "Stub origin for type eval context in isReferenceTo()";
            TypeEvalContext context = TypeEvalContext.codeAnalysis(containingFile.getProject(), containingFile);
            resolveContext = resolveContext.withTypeEvalContext(context);
        }
        if (element instanceof PyFunction && Comparing.equal((String)referencedName, (String)((PyFunction)element).getName()) && ((PyFunction)element).getContainingClass() != null && !"__init__".equals(referencedName) && (qualifier = this.myElement.getQualifier()) != null && (qualifierType = resolveContext.getTypeEvalContext().getType(qualifier)) == null) {
            return true;
        }
        for (ResolveResult result : this.copyWithResolveContext(resolveContext).multiResolve(false)) {
            LOG.assertTrue(!(result instanceof ImplicitResolveResult));
            PsiElement resolveResult = result.getElement();
            if (!this.isResolvedToResult(element, resolveResult)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected PyQualifiedReference copyWithResolveContext(PyResolveContext context) {
        PyQualifiedReference pyQualifiedReference = new PyQualifiedReference(this.myElement, context);
        if (pyQualifiedReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyQualifiedReference", "copyWithResolveContext"));
        }
        return pyQualifiedReference;
    }

    private boolean isResolvedToResult(PsiElement element, PsiElement resolveResult) {
        PyClass bClass;
        PyClass aClass;
        if (resolveResult instanceof PyImportedModule) {
            resolveResult = resolveResult.getNavigationElement();
        }
        if (element instanceof PsiDirectory && resolveResult instanceof PyFile && "__init__.py".equals(((PyFile)resolveResult).getName()) && ((PyFile)resolveResult).getContainingDirectory() == element) {
            return true;
        }
        if (resolveResult == element) {
            return true;
        }
        if (resolveResult instanceof PyTargetExpression && PyUtil.isAttribute((PyTargetExpression)resolveResult) && element instanceof PyTargetExpression && PyUtil.isAttribute((PyTargetExpression)element) && Comparing.equal((String)((PyTargetExpression)resolveResult).getReferencedName(), (String)((PyTargetExpression)element).getReferencedName()) && (PyQualifiedReference.isSubclass(aClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)resolveResult, PyClass.class), bClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class)) || PyQualifiedReference.isSubclass(bClass, aClass))) {
            return true;
        }
        return this.resolvesToWrapper(element, resolveResult);
    }

    private static boolean isSubclass(@Nullable PyClass aClass, @Nullable PyClass bClass) {
        if (aClass == null || bClass == null) {
            return false;
        }
        return bClass.isSubclass(aClass);
    }

    private static boolean isLocalScope(PsiElement element) {
        if (element instanceof PyParameter) {
            return true;
        }
        if (element instanceof PyTargetExpression) {
            PyTargetExpression target = (PyTargetExpression)element;
            return !target.isQualified() && ScopeUtil.getScopeOwner((PsiElement)target) instanceof PyFunction;
        }
        return false;
    }

    public String toString() {
        return "PyQualifiedReference(" + this.myElement + "," + this.myContext + ")";
    }
}

