/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.references;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyOperatorReference
extends PyReferenceImpl {
    public PyOperatorReference(PyQualifiedExpression element, @NotNull PyResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/references/PyOperatorReference", "<init>"));
        }
        super(element, context);
    }

    @Override
    @NotNull
    protected List<RatedResolveResult> resolveInner() {
        List<RatedResolveResult> res = new ArrayList<RatedResolveResult>();
        if (this.myElement instanceof PyBinaryExpression) {
            PyBinaryExpression expr = (PyBinaryExpression)this.myElement;
            String name = expr.getReferencedName();
            if ("__contains__".equals(name)) {
                res = this.resolveMember(expr.getRightExpression(), name);
            } else {
                if ("__div__".equals(name) && PyOperatorReference.isTrueDivEnabled(this.myElement)) {
                    this.resolveLeftAndRightOperators(res, expr, "__truediv__");
                }
                this.resolveLeftAndRightOperators(res, expr, name);
            }
        } else if (this.myElement instanceof PySubscriptionExpression) {
            PySubscriptionExpression expr = (PySubscriptionExpression)this.myElement;
            res = this.resolveMember(expr.getOperand(), expr.getReferencedName());
        } else if (this.myElement instanceof PyPrefixExpression) {
            PyPrefixExpression expr = (PyPrefixExpression)this.myElement;
            res = this.resolveMember(expr.getOperand(), expr.getReferencedName());
        }
        ArrayList<RatedResolveResult> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyOperatorReference", "resolveInner"));
        }
        return arrayList;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof PyParameter || element instanceof PyTargetExpression) {
            return false;
        }
        return super.isReferenceTo(element);
    }

    public String toString() {
        return "PyOperatorReference(" + this.myElement + "," + this.myContext + ")";
    }

    public String getReadableOperatorName() {
        String name = this.myElement.getReferencedName();
        if (PyNames.SUBSCRIPTION_OPERATORS.contains((Object)name)) {
            return "[]";
        }
        return this.getRangeInElement().substring(this.myElement.getText());
    }

    @Nullable
    public PyExpression getReceiver() {
        if (this.myElement instanceof PyBinaryExpression) {
            return ((PyBinaryExpression)this.myElement).getLeftExpression();
        }
        if (this.myElement instanceof PySubscriptionExpression) {
            return ((PySubscriptionExpression)this.myElement).getOperand();
        }
        if (this.myElement instanceof PyPrefixExpression) {
            return ((PyPrefixExpression)this.myElement).getOperand();
        }
        return null;
    }

    private static String leftToRightOperatorName(String name) {
        return name.replaceFirst("__([a-z]+)__", "__r$1__");
    }

    private static boolean isTrueDivEnabled(@NotNull PyElement anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/psi/impl/references/PyOperatorReference", "isTrueDivEnabled"));
        }
        PsiFile file = anchor.getContainingFile();
        if (file instanceof PyFile) {
            PyFile pyFile = (PyFile)file;
            return FutureFeature.DIVISION.requiredAt(pyFile.getLanguageLevel()) || pyFile.hasImportFromFuture(FutureFeature.DIVISION);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveLeftAndRightOperators(List<RatedResolveResult> res, PyBinaryExpression expr, String name) {
        TypeEvalContext typeEvalContext = this.myContext.getTypeEvalContext();
        typeEvalContext.trace("Trying to resolve left operator", new Object[0]);
        typeEvalContext.traceIndent();
        try {
            res.addAll(this.resolveMember(expr.getLeftExpression(), name));
        }
        finally {
            typeEvalContext.traceUnindent();
        }
        typeEvalContext.trace("Trying to resolve right operator", new Object[0]);
        typeEvalContext.traceIndent();
        try {
            res.addAll(this.resolveMember(expr.getRightExpression(), PyOperatorReference.leftToRightOperatorName(name)));
        }
        finally {
            typeEvalContext.traceUnindent();
        }
    }

    @NotNull
    private List<RatedResolveResult> resolveMember(@Nullable PyExpression object, @Nullable String name) {
        ArrayList<RatedResolveResult> results = new ArrayList<RatedResolveResult>();
        if (object != null && name != null) {
            TypeEvalContext typeEvalContext = this.myContext.getTypeEvalContext();
            PyType type = typeEvalContext.getType(object);
            typeEvalContext.trace("Side text is %s, type is %s", object.getText(), type);
            if (type != null) {
                List<? extends RatedResolveResult> res = type.resolveMember(name, object, AccessDirection.of(this.myElement), this.myContext);
                if (res != null && res.size() > 0) {
                    results.addAll(res);
                } else if (typeEvalContext.tracing()) {
                    VirtualFile vFile = null;
                    if (type instanceof PyClassType) {
                        PyClass pyClass = ((PyClassType)type).getPyClass();
                        vFile = pyClass.getContainingFile().getVirtualFile();
                    }
                    type.resolveMember(name, object, AccessDirection.of(this.myElement), this.myContext);
                    typeEvalContext.trace("Could not resolve member %s in type %s from file %s", name, type, vFile);
                }
            }
        }
        ArrayList<RatedResolveResult> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyOperatorReference", "resolveMember"));
        }
        return arrayList;
    }
}

