/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.references;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.impl.references.PyFromImportNameReference;
import com.jetbrains.python.psi.impl.references.PyFromImportSourceReference;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.QualifiedNameResolver;
import com.jetbrains.python.psi.resolve.QualifiedNameResolverImpl;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyImportReference
extends PyReferenceImpl {
    protected final PyReferenceExpressionImpl myElement;

    public PyImportReference(PyReferenceExpressionImpl element, PyResolveContext context) {
        super(element, context);
        this.myElement = element;
    }

    public static PyImportReference forElement(PyReferenceExpressionImpl expression, PsiElement importParent, PyResolveContext context) {
        if (importParent instanceof PyImportElement) {
            PyImportStatementBase importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)importParent, PyImportStatementBase.class);
            if (importStatement instanceof PyFromImportStatement) {
                return new PyFromImportNameReference(expression, context);
            }
            return new PyImportReference(expression, context);
        }
        return new PyFromImportSourceReference(expression, context);
    }

    @Override
    public String getUnresolvedDescription() {
        PyImportStatement importStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyImportStatement.class);
        if (importStatement != null) {
            return "No module named " + this.myElement.getReferencedName();
        }
        return super.getUnresolvedDescription();
    }

    @Override
    @NotNull
    protected List<RatedResolveResult> resolveInner() {
        PyImportElement parent = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyImportElement.class);
        QualifiedName qname = this.myElement.asQualifiedName();
        List<RatedResolveResult> list = qname == null ? Collections.emptyList() : ResolveImportUtil.resolveNameInImportStatement(parent, qname);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyImportReference", "resolveInner"));
        }
        return list;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        PsiErrorElement prevError;
        PyImportElement importElement = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyImportElement.class);
        if (importElement != null && (prevError = (PsiErrorElement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)importElement, PsiErrorElement.class)) != null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyImportReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        PyExpression qualifier = this.myElement.getQualifier();
        TypeEvalContext context = TypeEvalContext.userInitiated(this.myElement.getProject(), CompletionUtil.getOriginalOrSelf(this.myElement).getContainingFile());
        if (qualifier != null) {
            PyType type = context.getType(qualifier);
            if (type != null) {
                Object[] variants = PyImportReference.getTypeCompletionVariants(this.myElement, type);
                if (!this.alreadyHasImportKeyword()) {
                    PyImportReference.replaceInsertHandler(variants, ImportKeywordHandler.INSTANCE);
                }
                if (variants == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyImportReference", "getVariants"));
                }
                return variants;
            }
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyImportReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = new ImportVariantCollector(context).execute();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/references/PyImportReference", "getVariants"));
        }
        return objectArray;
    }

    private static void replaceInsertHandler(Object[] variants, InsertHandler<LookupElement> insertHandler) {
        for (int i = 0; i < variants.length; ++i) {
            Object item = variants[i];
            if (PyImportReference.hasChildPackages(item)) continue;
            if (item instanceof LookupElementBuilder) {
                variants[i] = ((LookupElementBuilder)item).withInsertHandler(insertHandler);
                continue;
            }
            if (!(item instanceof PsiNamedElement)) continue;
            PsiNamedElement element = (PsiNamedElement)item;
            String name = element.getName();
            assert (name != null);
            variants[i] = LookupElementBuilder.create((String)name).withIcon(element.getIcon(0)).withInsertHandler(insertHandler);
        }
    }

    private static boolean hasChildPackages(Object item) {
        LookupElement lookupElement;
        PsiElement itemElement = null;
        if (item instanceof PsiElement) {
            itemElement = (PsiElement)item;
        } else if (item instanceof LookupElement && (lookupElement = (LookupElement)item).getObject() instanceof PsiElement) {
            itemElement = (PsiElement)lookupElement.getObject();
        }
        return !(itemElement instanceof PsiFile);
    }

    private boolean alreadyHasImportKeyword() {
        if (PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyImportStatement.class) != null) {
            return true;
        }
        for (ASTNode node = this.myElement.getNode(); node != null; node = node.getTreeNext()) {
            IElementType nodeType = node.getElementType();
            if (nodeType != PyTokenTypes.IMPORT_KEYWORD) continue;
            return true;
        }
        return false;
    }

    private static class ImportKeywordHandler
    implements InsertHandler<LookupElement> {
        public static final InsertHandler<LookupElement> INSTANCE = new ImportKeywordHandler();
        private static final String IMPORT_KWD = " import ";

        private ImportKeywordHandler() {
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            Editor editor = context.getEditor();
            Document document = editor.getDocument();
            int tailOffset = context.getTailOffset();
            document.insertString(tailOffset, (CharSequence)IMPORT_KWD);
            editor.getCaretModel().moveToOffset(tailOffset + IMPORT_KWD.length());
        }
    }

    class ImportVariantCollector {
        private final PsiFile myCurrentFile;
        private final Set<String> myNamesAlready;
        private final List<Object> myObjects;
        @NotNull
        private final TypeEvalContext myContext;

        public ImportVariantCollector(TypeEvalContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/references/PyImportReference$ImportVariantCollector", "<init>"));
            }
            this.myContext = context;
            PsiFile currentFile = PyImportReference.this.myElement.getContainingFile();
            this.myCurrentFile = currentFile = currentFile.getOriginalFile();
            this.myNamesAlready = new HashSet<String>();
            this.myObjects = new ArrayList<Object>();
        }

        public Object[] execute() {
            int relativeLevel = -1;
            InsertHandler<LookupElement> insertHandler = null;
            PyFromImportStatement fromImport = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)PyImportReference.this.myElement, PyFromImportStatement.class);
            if (fromImport != null && PyImportReference.this.myElement.getParent() != fromImport) {
                PyReferenceExpression src = fromImport.getImportSource();
                if (src != null) {
                    PsiElement modCandidate = src.getReference().resolve();
                    if (modCandidate instanceof PyExpression) {
                        this.addImportedNames(fromImport.getImportElements());
                        PyExpression module = (PyExpression)modCandidate;
                        PyType qualifierType = this.myContext.getType(module);
                        if (qualifierType != null) {
                            ProcessingContext ctx = new ProcessingContext();
                            ctx.put(PyType.CTX_NAMES, this.myNamesAlready);
                            Collections.addAll(this.myObjects, qualifierType.getCompletionVariants(PyImportReference.this.myElement.getName(), (PsiElement)PyImportReference.this.myElement, ctx));
                        }
                        return this.myObjects.toArray();
                    }
                    if (modCandidate instanceof PsiDirectory) {
                        this.fillFromDir((PsiDirectory)modCandidate, ImportKeywordHandler.INSTANCE);
                        return this.myObjects.toArray();
                    }
                } else {
                    PsiDirectory relativeDir;
                    relativeLevel = fromImport.getRelativeLevel();
                    if (relativeLevel > 0 && (relativeDir = ResolveImportUtil.stepBackFrom(this.myCurrentFile, relativeLevel)) != null) {
                        this.addImportedNames(fromImport.getImportElements());
                        this.fillFromDir(relativeDir, null);
                    }
                }
            } else {
                PsiDirectory containingDirectory;
                for (ASTNode n = PyImportReference.this.myElement.getNode().getTreePrev(); n != null && n.getElementType() == PyTokenTypes.DOT; n = n.getTreePrev()) {
                    ++relativeLevel;
                }
                if (fromImport != null) {
                    this.addImportedNames(fromImport.getImportElements());
                    if (!PyImportReference.this.alreadyHasImportKeyword()) {
                        insertHandler = ImportKeywordHandler.INSTANCE;
                    }
                } else {
                    this.myNamesAlready.add("__future__");
                    PyImportStatement importStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)PyImportReference.this.myElement, PyImportStatement.class);
                    if (importStatement != null) {
                        this.addImportedNames(importStatement.getImportElements());
                    }
                }
                if (!(relativeLevel < 0 && ResolveImportUtil.isAbsoluteImportEnabledFor((PsiElement)this.myCurrentFile) || (containingDirectory = this.myCurrentFile.getContainingDirectory()) == null)) {
                    QualifiedName thisQName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)containingDirectory);
                    if (thisQName == null || thisQName.getComponentCount() == relativeLevel) {
                        this.fillFromDir(ResolveImportUtil.stepBackFrom(this.myCurrentFile, relativeLevel), insertHandler);
                    } else if (thisQName.getComponentCount() > relativeLevel) {
                        thisQName = thisQName.removeTail(relativeLevel);
                        this.fillFromQName(thisQName, insertHandler);
                    }
                }
            }
            if (relativeLevel == -1) {
                this.fillFromQName(QualifiedName.fromComponents((String[])new String[0]), insertHandler);
            }
            return ArrayUtil.toObjectArray(this.myObjects);
        }

        private void fillFromQName(QualifiedName thisQName, InsertHandler<LookupElement> insertHandler) {
            QualifiedNameResolver visitor = new QualifiedNameResolverImpl(thisQName).fromElement((PsiElement)this.myCurrentFile);
            for (PsiDirectory dir : visitor.resultsOfType(PsiDirectory.class)) {
                this.fillFromDir(dir, insertHandler);
            }
        }

        private void addImportedNames(@NotNull PyImportElement[] importElements) {
            if (importElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importElements", "com/jetbrains/python/psi/impl/references/PyImportReference$ImportVariantCollector", "addImportedNames"));
            }
            for (PyImportElement element : importElements) {
                String s;
                PyReferenceExpression ref = element.getImportReferenceExpression();
                if (ref == null || (s = ref.getReferencedName()) == null) continue;
                this.myNamesAlready.add(s);
            }
        }

        private void fillFromDir(PsiDirectory targetDir, @Nullable InsertHandler<LookupElement> insertHandler) {
            if (targetDir != null) {
                PsiFile initPy = targetDir.findFile("__init__.py");
                if (initPy instanceof PyFile) {
                    PyModuleType moduleType = new PyModuleType((PyFile)initPy);
                    ProcessingContext context = new ProcessingContext();
                    context.put(PyType.CTX_NAMES, this.myNamesAlready);
                    Object[] completionVariants = moduleType.getCompletionVariants("", PyImportReference.this.getElement(), context);
                    if (insertHandler != null) {
                        PyImportReference.replaceInsertHandler(completionVariants, (InsertHandler<LookupElement>)insertHandler);
                    }
                    this.myObjects.addAll(Arrays.asList(completionVariants));
                } else {
                    this.myObjects.addAll(PyModuleType.getSubModuleVariants(targetDir, (PsiElement)PyImportReference.this.myElement, this.myNamesAlready));
                }
            }
        }
    }
}

