/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyKeywordArgumentProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class KeywordArgumentCompletionUtil {
    public static void collectFunctionArgNames(PyElement element, List<LookupElement> ret) {
        PyExpression callee;
        PyCallExpression callExpr = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (callExpr != null && (callee = callExpr.getCallee()) instanceof PyReferenceExpression && element.getParent() == callExpr.getArgumentList()) {
            PyFunction init;
            QualifiedResolveResult result = ((PyReferenceExpression)callee).followAssignmentsChain(PyResolveContext.defaultContext());
            PsiElement def = result.getElement();
            if (def instanceof PyFunction) {
                KeywordArgumentCompletionUtil.addKeywordArgumentVariants((PyFunction)def, callExpr, ret);
            } else if (def instanceof PyClass && (init = ((PyClass)def).findMethodByName("__init__", true)) != null) {
                KeywordArgumentCompletionUtil.addKeywordArgumentVariants(init, callExpr, ret);
            }
        }
    }

    public static void addKeywordArgumentVariants(PyFunction def, PyCallExpression callExpr, List<LookupElement> ret) {
        KeywordArgumentCompletionUtil.addKeywordArgumentVariants(def, callExpr, ret, new HashSet<PyFunction>());
    }

    public static void addKeywordArgumentVariants(PyFunction def, PyCallExpression callExpr, List<LookupElement> ret, Collection<PyFunction> visited) {
        if (visited.contains(def)) {
            return;
        }
        visited.add(def);
        boolean needSelf = def.getContainingClass() != null && def.getModifier() != PyFunction.Modifier.STATICMETHOD;
        KwArgParameterCollector collector = new KwArgParameterCollector(needSelf, ret);
        TypeEvalContext context = TypeEvalContext.userInitiated(def.getProject(), def.getContainingFile());
        List<PyParameter> parameters = PyUtil.getParameters(def, context);
        for (PyParameter parameter : parameters) {
            parameter.accept(collector);
        }
        if (collector.hasKwArgs()) {
            PsiElement superMethod;
            for (PyKeywordArgumentProvider provider : (PyKeywordArgumentProvider[])Extensions.getExtensions(PyKeywordArgumentProvider.EP_NAME)) {
                List<String> arguments = provider.getKeywordArguments(def, callExpr);
                for (String argument : arguments) {
                    ret.add(PyUtil.createNamedParameterLookup(argument));
                }
            }
            KwArgFromStatementCallCollector fromStatementCallCollector = new KwArgFromStatementCallCollector(ret, collector.getKwArgs());
            PyStatementList statementList = def.getStatementList();
            if (statementList != null) {
                statementList.acceptChildren(fromStatementCallCollector);
            }
            if (fromStatementCallCollector.isKwArgsTransit() && (superMethod = (PsiElement)PySuperMethodsSearch.search(def).findFirst()) instanceof PyFunction) {
                KeywordArgumentCompletionUtil.addKeywordArgumentVariants((PyFunction)superMethod, callExpr, ret, visited);
            }
        }
    }

    public static class KwArgFromStatementCallCollector
    extends PyElementVisitor {
        private final List<LookupElement> myRet;
        private final PyParameter myKwArgs;
        private boolean kwArgsTransit;

        public KwArgFromStatementCallCollector(List<LookupElement> ret, @NotNull PyParameter kwArgs) {
            if (kwArgs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kwArgs", "com/jetbrains/python/psi/impl/references/KeywordArgumentCompletionUtil$KwArgFromStatementCallCollector", "<init>"));
            }
            this.kwArgsTransit = true;
            this.myRet = ret;
            this.myKwArgs = kwArgs;
        }

        @Override
        public void visitPyElement(PyElement node) {
            node.acceptChildren(this);
        }

        @Override
        public void visitPySubscriptionExpression(PySubscriptionExpression node) {
            String operandName = node.getOperand().getName();
            this.processGet(operandName, node.getIndexExpression());
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            block4: {
                block3: {
                    if (!node.isCalleeText("pop", "get", "getattr")) break block3;
                    PyReferenceExpression child = (PyReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)node.getCallee(), PyReferenceExpression.class);
                    if (child == null) break block4;
                    String operandName = child.getName();
                    if (node.getArguments().length > 0) {
                        PyExpression argument = node.getArguments()[0];
                        this.processGet(operandName, argument);
                    }
                    break block4;
                }
                if (node.isCalleeText("__init__")) {
                    this.kwArgsTransit = false;
                    for (PyExpression e : node.getArguments()) {
                        if (!(e instanceof PyStarArgument)) continue;
                        PyStarArgument kw = (PyStarArgument)e;
                        if (!Comparing.equal((String)this.myKwArgs.getName(), (String)kw.getFirstChild().getNextSibling().getText())) continue;
                        this.kwArgsTransit = true;
                        break;
                    }
                }
            }
            super.visitPyCallExpression(node);
        }

        private void processGet(String operandName, PyExpression argument) {
            String name;
            if (Comparing.equal((String)this.myKwArgs.getName(), (String)operandName) && argument instanceof PyStringLiteralExpression && PyUtil.isPythonIdentifier(name = ((PyStringLiteralExpression)argument).getStringValue())) {
                this.myRet.add(PyUtil.createNamedParameterLookup(name));
            }
        }

        public boolean isKwArgsTransit() {
            return this.kwArgsTransit;
        }
    }

    public static class KwArgParameterCollector
    extends PyElementVisitor {
        private int myCount;
        private final boolean myNeedSelf;
        private final List<LookupElement> myRet;
        private boolean myHasSelf = false;
        private boolean myHasKwArgs = false;
        private PyParameter kwArgsParam = null;

        public KwArgParameterCollector(boolean needSelf, List<LookupElement> ret) {
            this.myNeedSelf = needSelf;
            this.myRet = ret;
        }

        @Override
        public void visitPyParameter(PyParameter par) {
            block5: {
                block3: {
                    PyNamedParameter namedParam;
                    block4: {
                        ++this.myCount;
                        if (this.myCount == 1 && this.myNeedSelf) {
                            this.myHasSelf = true;
                            return;
                        }
                        namedParam = par.getAsNamed();
                        if (namedParam == null) break block3;
                        if (namedParam.isKeywordContainer() || namedParam.isPositionalContainer()) break block4;
                        LookupElement item = PyUtil.createNamedParameterLookup(namedParam.getName());
                        this.myRet.add(item);
                        break block5;
                    }
                    if (!namedParam.isKeywordContainer()) break block5;
                    this.myHasKwArgs = true;
                    this.kwArgsParam = namedParam;
                    break block5;
                }
                PyTupleParameter nestedTParam = par.getAsTuple();
                if (nestedTParam != null) {
                    for (PyParameter inner_par : nestedTParam.getContents()) {
                        inner_par.accept(this);
                    }
                }
            }
        }

        public PyParameter getKwArgs() {
            return this.kwArgsParam;
        }

        public boolean hasKwArgs() {
            return this.myHasKwArgs;
        }

        public boolean hasOnlySelfAndKwArgs() {
            return this.myCount == 2 && this.myHasSelf && this.myHasKwArgs;
        }
    }
}

