/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.blockEvaluator;

import com.google.common.collect.Sets;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPathEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.blockEvaluator.PyEvaluationContext;
import com.jetbrains.python.psi.impl.blockEvaluator.PyEvaluationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBlockEvaluator {
    @NotNull
    private final PyEvaluationResult myEvaluationResult;
    @NotNull
    private final PyEvaluationContext myContext;
    private final Set<PyFile> myVisitedFiles;
    private final Set<String> myDeclarationsToTrack;
    private String myCurrentFilePath;
    private Object myReturnValue;
    private boolean myEvaluateCollectionItems;

    public PyBlockEvaluator(@NotNull PyEvaluationContext evaluationContext) {
        if (evaluationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/jetbrains/python/psi/impl/blockEvaluator/PyBlockEvaluator", "<init>"));
        }
        this(Sets.newHashSet(), evaluationContext);
    }

    public PyBlockEvaluator() {
        this(new PyEvaluationContext());
    }

    private PyBlockEvaluator(@NotNull Set<PyFile> visitedFiles, @NotNull PyEvaluationContext evaluationContext) {
        if (visitedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedFiles", "com/jetbrains/python/psi/impl/blockEvaluator/PyBlockEvaluator", "<init>"));
        }
        if (evaluationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/jetbrains/python/psi/impl/blockEvaluator/PyBlockEvaluator", "<init>"));
        }
        this.myEvaluationResult = new PyEvaluationResult();
        this.myDeclarationsToTrack = new HashSet<String>();
        this.myEvaluateCollectionItems = true;
        this.myVisitedFiles = visitedFiles;
        this.myContext = evaluationContext;
    }

    public void trackDeclarations(String attrName) {
        this.myDeclarationsToTrack.add(attrName);
    }

    public void evaluate(PyElement element) {
        PyElement statementContainer;
        VirtualFile vFile = element.getContainingFile().getVirtualFile();
        String string = this.myCurrentFilePath = vFile != null ? vFile.getPath() : null;
        if (this.myVisitedFiles.contains(element)) {
            return;
        }
        this.myVisitedFiles.add((PyFile)element.getContainingFile());
        PyElement pyElement = statementContainer = element instanceof PyFunction ? ((PyFunction)element).getStatementList() : element;
        if (statementContainer == null) {
            return;
        }
        statementContainer.acceptChildren(new MyPyElementVisitor());
    }

    private void processExtendCall(PyCallExpression node, String nameBeingExtended) {
        List<PyExpression> declarations;
        PyExpression arg = node.getArguments()[0];
        Object value = this.myEvaluationResult.myNamespace.get(nameBeingExtended);
        if (value instanceof List) {
            Object argValue = this.prepareEvaluator().evaluate(arg);
            this.myEvaluationResult.myNamespace.put(nameBeingExtended, this.prepareEvaluator().concatenate(value, argValue));
        }
        if (this.myDeclarationsToTrack.contains(nameBeingExtended) && (declarations = this.myEvaluationResult.myDeclarations.get(nameBeingExtended)) != null) {
            PyPsiUtils.sequenceToList(declarations, arg);
        }
    }

    private void processUpdateCall(PyCallExpression node, String name) {
        Object argValue;
        Object value = this.myEvaluationResult.myNamespace.get(name);
        if (value instanceof Map && (argValue = this.prepareEvaluator().evaluate(node.getArguments()[0])) instanceof Map) {
            ((Map)value).putAll((Map)argValue);
        }
    }

    private PyEvaluator prepareEvaluator() {
        PyEvaluator evaluator = this.createEvaluator();
        evaluator.setNamespace(this.myEvaluationResult.myNamespace);
        evaluator.setEvaluateCollectionItems(this.myEvaluateCollectionItems);
        return evaluator;
    }

    protected PyEvaluator createEvaluator() {
        return new PyPathEvaluator(this.myCurrentFilePath);
    }

    public Object getValue(String name) {
        return this.myEvaluationResult.myNamespace.get(name);
    }

    @Nullable
    public String getValueAsString(String name) {
        Object value = this.myEvaluationResult.myNamespace.get(name);
        return value instanceof String ? (String)value : null;
    }

    @Nullable
    public List getValueAsList(String name) {
        Object value = this.myEvaluationResult.myNamespace.get(name);
        return value instanceof List ? (List)value : null;
    }

    @NotNull
    public List<String> getValueAsStringList(String name) {
        Object value = this.myEvaluationResult.myNamespace.get(name);
        if (value instanceof List) {
            List valueList = (List)value;
            for (Object o : valueList) {
                if (o == null || o instanceof String) continue;
                List<String> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/blockEvaluator/PyBlockEvaluator", "getValueAsStringList"));
                }
                return list;
            }
            List list = (List)value;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/blockEvaluator/PyBlockEvaluator", "getValueAsStringList"));
            }
            return list;
        }
        if (value instanceof String) {
            List<String> list = Collections.singletonList((String)value);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/blockEvaluator/PyBlockEvaluator", "getValueAsStringList"));
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/blockEvaluator/PyBlockEvaluator", "getValueAsStringList"));
        }
        return list;
    }

    public Set<PyFile> getVisitedFiles() {
        return this.myVisitedFiles;
    }

    public Object getReturnValue() {
        return this.myReturnValue;
    }

    public void setEvaluateCollectionItems(boolean evaluateCollectionItems) {
        this.myEvaluateCollectionItems = evaluateCollectionItems;
    }

    @NotNull
    public List<PyExpression> getDeclarations(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/blockEvaluator/PyBlockEvaluator", "getDeclarations"));
        }
        List<PyExpression> list = this.myEvaluationResult.getDeclarations(name);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/blockEvaluator/PyBlockEvaluator", "getDeclarations"));
        }
        return list;
    }

    @NotNull
    public PyEvaluationContext getContext() {
        PyEvaluationContext pyEvaluationContext = this.myContext;
        if (pyEvaluationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/blockEvaluator/PyBlockEvaluator", "getContext"));
        }
        return pyEvaluationContext;
    }

    private class MyPyElementVisitor
    extends PyElementVisitor {
        private MyPyElementVisitor() {
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            PyExpression expression = node.getLeftHandSideExpression();
            if (expression instanceof PyTargetExpression) {
                String name = expression.getName();
                PyExpression value = ((PyTargetExpression)expression).findAssignedValue();
                ((PyBlockEvaluator)PyBlockEvaluator.this).myEvaluationResult.myNamespace.put(name, PyBlockEvaluator.this.prepareEvaluator().evaluate(value));
                if (PyBlockEvaluator.this.myDeclarationsToTrack.contains(name)) {
                    ArrayList<PyExpression> declarations = new ArrayList<PyExpression>();
                    PyPsiUtils.sequenceToList(declarations, value);
                    ((PyBlockEvaluator)PyBlockEvaluator.this).myEvaluationResult.myDeclarations.put(name, declarations);
                }
            } else if (expression instanceof PySubscriptionExpression) {
                Object mapKey;
                Object currentValue;
                PyExpression operand = ((PySubscriptionExpression)expression).getOperand();
                PyExpression indexExpression = ((PySubscriptionExpression)expression).getIndexExpression();
                if (operand instanceof PyReferenceExpression && ((PyReferenceExpression)operand).getQualifier() == null && (currentValue = ((PyBlockEvaluator)PyBlockEvaluator.this).myEvaluationResult.myNamespace.get(((PyReferenceExpression)operand).getReferencedName())) instanceof Map && (mapKey = PyBlockEvaluator.this.prepareEvaluator().evaluate(indexExpression)) != null) {
                    PyExpression value = PyBlockEvaluator.this.myEvaluateCollectionItems ? PyBlockEvaluator.this.prepareEvaluator().evaluate(node.getAssignedValue()) : node.getAssignedValue();
                    ((Map)currentValue).put(mapKey, value);
                }
            }
        }

        @Override
        public void visitPyAugAssignmentStatement(PyAugAssignmentStatement node) {
            PyExpression target = node.getTarget();
            String name = target.getName();
            if (target instanceof PyReferenceExpression && !((PyReferenceExpression)target).isQualified() && name != null) {
                List<PyExpression> declarations;
                Object currentValue = ((PyBlockEvaluator)PyBlockEvaluator.this).myEvaluationResult.myNamespace.get(name);
                if (currentValue != null) {
                    Object rhs = PyBlockEvaluator.this.prepareEvaluator().evaluate(node.getValue());
                    ((PyBlockEvaluator)PyBlockEvaluator.this).myEvaluationResult.myNamespace.put(name, PyBlockEvaluator.this.prepareEvaluator().concatenate(currentValue, rhs));
                }
                if (PyBlockEvaluator.this.myDeclarationsToTrack.contains(name) && (declarations = ((PyBlockEvaluator)PyBlockEvaluator.this).myEvaluationResult.myDeclarations.get(name)) != null) {
                    PyPsiUtils.sequenceToList(declarations, node.getValue());
                }
            }
        }

        @Override
        public void visitPyExpressionStatement(PyExpressionStatement node) {
            node.getExpression().accept(this);
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyReferenceExpression qualifierRef;
            PyReferenceExpression calleeRef;
            PyExpression qualifier;
            PyExpression callee = node.getCallee();
            if (callee instanceof PyReferenceExpression && (qualifier = (calleeRef = (PyReferenceExpression)callee).getQualifier()) instanceof PyReferenceExpression && !(qualifierRef = (PyReferenceExpression)qualifier).isQualified()) {
                if ("extend".equals(calleeRef.getReferencedName()) && node.getArguments().length == 1) {
                    PyBlockEvaluator.this.processExtendCall(node, qualifierRef.getReferencedName());
                } else if ("update".equals(calleeRef.getReferencedName()) && node.getArguments().length == 1) {
                    PyBlockEvaluator.this.processUpdateCall(node, qualifierRef.getReferencedName());
                }
            }
        }

        @Override
        public void visitPyFromImportStatement(PyFromImportStatement node) {
            if (node.isFromFuture()) {
                return;
            }
            PsiElement source = PyUtil.turnDirIntoInit(node.resolveImportSource());
            if (source instanceof PyFile) {
                PyFile pyFile = (PyFile)source;
                PyEvaluationResult newlyEvaluatedResult = PyBlockEvaluator.this.myContext.getCachedResult(pyFile);
                if (newlyEvaluatedResult == null) {
                    PyBlockEvaluator importEvaluator = new PyBlockEvaluator(PyBlockEvaluator.this.myVisitedFiles, PyBlockEvaluator.this.myContext);
                    importEvaluator.myDeclarationsToTrack.addAll(PyBlockEvaluator.this.myDeclarationsToTrack);
                    importEvaluator.evaluate(pyFile);
                    newlyEvaluatedResult = importEvaluator.myEvaluationResult;
                    PyBlockEvaluator.this.myContext.cache(pyFile, newlyEvaluatedResult);
                }
                if (node.isStarImport()) {
                    ((PyBlockEvaluator)PyBlockEvaluator.this).myEvaluationResult.myNamespace.putAll(newlyEvaluatedResult.myNamespace);
                    ((PyBlockEvaluator)PyBlockEvaluator.this).myEvaluationResult.myDeclarations.putAll(newlyEvaluatedResult.myDeclarations);
                } else {
                    for (PyImportElement element : node.getImportElements()) {
                        String nameOfVarInOurModule = element.getVisibleName();
                        QualifiedName nameOfVarInExternalModule = element.getImportedQName();
                        if (nameOfVarInOurModule == null || nameOfVarInExternalModule == null) continue;
                        Object value = newlyEvaluatedResult.myNamespace.get(nameOfVarInExternalModule.toString());
                        ((PyBlockEvaluator)PyBlockEvaluator.this).myEvaluationResult.myNamespace.put(nameOfVarInOurModule, value);
                        List<PyExpression> declarations = newlyEvaluatedResult.getDeclarations(nameOfVarInOurModule);
                        if (((PyBlockEvaluator)PyBlockEvaluator.this).myEvaluationResult.myDeclarations.containsKey(nameOfVarInOurModule)) {
                            ((PyBlockEvaluator)PyBlockEvaluator.this).myEvaluationResult.myDeclarations.get(nameOfVarInOurModule).addAll(declarations);
                            continue;
                        }
                        ((PyBlockEvaluator)PyBlockEvaluator.this).myEvaluationResult.myDeclarations.put(nameOfVarInOurModule, declarations);
                    }
                }
            }
        }

        @Override
        public void visitPyIfStatement(PyIfStatement node) {
            PyStatementList list = node.getIfPart().getStatementList();
            if (list != null) {
                list.acceptChildren(this);
            }
        }

        @Override
        public void visitPyReturnStatement(PyReturnStatement node) {
            PyBlockEvaluator.this.myReturnValue = PyBlockEvaluator.this.prepareEvaluator().evaluate(node.getExpression());
        }
    }
}

