/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.FileContentUtil;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.facet.PythonFacetSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonLanguageLevelPusher
implements FilePropertyPusher<LanguageLevel> {
    private final Map<Module, Sdk> myModuleSdks = new WeakHashMap();
    private static final FileAttribute PERSISTENCE = new FileAttribute("python_language_level_persistence", 2, true);

    public static void pushLanguageLevel(Project project) {
        PushedFilePropertiesUpdater.getInstance(project).pushAll(new PythonLanguageLevelPusher());
    }

    @Override
    public void initExtra(@NotNull Project project, @NotNull MessageBus bus, @NotNull FilePropertyPusher.Engine languageLevelUpdater) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "initExtra"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "initExtra"));
        }
        if (languageLevelUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevelUpdater", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "initExtra"));
        }
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        HashSet<Sdk> usedSdks = new HashSet<Sdk>();
        for (Module module : modules) {
            if (!PythonLanguageLevelPusher.isPythonModule(module)) continue;
            Sdk sdk = PythonSdkType.findPythonSdk(module);
            this.myModuleSdks.put(module, sdk);
            if (sdk == null || usedSdks.contains(sdk)) continue;
            usedSdks.add(sdk);
            this.updateSdkLanguageLevel(project, sdk);
        }
    }

    @Override
    @NotNull
    public Key<LanguageLevel> getFileDataKey() {
        Key<LanguageLevel> key = LanguageLevel.KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "getFileDataKey"));
        }
        return key;
    }

    @Override
    public boolean pushDirectoriesOnly() {
        return true;
    }

    @Override
    @NotNull
    public LanguageLevel getDefaultValue() {
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "getDefaultValue"));
        }
        return languageLevel;
    }

    @Override
    public LanguageLevel getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "getImmediateValue"));
        }
        return PythonLanguageLevelPusher.getFileLanguageLevel(project, file);
    }

    public static LanguageLevel getFileLanguageLevel(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "getFileLanguageLevel"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && LanguageLevel.FORCE_LANGUAGE_LEVEL != null) {
            return LanguageLevel.FORCE_LANGUAGE_LEVEL;
        }
        if (file == null) {
            return null;
        }
        Sdk sdk = PythonLanguageLevelPusher.getFileSdk(project, file);
        return PythonSdkType.getLanguageLevelForSdk(sdk);
    }

    @Nullable
    private static Sdk getFileSdk(@NotNull Project project, @NotNull VirtualFile file) {
        Sdk sdk;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "getFileSdk"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "getFileSdk"));
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module != null && (sdk = PythonSdkType.findPythonSdk(module)) != null) {
            return sdk;
        }
        return PythonLanguageLevelPusher.findSdk(project, file);
    }

    @Nullable
    private static Sdk findSdk(Project project, VirtualFile file) {
        if (file != null) {
            List orderEntries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(file);
            for (OrderEntry orderEntry : orderEntries) {
                if (!(orderEntry instanceof JdkOrderEntry)) continue;
                return ((JdkOrderEntry)orderEntry).getJdk();
            }
        }
        return null;
    }

    @Override
    public LanguageLevel getImmediateValue(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "getImmediateValue"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && LanguageLevel.FORCE_LANGUAGE_LEVEL != null) {
            return LanguageLevel.FORCE_LANGUAGE_LEVEL;
        }
        Sdk sdk = PythonSdkType.findPythonSdk(module);
        return PythonSdkType.getLanguageLevelForSdk(sdk);
    }

    @Override
    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "acceptsFile"));
        }
        return false;
    }

    @Override
    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "acceptsDirectory"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "acceptsDirectory"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull LanguageLevel level) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "persistAttribute"));
        }
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "persistAttribute"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "persistAttribute"));
        }
        DataInputStream iStream = PERSISTENCE.readAttribute(fileOrDir);
        if (iStream != null) {
            try {
                int oldLevelOrdinal = DataInputOutputUtil.readINT((DataInput)iStream);
                if (oldLevelOrdinal == level.ordinal()) {
                    return;
                }
            }
            finally {
                iStream.close();
            }
        }
        DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);
        DataInputOutputUtil.writeINT((DataOutput)oStream, (int)level.ordinal());
        oStream.close();
        for (VirtualFile child : fileOrDir.getChildren()) {
            FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(child.getName());
            if (child.isDirectory() || !((Object)((Object)PythonFileType.INSTANCE)).equals(fileType)) continue;
            PythonLanguageLevelPusher.clearSdkPathCache(child);
            PushedFilePropertiesUpdater.getInstance(project).filePropertiesChanged(child);
        }
    }

    private static void clearSdkPathCache(@NotNull VirtualFile child) {
        Project[] projects;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "clearSdkPathCache"));
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            Sdk sdk = PythonLanguageLevelPusher.getFileSdk(project, child);
            if (sdk == null) continue;
            PythonSdkPathCache pathCache = PythonSdkPathCache.getInstance(project, sdk);
            pathCache.clearCache();
        }
    }

    @Override
    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "afterRootsChanged"));
        }
        HashSet<Sdk> updatedSdks = new HashSet<Sdk>();
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        boolean needReparseOpenFiles = false;
        for (Module module : modules) {
            if (!PythonLanguageLevelPusher.isPythonModule(module)) continue;
            Sdk newSdk = PythonSdkType.findPythonSdk(module);
            if (this.myModuleSdks.containsKey(module)) {
                Sdk oldSdk = this.myModuleSdks.get(module);
                if ((newSdk != null || oldSdk != null) && newSdk != oldSdk) {
                    needReparseOpenFiles = true;
                }
            }
            this.myModuleSdks.put(module, newSdk);
            if (newSdk == null || updatedSdks.contains(newSdk)) continue;
            updatedSdks.add(newSdk);
            this.updateSdkLanguageLevel(project, newSdk);
        }
        if (needReparseOpenFiles) {
            FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
        }
    }

    private static boolean isPythonModule(@NotNull Module module) {
        Facet[] allFacets;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "isPythonModule"));
        }
        ModuleType moduleType = ModuleType.get((Module)module);
        if (moduleType instanceof PythonModuleTypeBase) {
            return true;
        }
        for (Facet facet : allFacets = FacetManager.getInstance((Module)module).getAllFacets()) {
            if (!(facet.getConfiguration() instanceof PythonFacetSettings)) continue;
            return true;
        }
        return false;
    }

    private void updateSdkLanguageLevel(final Project project, Sdk sdk) {
        final LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
        final VirtualFile[] files = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        final Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                application.runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (project != null && project.isDisposed()) {
                            return;
                        }
                        for (VirtualFile file : files) {
                            if (!file.isValid()) continue;
                            VirtualFile parent = file.getParent();
                            boolean suppressSizeLimit = false;
                            if (parent != null && parent.getName().equals("python_stubs")) {
                                suppressSizeLimit = true;
                            }
                            PythonLanguageLevelPusher.this.markRecursively(project, file, languageLevel, suppressSizeLimit);
                        }
                    }
                });
            }
        });
    }

    private void markRecursively(final Project project, @NotNull VirtualFile file, final LanguageLevel languageLevel, final boolean suppressSizeLimit) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher", "markRecursively"));
        }
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$2", "visitFile"));
                }
                if (fileTypeManager.isFileIgnored(file)) {
                    return false;
                }
                if (file.isDirectory()) {
                    PushedFilePropertiesUpdater.getInstance(project).findAndUpdateValue(file, PythonLanguageLevelPusher.this, languageLevel);
                }
                if (suppressSizeLimit) {
                    SingleRootFileViewProvider.doNotCheckFileSizeLimit(file);
                }
                return true;
            }
        });
    }

    public static void setForcedLanguageLevel(Project project, @Nullable LanguageLevel languageLevel) {
        LanguageLevel.FORCE_LANGUAGE_LEVEL = languageLevel;
        PythonLanguageLevelPusher.pushLanguageLevel(project);
    }

    public void flushLanguageLevelCache() {
        this.myModuleSdks.clear();
    }
}

