/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.impl.PyElementImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PyWithStatementImpl
extends PyElementImpl
implements PyWithStatement {
    private static final TokenSet WITH_ITEM = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.WITH_ITEM});

    public PyWithStatementImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyWithStatement(this);
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        PyWithItem[] items = (PyWithItem[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PyWithItem.class);
        ArrayList<PyElement> result = new ArrayList<PyElement>();
        if (items != null) {
            for (PyWithItem item : items) {
                PyExpression targetExpression = item.getTarget();
                result.addAll(PyUtil.flattenedParensAndTuples(targetExpression));
            }
        }
        ArrayList<PyElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyWithStatementImpl", "iterateNames"));
        }
        return arrayList;
    }

    @Override
    public PsiElement getElementNamed(String the_name) {
        PyElement named_elt = NameDefiner.IterHelper.findName(this.iterateNames(), the_name);
        return named_elt;
    }

    @Override
    public boolean mustResolveOutside() {
        return false;
    }

    @Override
    public PyWithItem[] getWithItems() {
        return (PyWithItem[])this.childrenToPsi(WITH_ITEM, PyWithItem.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public PyStatementList getStatementList() {
        PyStatementList statementList = (PyStatementList)this.childToPsi(PyElementTypes.STATEMENT_LIST);
        assert (statementList != null) : "Statement list missing for with statement " + this.getText();
        PyStatementList pyStatementList = statementList;
        if (pyStatementList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyWithStatementImpl", "getStatementList"));
        }
        return pyStatementList;
    }
}

