/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.documentation.DocStringUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.ComprhForComponent;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.impl.TypeEvalStack;
import com.jetbrains.python.psi.impl.references.PyQualifiedReference;
import com.jetbrains.python.psi.impl.references.PyTargetReference;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStub;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTargetExpressionImpl
extends PyBaseElementImpl<PyTargetExpressionStub>
implements PyTargetExpression {
    QualifiedName myQualifiedName;

    public PyTargetExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyTargetExpressionImpl(PyTargetExpressionStub stub) {
        super(stub, PyElementTypes.TARGET_EXPRESSION);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyTargetExpression(this);
    }

    @Override
    @Nullable
    public String getName() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.getNameElement();
        return node != null ? node.getText() : null;
    }

    @Override
    public int getTextOffset() {
        ASTNode nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getStartOffset() : this.getTextRange().getStartOffset();
    }

    @Override
    @Nullable
    public ASTNode getNameElement() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
    }

    public PsiElement getNameIdentifier() {
        ASTNode nameElement = this.getNameElement();
        return nameElement == null ? null : nameElement.getPsi();
    }

    @Override
    public String getReferencedName() {
        return this.getName();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "setName"));
        }
        ASTNode oldNameElement = this.getNameElement();
        if (oldNameElement != null) {
            ASTNode nameElement = PyUtil.createNewName(this, name);
            this.getNode().replaceChild(oldNameElement, nameElement);
        }
        return this;
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getType"));
        }
        return this.getTypeWithAnchor(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PyType getTypeWithAnchor(TypeEvalContext context, @Nullable PsiElement anchor) {
        if (!TypeEvalStack.mayEvaluate((PsiElement)this)) {
            return null;
        }
        try {
            PyType pyType;
            Object assignment;
            Object nextParent;
            if ("__all__".equals(this.getName())) {
                PyType pyType2 = null;
                return pyType2;
            }
            PyType pyType3 = PyReferenceExpressionImpl.getReferenceTypeFromProviders((PsiElement)this, context, anchor);
            if (pyType3 != null) {
                PyType pyType4 = pyType3;
                return pyType4;
            }
            PyType type = this.getTypeFromDocString();
            if (type != null) {
                PyType pyType5 = type;
                return pyType5;
            }
            if (!context.maySwitchToAST((PsiElement)this)) {
                PyExpression value;
                PyExpression pyExpression = value = this.getStub() != null ? this.findAssignedValueByStub(context) : this.findAssignedValue();
                if (value instanceof PyTypedElement) {
                    type = context.getType(value);
                    if (type instanceof PyNoneType) {
                        PyType pyType6 = null;
                        return pyType6;
                    }
                    if (type instanceof PyFunctionType) {
                        PyType pyType7 = type;
                        return pyType7;
                    }
                    PyType pyType8 = PyUnionType.createWeakType(type);
                    return pyType8;
                }
                PyType pyType9 = null;
                return pyType9;
            }
            type = PyTargetExpressionImpl.getTypeFromComment(this);
            if (type != null) {
                PyType value = type;
                return value;
            }
            PsiElement parent = this.getParent();
            if (parent instanceof PyAssignmentStatement) {
                PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)parent;
                PyExpression assignedValue = assignmentStatement.getAssignedValue();
                if (assignedValue instanceof PyParenthesizedExpression) {
                    assignedValue = ((PyParenthesizedExpression)assignedValue).getContainedExpression();
                }
                if (assignedValue != null) {
                    Object refex;
                    if (assignedValue instanceof PyReferenceExpressionImpl) {
                        refex = (PyReferenceExpressionImpl)assignedValue;
                        PyType maybe_type = PyUtil.getSpecialAttributeType((PyReferenceExpression)refex, context);
                        if (maybe_type != null) {
                            PyType pyType10 = maybe_type;
                            return pyType10;
                        }
                        PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
                        ResolveResult[] resolveResult = ((PyReferenceExpressionImpl)refex).getReference(resolveContext).multiResolve(false);
                        if (resolveResult.length == 1) {
                            PsiElement target = resolveResult[0].getElement();
                            if (target == this || target == null) {
                                PyType pyType11 = null;
                                return pyType11;
                            }
                            PyType typeFromTarget = PyReferenceExpressionImpl.getTypeFromTarget(target, context, (PyReferenceExpression)refex);
                            if (target instanceof PyTargetExpression && typeFromTarget instanceof PyNoneType) {
                                PyType pyType12 = null;
                                return pyType12;
                            }
                            Ref<PyType> typeOfProperty = ((PyReferenceExpressionImpl)refex).getTypeOfProperty(context);
                            if (typeOfProperty != null) {
                                PyType pyType13 = (PyType)typeOfProperty.get();
                                return pyType13;
                            }
                            PyType cfgType = ((PyReferenceExpressionImpl)refex).getQualifiedReferenceTypeByControlFlow(context);
                            if (cfgType != null) {
                                PyType pyType14 = cfgType;
                                return pyType14;
                            }
                            PyType pyType15 = typeFromTarget;
                            return pyType15;
                        }
                    }
                    if (assignedValue instanceof PyYieldExpression) {
                        refex = null;
                        return refex;
                    }
                    refex = context.getType(assignedValue);
                    return refex;
                }
            }
            if (parent instanceof PyTupleExpression) {
                PyType t;
                PyType assignedType;
                PyExpression value;
                nextParent = parent.getParent();
                while (nextParent instanceof PyParenthesizedExpression) {
                    nextParent = nextParent.getParent();
                }
                if (nextParent instanceof PyAssignmentStatement && (value = (assignment = (PyAssignmentStatement)nextParent).getAssignedValue()) != null && (assignedType = PyTypeChecker.toNonWeakType(context.getType(value), context)) instanceof PyTupleType && (t = this.getTypeFromTupleAssignment((PyTupleExpression)parent, (PyTupleType)assignedType)) != null) {
                    PyType pyType16 = t;
                    return pyType16;
                }
            }
            if (parent instanceof PyWithItem) {
                nextParent = PyTargetExpressionImpl.getWithItemVariableType(context, (PyWithItem)parent);
                return nextParent;
            }
            PyType iterType = this.getTypeFromIteration(context);
            if (iterType != null) {
                assignment = iterType;
                return assignment;
            }
            PyType excType = this.getTypeFromExcept();
            if (excType != null) {
                pyType = excType;
                return pyType;
            }
            pyType = null;
            return pyType;
        }
        finally {
            TypeEvalStack.evaluated((PsiElement)this);
        }
    }

    @Nullable
    private static PyType getWithItemVariableType(TypeEvalContext context, PyWithItem item) {
        PyClass cls;
        PyFunction enter;
        PyType exprType;
        PyExpression expression = item.getExpression();
        if (expression != null && (exprType = context.getType(expression)) instanceof PyClassType && (enter = (cls = ((PyClassType)exprType).getPyClass()).findMethodByName("__enter__", true)) != null) {
            PyType enterType = enter.getCallType(expression, Collections.emptyMap(), context);
            if (enterType != null) {
                return enterType;
            }
            for (PyTypeProvider provider : (PyTypeProvider[])Extensions.getExtensions(PyTypeProvider.EP_NAME)) {
                PyType typeFromProvider = provider.getContextManagerVariableType(cls, expression, context);
                if (typeFromProvider == null) continue;
                return typeFromProvider;
            }
            return PyUnionType.createWeakType(exprType);
        }
        return null;
    }

    @Nullable
    public PyType getTypeFromDocString() {
        StructuredDocString classDocString;
        PyClass cls;
        String typeName = null;
        String name = this.getName();
        StructuredDocString targetDocString = this.getStructuredDocString();
        if (targetDocString != null && (typeName = targetDocString.getParamType(null)) == null) {
            typeName = targetDocString.getParamType(name);
        }
        if (typeName == null && PyUtil.isAttribute(this) && (cls = this.getContainingClass()) != null && (classDocString = cls.getStructuredDocString()) != null) {
            typeName = classDocString.getParamType(name);
        }
        if (typeName != null) {
            return PyTypeParser.getTypeByName((PsiElement)this, typeName);
        }
        return null;
    }

    @Nullable
    public static PyType getTypeFromComment(PyTargetExpressionImpl targetExpression) {
        StructuredDocString structuredDocString;
        String docComment = DocStringUtil.getAttributeDocComment(targetExpression);
        if (docComment != null && (structuredDocString = DocStringUtil.parse(docComment)) != null) {
            String typeName = structuredDocString.getParamType(null);
            if (typeName == null) {
                typeName = structuredDocString.getParamType(targetExpression.getName());
            }
            if (typeName != null) {
                return PyTypeParser.getTypeByName((PsiElement)targetExpression, typeName);
            }
        }
        return null;
    }

    @Nullable
    private PyType getTypeFromTupleAssignment(@NotNull PyTupleExpression tuple, @NotNull PyTupleType tupleType) {
        if (tuple == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tuple", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getTypeFromTupleAssignment"));
        }
        if (tupleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tupleType", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getTypeFromTupleAssignment"));
        }
        int count = tupleType.getElementCount();
        Object[] elements = tuple.getElements();
        if (elements.length == count) {
            int index = ArrayUtil.indexOf((Object[])elements, (Object)this);
            if (index >= 0) {
                return tupleType.getElementType(index);
            }
            for (int i = 0; i < count; ++i) {
                PyType result;
                PyType elementType;
                Object element = elements[i];
                while (element instanceof PyParenthesizedExpression) {
                    element = ((PyParenthesizedExpression)element).getContainedExpression();
                }
                if (!(element instanceof PyTupleExpression) || !((elementType = tupleType.getElementType(i)) instanceof PyTupleType) || (result = this.getTypeFromTupleAssignment((PyTupleExpression)element, (PyTupleType)elementType)) == null) continue;
                return result;
            }
        }
        return null;
    }

    @Nullable
    private PyType getTypeFromIteration(@NotNull TypeEvalContext context) {
        PyComprehensionElement comprh;
        PyExpression expr;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getTypeFromIteration"));
        }
        PyExpression target = null;
        PyExpression source = null;
        PyForPart forPart = (PyForPart)PsiTreeUtil.getParentOfType((PsiElement)this, PyForPart.class);
        if (forPart != null && PsiTreeUtil.isAncestor((PsiElement)(expr = forPart.getTarget()), (PsiElement)this, (boolean)false)) {
            target = expr;
            source = forPart.getSource();
        }
        if ((comprh = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)this, PyComprehensionElement.class)) != null) {
            for (ComprhForComponent c : comprh.getForComponents()) {
                PyExpression expr2 = c.getIteratorVariable();
                if (!PsiTreeUtil.isAncestor((PsiElement)expr2, (PsiElement)this, (boolean)false)) continue;
                target = expr2;
                source = c.getIteratedList();
            }
        }
        if (source != null) {
            PyType sourceType = context.getType(source);
            PyType type = PyTargetExpressionImpl.getIterationType(sourceType, source, (PsiElement)this, context);
            if (type instanceof PyTupleType && target instanceof PyTupleExpression) {
                return this.getTypeFromTupleAssignment((PyTupleExpression)target, (PyTupleType)type);
            }
            if (target == this && type != null) {
                return type;
            }
        }
        return null;
    }

    @Nullable
    private static PyType getIterationType(@Nullable PyType iterableType, @Nullable PyExpression source, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getIterationType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getIterationType"));
        }
        PyType result = null;
        if (iterableType instanceof PyCollectionType) {
            result = ((PyCollectionType)iterableType).getElementType(context);
            if (iterableType instanceof PyClassType) {
                PyTupleType mappingType;
                PyClass cls = ((PyClassType)iterableType).getPyClass();
                if (result instanceof PyTupleType && PyABCUtil.isSubclass(cls, "Mapping") && (mappingType = (PyTupleType)result).getElementCount() == 2) {
                    result = mappingType.getElementType(0);
                }
            }
        } else {
            if (iterableType instanceof PyTupleType) {
                PyTupleType tupleType = (PyTupleType)iterableType;
                ArrayList<PyType> memberTypes = new ArrayList<PyType>();
                for (int i = 0; i < tupleType.getElementCount(); ++i) {
                    memberTypes.add(tupleType.getElementType(i));
                }
                return PyUnionType.union(memberTypes);
            }
            if (iterableType instanceof PyUnionType) {
                Collection<PyType> members = ((PyUnionType)iterableType).getMembers();
                ArrayList<PyType> iterationTypes = new ArrayList<PyType>();
                for (PyType member : members) {
                    iterationTypes.add(PyTargetExpressionImpl.getIterationType(member, source, anchor, context));
                }
                return PyUnionType.union(iterationTypes);
            }
            if (iterableType != null && PyABCUtil.isSubtype(iterableType, "Iterator", context)) {
                PyFunction getItem;
                String nextMethodName;
                PyFunction next;
                PyFunction iterateMethod = PyTargetExpressionImpl.findMethodByName(iterableType, "__iter__", context);
                PyType iterateMethodType = null;
                if (iterateMethod != null) {
                    iterateMethodType = PyTargetExpressionImpl.getContextSensitiveType(iterateMethod, context, source);
                }
                if (iterateMethodType instanceof PyCollectionType) {
                    PyCollectionType collectionType = (PyCollectionType)iterateMethodType;
                    result = collectionType.getElementType(context);
                }
                if (result == null && (next = PyTargetExpressionImpl.findMethodByName(iterableType, nextMethodName = LanguageLevel.forElement(anchor).isAtLeast(LanguageLevel.PYTHON30) ? "__next__" : "next", context)) != null) {
                    result = PyTargetExpressionImpl.getContextSensitiveType(next, context, source);
                }
                if (result == null && (getItem = PyTargetExpressionImpl.findMethodByName(iterableType, "__getitem__", context)) != null) {
                    result = PyTargetExpressionImpl.getContextSensitiveType(getItem, context, source);
                }
            }
        }
        return result;
    }

    @Nullable
    private static PyFunction findMethodByName(@NotNull PyType type, @NotNull String name, @NotNull TypeEvalContext context) {
        RatedResolveResult result;
        PsiElement element;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "findMethodByName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "findMethodByName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "findMethodByName"));
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext().withTypeEvalContext(context);
        List<? extends RatedResolveResult> results = type.resolveMember(name, null, AccessDirection.READ, resolveContext);
        if (results != null && !results.isEmpty() && (element = (result = results.get(0)).getElement()) instanceof PyFunction) {
            return (PyFunction)element;
        }
        return null;
    }

    @Nullable
    private static PyType getContextSensitiveType(@NotNull PyFunction function, @NotNull TypeEvalContext context, @Nullable PyExpression source) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getContextSensitiveType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getContextSensitiveType"));
        }
        return function.getCallType(source, Collections.emptyMap(), context);
    }

    @Nullable
    private PyType getTypeFromExcept() {
        PsiElement element;
        PyExceptPart exceptPart = (PyExceptPart)PsiTreeUtil.getParentOfType((PsiElement)this, PyExceptPart.class);
        if (exceptPart == null || exceptPart.getTarget() != this) {
            return null;
        }
        PyExpression exceptClass = exceptPart.getExceptClass();
        if (exceptClass instanceof PyReferenceExpression && (element = ((PyReferenceExpression)exceptClass).getReference().resolve()) instanceof PyClass) {
            return new PyClassTypeImpl((PyClass)element, false);
        }
        return null;
    }

    @Override
    public PyExpression getQualifier() {
        ASTNode qualifier = this.getNode().findChildByType(PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens());
        return qualifier != null ? (PyExpression)qualifier.getPsi() : null;
    }

    @Override
    @Nullable
    public QualifiedName asQualifiedName() {
        if (this.myQualifiedName == null) {
            this.myQualifiedName = PyPsiUtils.asQualifiedName(this);
        }
        return this.myQualifiedName;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getName();
    }

    public Icon getIcon(int flags) {
        if (this.isQualified() || PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, PyDocStringOwner.class) instanceof PyClass) {
            return PlatformIcons.FIELD_ICON;
        }
        return PlatformIcons.VARIABLE_ICON;
    }

    @Override
    public boolean isQualified() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            return stub.isQualified();
        }
        return this.getQualifier() != null;
    }

    @Override
    @Nullable
    public PyExpression findAssignedValue() {
        PyAssignmentStatement assignment;
        if (this.isValid() && (assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)this, PyAssignmentStatement.class)) != null) {
            List<Pair<PyExpression, PyExpression>> mapping = assignment.getTargetsToValuesMapping();
            for (Pair<PyExpression, PyExpression> pair : mapping) {
                PyExpression assigned_to = (PyExpression)pair.getFirst();
                if (assigned_to != this) continue;
                return (PyExpression)pair.getSecond();
            }
        }
        return null;
    }

    @Override
    public QualifiedName getAssignedQName() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            if (stub.getInitializerType() == PyTargetExpressionStub.InitializerType.ReferenceExpression) {
                return stub.getInitializer();
            }
            return null;
        }
        return PyPsiUtils.asQualifiedName(this.findAssignedValue());
    }

    @Nullable
    public PsiElement findAssignedValueByStub(@NotNull TypeEvalContext context) {
        String name;
        QualifiedName initializer;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "findAssignedValueByStub"));
        }
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null && stub.getInitializerType() == PyTargetExpressionStub.InitializerType.ReferenceExpression && (initializer = stub.getInitializer()) != null && initializer.getComponentCount() == 1 && (name = initializer.getLastComponent()) != null) {
            List<? extends RatedResolveResult> results;
            PyType type;
            PsiElement parent = this.getParentByStub();
            if (parent instanceof PyFile) {
                return ((PyFile)parent).getElementNamed(name);
            }
            if (parent instanceof PyClass && (type = context.getType((PyClass)parent)) != null && (results = type.resolveMember(name, null, AccessDirection.READ, PyResolveContext.noImplicits())) != null && !results.isEmpty()) {
                return results.get(0).getElement();
            }
        }
        return null;
    }

    @Override
    public QualifiedName getCalleeName() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            CustomTargetExpressionStub customStub;
            PyTargetExpressionStub.InitializerType initializerType = stub.getInitializerType();
            if (initializerType == PyTargetExpressionStub.InitializerType.CallExpression) {
                return stub.getInitializer();
            }
            if (initializerType == PyTargetExpressionStub.InitializerType.Custom && (customStub = stub.getCustomStub(CustomTargetExpressionStub.class)) != null) {
                return customStub.getCalleeName();
            }
            return null;
        }
        PyExpression value = this.findAssignedValue();
        if (value instanceof PyCallExpression) {
            PyExpression callee = ((PyCallExpression)value).getCallee();
            return PyPsiUtils.asQualifiedName(callee);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference getReference() {
        PsiPolyVariantReference psiPolyVariantReference = this.getReference(PyResolveContext.defaultContext());
        if (psiPolyVariantReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getReference"));
        }
        return psiPolyVariantReference;
    }

    @Override
    @NotNull
    public PsiPolyVariantReference getReference(PyResolveContext resolveContext) {
        if (this.isQualified()) {
            PyQualifiedReference pyQualifiedReference = new PyQualifiedReference(this, resolveContext);
            if (pyQualifiedReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getReference"));
            }
            return pyQualifiedReference;
        }
        PyTargetReference pyTargetReference = new PyTargetReference(this, resolveContext);
        if (pyTargetReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getReference"));
        }
        return pyTargetReference;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        if (this.isQualified()) {
            SearchScope searchScope = super.getUseScope();
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getUseScope"));
            }
            return searchScope;
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)this);
        if (owner != null) {
            Scope scope = ControlFlowCache.getScope(owner);
            if (scope.isGlobal(this.getName())) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.getProject());
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getUseScope"));
                }
                return globalSearchScope;
            }
            if (scope.isNonlocal(this.getName())) {
                LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)this.getContainingFile());
                if (localSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getUseScope"));
                }
                return localSearchScope;
            }
        }
        PyElement container = this;
        while (true) {
            PyElement parentContainer;
            if ((parentContainer = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)container, (Class[])new Class[]{PyFunction.class, PyClass.class})) instanceof PyClass) {
                if (!this.isQualified()) break;
                SearchScope searchScope = super.getUseScope();
                if (searchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getUseScope"));
                }
                return searchScope;
            }
            if (parentContainer == null) break;
            container = parentContainer;
        }
        if (container instanceof PyFunction) {
            LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)container);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getUseScope"));
            }
            return localSearchScope;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyTargetExpressionImpl", "getUseScope"));
        }
        return searchScope;
    }

    @Override
    public PyClass getContainingClass() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            StubElement functionParent;
            StubElement parentStub = stub.getParentStub();
            if (parentStub instanceof PyClassStub) {
                return (PyClass)((PyClassStub)parentStub).getPsi();
            }
            if (parentStub instanceof PyFunctionStub && (functionParent = parentStub.getParentStub()) instanceof PyClassStub) {
                return (PyClass)((PyClassStub)functionParent).getPsi();
            }
            return null;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{PyFunction.class, PyClass.class});
        if (parent instanceof PyClass) {
            return (PyClass)parent;
        }
        if (parent instanceof PyFunction) {
            return ((PyFunction)parent).getContainingClass();
        }
        return null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new PyElementPresentation(this){

            @Override
            @Nullable
            public String getLocationString() {
                PyClass containingClass = PyTargetExpressionImpl.this.getContainingClass();
                if (containingClass != null) {
                    return "(" + containingClass.getName() + " in " + 1.getPackageForFile(PyTargetExpressionImpl.this.getContainingFile()) + ")";
                }
                return super.getLocationString();
            }
        };
    }

    @Override
    @Nullable
    public String getDocStringValue() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            return stub.getDocString();
        }
        return DocStringUtil.getDocStringValue(this);
    }

    @Override
    @Nullable
    public StructuredDocString getStructuredDocString() {
        return DocStringUtil.getStructuredDocString(this);
    }

    @Override
    @Nullable
    public PyStringLiteralExpression getDocStringExpression() {
        PsiElement parent = this.getParent();
        if (parent instanceof PyAssignmentStatement) {
            PyExpression expression;
            PsiElement nextSibling;
            PyAssignmentStatement assignment = (PyAssignmentStatement)parent;
            for (nextSibling = assignment.getNextSibling(); nextSibling != null && (nextSibling instanceof PsiWhiteSpace || nextSibling instanceof PsiComment); nextSibling = nextSibling.getNextSibling()) {
            }
            if (nextSibling instanceof PyExpressionStatement && (expression = ((PyExpressionStatement)nextSibling).getExpression()) instanceof PyStringLiteralExpression) {
                return (PyStringLiteralExpression)expression;
            }
        }
        return null;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myQualifiedName = null;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return QualifiedNameFinder.getQualifiedName(this);
    }
}

