/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.references.PyOperatorReference;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PySubscriptableType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySubscriptionExpressionImpl
extends PyElementImpl
implements PySubscriptionExpression {
    public PySubscriptionExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    @NotNull
    public PyExpression getOperand() {
        PyExpression pyExpression = (PyExpression)this.childToPsiNotNull(PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens(), 0);
        if (pyExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PySubscriptionExpressionImpl", "getOperand"));
        }
        return pyExpression;
    }

    @Override
    @NotNull
    public PyExpression getRootOperand() {
        PyExpression operand = this.getOperand();
        while (operand instanceof PySubscriptionExpression) {
            operand = ((PySubscriptionExpression)operand).getOperand();
        }
        PyExpression pyExpression = operand;
        if (pyExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PySubscriptionExpressionImpl", "getRootOperand"));
        }
        return pyExpression;
    }

    @Override
    @Nullable
    public PyExpression getIndexExpression() {
        return (PyExpression)this.childToPsi(PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens(), 1);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPySubscriptionExpression(this);
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PySubscriptionExpressionImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PySubscriptionExpressionImpl", "getType"));
        }
        PsiPolyVariantReference reference = this.getReference(PyResolveContext.noImplicits().withTypeEvalContext(context));
        ArrayList<PyType> members = new ArrayList<PyType>();
        for (PsiElement resolved : PyUtil.multiResolveTopPriority(reference)) {
            PyExpression indexExpression;
            PyType res = null;
            if (resolved instanceof Callable) {
                res = ((Callable)resolved).getCallType(context, this);
            }
            if ((PyTypeChecker.isUnknown(res) || res instanceof PyNoneType) && (indexExpression = this.getIndexExpression()) != null) {
                PyClass cls;
                PyType type = context.getType(this.getOperand());
                PyClass pyClass = cls = type instanceof PyClassType ? ((PyClassType)type).getPyClass() : null;
                if (cls != null && PyABCUtil.isSubclass(cls, "Mapping")) {
                    return res;
                }
                if (type instanceof PySubscriptableType) {
                    res = ((PySubscriptableType)type).getElementType(indexExpression, context);
                } else if (type instanceof PyCollectionType) {
                    res = ((PyCollectionType)type).getElementType(context);
                }
            }
            members.add(res);
        }
        return PyUnionType.union(members);
    }

    @Override
    public PsiReference getReference() {
        return this.getReference(PyResolveContext.noImplicits());
    }

    @Override
    @NotNull
    public PsiPolyVariantReference getReference(PyResolveContext context) {
        PyOperatorReference pyOperatorReference = new PyOperatorReference(this, context);
        if (pyOperatorReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PySubscriptionExpressionImpl", "getReference"));
        }
        return pyOperatorReference;
    }

    @Override
    public PyExpression getQualifier() {
        return this.getOperand();
    }

    @Override
    @Nullable
    public QualifiedName asQualifiedName() {
        return PyPsiUtils.asQualifiedName(this);
    }

    @Override
    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    public String getReferencedName() {
        String res = "__getitem__";
        switch (AccessDirection.of(this)) {
            case READ: {
                res = "__getitem__";
                break;
            }
            case WRITE: {
                res = "__setitem__";
                break;
            }
            case DELETE: {
                res = "__delitem__";
            }
        }
        return res;
    }

    @Override
    public ASTNode getNameElement() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.LBRACKET);
    }
}

