/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import org.jetbrains.annotations.NotNull;

public class PyStringLiteralExpressionManipulator
extends AbstractElementManipulator<PyStringLiteralExpressionImpl> {
    public PyStringLiteralExpressionImpl handleContentChange(@NotNull PyStringLiteralExpressionImpl element, @NotNull TextRange range, String newContent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionManipulator", "handleContentChange"));
        }
        Pair<String, String> quotes = PythonStringUtil.getQuotes(range.substring(element.getText()));
        if (quotes != null) {
            range = TextRange.create((int)(range.getStartOffset() + ((String)quotes.first).length()), (int)(range.getEndOffset() - ((String)quotes.second).length()));
        }
        String newName = range.replace(element.getText(), newContent);
        return (PyStringLiteralExpressionImpl)element.replace(PyElementGenerator.getInstance(element.getProject()).createStringLiteralAlreadyEscaped(newName));
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull PyStringLiteralExpressionImpl element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionManipulator", "getRangeInElement"));
        }
        Pair<String, String> pair = PythonStringUtil.getQuotes(element.getText());
        if (pair != null) {
            TextRange textRange = TextRange.from((int)((String)pair.first).length(), (int)(element.getTextLength() - ((String)pair.first).length() - ((String)pair.second).length()));
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        TextRange textRange = super.getRangeInElement((PsiElement)element);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionManipulator", "getRangeInElement"));
        }
        return textRange;
    }
}

