/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.regexp.PythonVerboseRegexpLanguage;
import com.jetbrains.python.lexer.PyStringLiteralLexer;
import com.jetbrains.python.lexer.PythonHighlightingLexer;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringLiteralExpressionImpl
extends PyElementImpl
implements PyStringLiteralExpression,
RegExpLanguageHost {
    public static final Pattern PATTERN_ESCAPE = Pattern.compile("\\\\(\n|\\\\|'|\"|a|b|f|n|r|t|v|([0-7]{1,3})|x([0-9a-fA-F]{1,2})|N(\\{.*?\\})|u([0-9a-fA-F]{4})|U([0-9a-fA-F]{8}))");
    private static final Map<String, String> escapeMap = PyStringLiteralExpressionImpl.initializeEscapeMap();
    private String stringValue;
    private List<TextRange> valueTextRanges;
    @Nullable
    private List<Pair<TextRange, String>> myDecodedFragments;
    private final DefaultRegExpPropertiesProvider myPropertiesProvider = DefaultRegExpPropertiesProvider.getInstance();

    private static Map<String, String> initializeEscapeMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("\n", "\n");
        map.put("\\", "\\");
        map.put("'", "'");
        map.put("\"", "\"");
        map.put("a", "\u0001");
        map.put("b", "\b");
        map.put("f", "\f");
        map.put("n", "\n");
        map.put("r", "\r");
        map.put("t", "\t");
        map.put("v", "\u000b");
        return map;
    }

    public PyStringLiteralExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyStringLiteralExpression(this);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.stringValue = null;
        this.valueTextRanges = null;
        this.myDecodedFragments = null;
    }

    @Override
    public List<TextRange> getStringValueTextRanges() {
        if (this.valueTextRanges == null) {
            int elStart = this.getTextRange().getStartOffset();
            ArrayList<TextRange> ranges = new ArrayList<TextRange>();
            for (ASTNode node : this.getStringNodes()) {
                TextRange range = PyStringLiteralExpressionImpl.getNodeTextRange(node.getText());
                int nodeOffset = node.getStartOffset() - elStart;
                ranges.add(TextRange.from((int)(nodeOffset + range.getStartOffset()), (int)range.getLength()));
            }
            this.valueTextRanges = Collections.unmodifiableList(ranges);
        }
        return this.valueTextRanges;
    }

    public static TextRange getNodeTextRange(String text) {
        int startOffset = PyStringLiteralExpressionImpl.getPrefixLength(text);
        int delimiterLength = 1;
        String afterPrefix = text.substring(startOffset);
        if (afterPrefix.startsWith("\"\"\"") || afterPrefix.startsWith("'''")) {
            delimiterLength = 3;
        }
        String delimiter = text.substring(startOffset, startOffset + delimiterLength);
        int endOffset = text.length();
        if (text.substring(startOffset += delimiterLength).endsWith(delimiter)) {
            endOffset -= delimiterLength;
        }
        return new TextRange(startOffset, endOffset);
    }

    public static int getPrefixLength(String text) {
        int startOffset = 0;
        startOffset = PyStringLiteralLexer.skipEncodingPrefix(text, startOffset);
        startOffset = PyStringLiteralLexer.skipRawPrefix(text, startOffset);
        startOffset = PyStringLiteralLexer.skipEncodingPrefix(text, startOffset);
        startOffset = PyStringLiteralLexer.skipRawPrefix(text, startOffset);
        return startOffset;
    }

    private static boolean isRaw(String text) {
        int startOffset = PyStringLiteralLexer.skipEncodingPrefix(text, 0);
        return PyStringLiteralLexer.skipRawPrefix(text, startOffset) > startOffset;
    }

    private static boolean isUnicode(String text) {
        return text.length() > 0 && Character.toUpperCase(text.charAt(0)) == 'U';
    }

    private boolean isUnicodeByDefault() {
        if (LanguageLevel.forElement(this).isAtLeast(LanguageLevel.PYTHON30)) {
            return true;
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof PyFile) {
            PyFile pyFile = (PyFile)file;
            return pyFile.hasImportFromFuture(FutureFeature.UNICODE_LITERALS);
        }
        return false;
    }

    private static boolean isBytes(String text) {
        return text.length() > 0 && Character.toUpperCase(text.charAt(0)) == 'B';
    }

    private static boolean isChar(String text) {
        return text.length() > 0 && Character.toUpperCase(text.charAt(0)) == 'C';
    }

    @Override
    @NotNull
    public List<Pair<TextRange, String>> getDecodedFragments() {
        if (this.myDecodedFragments == null) {
            ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
            int elementStart = this.getTextRange().getStartOffset();
            boolean unicodeByDefault = this.isUnicodeByDefault();
            for (ASTNode node : this.getStringNodes()) {
                String text = node.getText();
                TextRange textRange = PyStringLiteralExpressionImpl.getNodeTextRange(text);
                int offset = node.getTextRange().getStartOffset() - elementStart + textRange.getStartOffset();
                String encoded = textRange.substring(text);
                result.addAll(PyStringLiteralExpressionImpl.getDecodedFragments(encoded, offset, PyStringLiteralExpressionImpl.isRaw(text), unicodeByDefault || PyStringLiteralExpressionImpl.isUnicode(text)));
            }
            this.myDecodedFragments = result;
        }
        List<Pair<TextRange, String>> list = this.myDecodedFragments;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl", "getDecodedFragments"));
        }
        return list;
    }

    @NotNull
    private static List<Pair<TextRange, String>> getDecodedFragments(@NotNull String encoded, int offset, boolean raw, boolean unicode) {
        TextRange range;
        if (encoded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoded", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl", "getDecodedFragments"));
        }
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        Matcher escMatcher = PATTERN_ESCAPE.matcher(encoded);
        int index = 0;
        while (escMatcher.find(index)) {
            String str;
            boolean escapedUnicode;
            if (index < escMatcher.start()) {
                range = TextRange.create((int)index, (int)escMatcher.start());
                TextRange offsetRange = range.shiftRight(offset);
                result.add(Pair.create((Object)offsetRange, (Object)range.substring(encoded)));
            }
            String octal = PyStringLiteralExpressionImpl.escapeRegexGroup(escMatcher, EscapeRegexGroup.OCTAL);
            String hex = PyStringLiteralExpressionImpl.escapeRegexGroup(escMatcher, EscapeRegexGroup.HEXADECIMAL);
            String unicode16 = PyStringLiteralExpressionImpl.escapeRegexGroup(escMatcher, EscapeRegexGroup.UNICODE_16BIT);
            String unicode32 = PyStringLiteralExpressionImpl.escapeRegexGroup(escMatcher, EscapeRegexGroup.UNICODE_32BIT);
            String wholeMatch = PyStringLiteralExpressionImpl.escapeRegexGroup(escMatcher, EscapeRegexGroup.WHOLE_MATCH);
            boolean bl = escapedUnicode = raw && unicode || !raw;
            if (!raw && octal != null) {
                str = new String(new char[]{(char)Integer.parseInt(octal, 8)});
            } else if (!raw && hex != null) {
                str = new String(new char[]{(char)Integer.parseInt(hex, 16)});
            } else if (escapedUnicode && unicode16 != null) {
                str = unicode ? new String(new char[]{(char)Integer.parseInt(unicode16, 16)}) : wholeMatch;
            } else if (escapedUnicode && unicode32 != null) {
                String s = wholeMatch;
                if (unicode) {
                    try {
                        s = new String(Character.toChars((int)Long.parseLong(unicode32, 16)));
                    }
                    catch (IllegalArgumentException ignored) {
                        // empty catch block
                    }
                }
                str = s;
            } else if (raw) {
                str = wholeMatch;
            } else {
                String toReplace = PyStringLiteralExpressionImpl.escapeRegexGroup(escMatcher, EscapeRegexGroup.ESCAPED_SUBSTRING);
                str = escapeMap.get(toReplace);
            }
            if (str != null) {
                TextRange wholeMatchRange = TextRange.create((int)escMatcher.start(), (int)escMatcher.end());
                result.add((Pair<TextRange, String>)Pair.create((Object)wholeMatchRange.shiftRight(offset), (Object)str));
            }
            index = escMatcher.end();
        }
        range = TextRange.create((int)index, (int)encoded.length());
        TextRange offRange = range.shiftRight(offset);
        result.add(Pair.create((Object)offRange, (Object)range.substring(encoded)));
        ArrayList<Pair<TextRange, String>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl", "getDecodedFragments"));
        }
        return arrayList;
    }

    @Nullable
    private static String escapeRegexGroup(@NotNull Matcher matcher, EscapeRegexGroup group) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl", "escapeRegexGroup"));
        }
        return matcher.group(group.ordinal());
    }

    @Override
    public List<ASTNode> getStringNodes() {
        return Arrays.asList(this.getNode().getChildren(PyTokenTypes.STRING_NODES));
    }

    @Override
    public String getStringValue() {
        if (this.stringValue == null) {
            StringBuilder out = new StringBuilder();
            for (Pair<TextRange, String> fragment : this.getDecodedFragments()) {
                out.append((String)fragment.getSecond());
            }
            this.stringValue = out.toString();
        }
        return this.stringValue;
    }

    @Override
    public TextRange getStringValueTextRange() {
        List<TextRange> allRanges = this.getStringValueTextRanges();
        if (allRanges.size() == 1) {
            return allRanges.get(0);
        }
        if (allRanges.size() > 1) {
            return new TextRange(allRanges.get(0).getStartOffset(), allRanges.get(allRanges.size() - 1).getEndOffset());
        }
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getStringValue();
    }

    public boolean isValidHost() {
        return true;
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl", "getType"));
        }
        List<ASTNode> nodes = this.getStringNodes();
        if (nodes.size() > 0) {
            IElementType type;
            String text = this.getStringNodes().get(0).getText();
            PyFile file = (PyFile)PsiTreeUtil.getParentOfType((PsiElement)this, PyFile.class);
            if (file != null && PyTokenTypes.UNICODE_NODES.contains(type = PythonHighlightingLexer.convertStringType(this.getStringNodes().get(0).getElementType(), text, LanguageLevel.forElement(this), file.hasImportFromFuture(FutureFeature.UNICODE_LITERALS)))) {
                return PyBuiltinCache.getInstance(this).getUnicodeType(LanguageLevel.forElement(this));
            }
        }
        return PyBuiltinCache.getInstance(this).getBytesType(LanguageLevel.forElement(this));
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return PyStringLiteralExpressionImpl.this.getStringValue();
            }

            @Nullable
            public String getLocationString() {
                return "(" + PyElementPresentation.getPackageForFile(PyStringLiteralExpressionImpl.this.getContainingFile()) + ")";
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return AllIcons.Nodes.Variable;
            }
        };
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl", "updateText"));
        }
        ASTNode valueNode = this.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        StringLiteralTextEscaper stringLiteralTextEscaper = new StringLiteralTextEscaper(this);
        if (stringLiteralTextEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl", "createLiteralTextEscaper"));
        }
        return stringLiteralTextEscaper;
    }

    @Override
    public int valueOffsetToTextOffset(int valueOffset) {
        return this.createLiteralTextEscaper().getOffsetInHost(valueOffset, this.getStringValueTextRange());
    }

    @Override
    public boolean characterNeedsEscaping(char c) {
        if (c == '#') {
            return this.isVerboseInjection();
        }
        return c == ']' || c == '}' || c == '\"' || c == '\'';
    }

    private boolean isVerboseInjection() {
        List files = InjectedLanguageManager.getInstance((Project)this.getProject()).getInjectedPsiFiles((PsiElement)this);
        if (files != null) {
            for (Pair file : files) {
                Language language = ((PsiElement)file.getFirst()).getLanguage();
                if (language != PythonVerboseRegexpLanguage.INSTANCE) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsPerl5EmbeddedComments() {
        return true;
    }

    @Override
    public boolean supportsPossessiveQuantifiers() {
        return false;
    }

    @Override
    public boolean supportsPythonConditionalRefs() {
        return true;
    }

    @Override
    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        return group.isPythonNamedGroup();
    }

    @Override
    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl", "isValidCategory"));
        }
        return this.myPropertiesProvider.isValidCategory(category);
    }

    @Override
    @NotNull
    public String[][] getAllKnownProperties() {
        String[][] stringArray = this.myPropertiesProvider.getAllKnownProperties();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl", "getAllKnownProperties"));
        }
        return stringArray;
    }

    @Override
    @Nullable
    public String getPropertyDescription(@Nullable String name) {
        return this.myPropertiesProvider.getPropertyDescription(name);
    }

    @Override
    @NotNull
    public String[][] getKnownCharacterClasses() {
        String[][] stringArray = this.myPropertiesProvider.getKnownCharacterClasses();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl", "getKnownCharacterClasses"));
        }
        return stringArray;
    }

    private static class StringLiteralTextEscaper
    extends LiteralTextEscaper<PyStringLiteralExpression> {
        private final PyStringLiteralExpressionImpl myHost;

        protected StringLiteralTextEscaper(@NotNull PyStringLiteralExpressionImpl host) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl$StringLiteralTextEscaper", "<init>"));
            }
            super((PsiLanguageInjectionHost)host);
            this.myHost = host;
        }

        public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
            if (rangeInsideHost == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl$StringLiteralTextEscaper", "decode"));
            }
            if (outChars == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outChars", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl$StringLiteralTextEscaper", "decode"));
            }
            for (Pair<TextRange, String> fragment : this.myHost.getDecodedFragments()) {
                String intersectedValue;
                TextRange encodedTextRange = (TextRange)fragment.getFirst();
                TextRange intersection = encodedTextRange.intersection(rangeInsideHost);
                if (intersection == null || intersection.isEmpty()) continue;
                String value = (String)fragment.getSecond();
                if (value.length() == 1 || value.length() == intersection.getLength()) {
                    intersectedValue = value;
                } else {
                    int start = Math.max(0, rangeInsideHost.getStartOffset() - encodedTextRange.getStartOffset());
                    int end = Math.min(value.length(), start + intersection.getLength());
                    intersectedValue = value.substring(start, end);
                }
                outChars.append(intersectedValue);
            }
            return true;
        }

        public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
            if (rangeInsideHost == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/jetbrains/python/psi/impl/PyStringLiteralExpressionImpl$StringLiteralTextEscaper", "getOffsetInHost"));
            }
            int offset = 0;
            int endOffset = -1;
            for (Pair<TextRange, String> fragment : this.myHost.getDecodedFragments()) {
                TextRange encodedTextRange = (TextRange)fragment.getFirst();
                TextRange intersection = encodedTextRange.intersection(rangeInsideHost);
                if (intersection == null || intersection.isEmpty()) continue;
                String value = (String)fragment.getSecond();
                int valueLength = value.length();
                int intersectionLength = intersection.getLength();
                if (valueLength == 0) {
                    return -1;
                }
                if (valueLength == 1) {
                    if (offset == offsetInDecoded) {
                        return intersection.getStartOffset();
                    }
                    ++offset;
                } else {
                    if (offset + intersectionLength >= offsetInDecoded) {
                        int delta = offsetInDecoded - offset;
                        return intersection.getStartOffset() + delta;
                    }
                    offset += intersectionLength;
                }
                endOffset = intersection.getEndOffset();
            }
            if (offset == offsetInDecoded) {
                return endOffset;
            }
            return -1;
        }

        public boolean isOneLine() {
            return false;
        }
    }

    private static enum EscapeRegexGroup {
        WHOLE_MATCH,
        ESCAPED_SUBSTRING,
        OCTAL,
        HEXADECIMAL,
        UNICODE_NAMED,
        UNICODE_16BIT,
        UNICODE_32BIT;

    }
}

