/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.HashSet;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.toolbox.ChainIterable;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStarImportElementImpl
extends PyElementImpl
implements PyStarImportElement {
    public PyStarImportElementImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        if (this.getParent() instanceof PyFromImportStatement) {
            PyFromImportStatement fromImportStatement = (PyFromImportStatement)this.getParent();
            List<PsiElement> importedFiles = fromImportStatement.resolveImportSourceCandidates();
            ChainIterable<PyElement> chain = new ChainIterable<PyElement>();
            for (PsiElement importedFile : new HashSet(importedFiles)) {
                PsiElement source = PyUtil.turnDirIntoInit(importedFile);
                if (!(source instanceof PyFile)) continue;
                PyFile sourceFile = (PyFile)source;
                chain.add(PyStarImportElementImpl.filterStarImportableNames(sourceFile.iterateNames(), sourceFile));
            }
            ChainIterable<PyElement> chainIterable = chain;
            if (chainIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyStarImportElementImpl", "iterateNames"));
            }
            return chainIterable;
        }
        List<PyElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyStarImportElementImpl", "iterateNames"));
        }
        return list;
    }

    @NotNull
    private static Iterable<PyElement> filterStarImportableNames(@NotNull Iterable<PyElement> declaredNames, final @NotNull PyFile file) {
        if (declaredNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaredNames", "com/jetbrains/python/psi/impl/PyStarImportElementImpl", "filterStarImportableNames"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/impl/PyStarImportElementImpl", "filterStarImportableNames"));
        }
        Iterable iterable = Iterables.filter(declaredNames, (Predicate)new Predicate<PyElement>(){

            public boolean apply(@Nullable PyElement input) {
                String name = input != null ? input.getName() : null;
                return name != null && PyUtil.isStarImportableFrom(name, file);
            }
        });
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyStarImportElementImpl", "filterStarImportableNames"));
        }
        return iterable;
    }

    @Override
    @Nullable
    public PsiElement getElementNamed(String name) {
        if (PyUtil.isClassPrivateName(name)) {
            return null;
        }
        if (this.getParent() instanceof PyFromImportStatement) {
            PyFromImportStatement fromImportStatement = (PyFromImportStatement)this.getParent();
            List<PsiElement> importedFiles = fromImportStatement.resolveImportSourceCandidates();
            for (PsiElement importedFile : new HashSet(importedFiles)) {
                PyFile sourceFile;
                PyModuleType moduleType;
                List<? extends RatedResolveResult> results;
                PsiElement result;
                PsiElement source = PyUtil.turnDirIntoInit(importedFile);
                if (!(source instanceof PyFile) || (result = (results = (moduleType = new PyModuleType(sourceFile = (PyFile)source)).resolveMember(name, null, AccessDirection.READ, PyResolveContext.defaultContext())) != null && !results.isEmpty() ? results.get(0).getElement() : null) == null || !PyUtil.isStarImportableFrom(name, sourceFile)) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public boolean mustResolveOutside() {
        return true;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            private String getName() {
                PyReferenceExpression imp_src;
                PyFromImportStatement elt = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)PyStarImportElementImpl.this, PyFromImportStatement.class);
                if (elt != null && (imp_src = elt.getImportSource()) != null) {
                    return PyPsiUtils.toPath(imp_src);
                }
                return "<?>";
            }

            public String getPresentableText() {
                return this.getName();
            }

            public String getLocationString() {
                return "| from " + this.getName() + " import *";
            }

            public Icon getIcon(boolean open) {
                return null;
            }
        };
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyStarImportElement(this);
    }
}

