/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.completion.PydevConsoleReference;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyTargetExpressionImpl;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.impl.TypeEvalStack;
import com.jetbrains.python.psi.impl.references.PyImportReference;
import com.jetbrains.python.psi.impl.references.PyQualifiedReference;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.ImplicitResolveResult;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyImportedModuleType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyDefUseUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyReferenceExpressionImpl
extends PyElementImpl
implements PyReferenceExpression {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.psi.impl.PyReferenceExpressionImpl");
    private QualifiedName myQualifiedName = null;
    private final QualifiedResolveResult EMPTY_RESULT = new QualifiedResolveResultEmpty();

    public PyReferenceExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    @NotNull
    public PsiPolyVariantReference getReference() {
        PsiPolyVariantReference psiPolyVariantReference = this.getReference(PyResolveContext.defaultContext());
        if (psiPolyVariantReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getReference"));
        }
        return psiPolyVariantReference;
    }

    @Override
    @NotNull
    public PsiPolyVariantReference getReference(PyResolveContext context) {
        PsiFile file = this.getContainingFile();
        PyExpression qualifier = this.getQualifier();
        PsiElement importParent = PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{PyImportElement.class, PyFromImportStatement.class});
        if (importParent != null) {
            PyImportReference pyImportReference = PyImportReference.forElement(this, importParent, context);
            if (pyImportReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getReference"));
            }
            return pyImportReference;
        }
        ConsoleCommunication communication = (ConsoleCommunication)file.getCopyableUserData(PydevConsoleRunner.CONSOLE_KEY);
        if (communication != null) {
            if (qualifier != null) {
                PydevConsoleReference pydevConsoleReference = new PydevConsoleReference(this, communication, qualifier.getText() + ".");
                if (pydevConsoleReference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getReference"));
                }
                return pydevConsoleReference;
            }
            PydevConsoleReference pydevConsoleReference = new PydevConsoleReference(this, communication, "");
            if (pydevConsoleReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getReference"));
            }
            return pydevConsoleReference;
        }
        if (qualifier != null) {
            PyQualifiedReference pyQualifiedReference = new PyQualifiedReference(this, context);
            if (pyQualifiedReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getReference"));
            }
            return pyQualifiedReference;
        }
        PyReferenceImpl pyReferenceImpl = new PyReferenceImpl(this, context);
        if (pyReferenceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getReference"));
        }
        return pyReferenceImpl;
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyReferenceExpression(this);
    }

    @Override
    @Nullable
    public PyExpression getQualifier() {
        ASTNode[] nodes = this.getNode().getChildren(PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens());
        return (PyExpression)(nodes.length == 1 ? nodes[0].getPsi() : null);
    }

    @Override
    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    @Nullable
    public String getReferencedName() {
        ASTNode nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getText() : null;
    }

    @Override
    @Nullable
    public ASTNode getNameElement() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
    }

    @Override
    @Nullable
    public String getName() {
        return this.getReferencedName();
    }

    @Override
    @NotNull
    public QualifiedResolveResult followAssignmentsChain(PyResolveContext resolveContext) {
        PyReferenceExpression seeker = this;
        QualifiedResolveResult ret = null;
        ArrayList<PyExpression> qualifiers = new ArrayList<PyExpression>();
        PyExpression qualifier = seeker.getQualifier();
        if (qualifier != null) {
            qualifiers.add(qualifier);
        }
        HashSet<PyExpression> visited = new HashSet<PyExpression>();
        visited.add(this);
        block0: while (ret == null) {
            ResolveResult[] targets;
            for (ResolveResult target : targets = seeker.getReference(resolveContext).multiResolve(false)) {
                PsiElement elt = target.getElement();
                if (elt instanceof PyTargetExpression) {
                    PyExpression assigned_from = null;
                    PyTargetExpression expr = (PyTargetExpression)elt;
                    TypeEvalContext context = resolveContext.getTypeEvalContext();
                    if (context.maySwitchToAST((PsiElement)expr) || expr.getStub() == null) {
                        assigned_from = expr.findAssignedValue();
                    } else if (elt instanceof PyTargetExpressionImpl) {
                        assigned_from = ((PyTargetExpressionImpl)elt).findAssignedValueByStub(context);
                    }
                    if (assigned_from instanceof PyReferenceExpression) {
                        if (visited.contains(assigned_from)) break block0;
                        visited.add(assigned_from);
                        seeker = (PyReferenceExpression)assigned_from;
                        if (seeker.getQualifier() == null) continue block0;
                        qualifiers.add(seeker.getQualifier());
                        continue block0;
                    }
                    if (assigned_from == null) continue;
                    ret = new QualifiedResolveResultImpl((PsiElement)assigned_from, qualifiers, false);
                    continue;
                }
                if (ret != null || !(elt instanceof PyElement) || !target.isValidResult()) continue;
                ret = new QualifiedResolveResultImpl(elt, qualifiers, target instanceof ImplicitResolveResult);
            }
        }
        if (ret == null) {
            ret = this.EMPTY_RESULT;
        }
        QualifiedResolveResult qualifiedResolveResult = ret;
        if (qualifiedResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "followAssignmentsChain"));
        }
        return qualifiedResolveResult;
    }

    @Override
    @Nullable
    public QualifiedName asQualifiedName() {
        if (this.myQualifiedName == null) {
            this.myQualifiedName = PyPsiUtils.asQualifiedName(this);
        }
        return this.myQualifiedName;
    }

    @Override
    public String toString() {
        return "PyReferenceExpression: " + this.getReferencedName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getType"));
        }
        if (!TypeEvalStack.mayEvaluate((PsiElement)this)) {
            return null;
        }
        try {
            PsiPolyVariantReference reference;
            List<PsiElement> targets;
            String name;
            boolean qualified = this.isQualified();
            if (!qualified && "None".equals(name = this.getReferencedName())) {
                PyNoneType pyNoneType = PyNoneType.INSTANCE;
                return pyNoneType;
            }
            PyType type = this.getTypeFromProviders(context);
            if (type != null) {
                PyType pyType = type;
                return pyType;
            }
            if (qualified) {
                PyType maybe_type = PyUtil.getSpecialAttributeType(this, context);
                if (maybe_type != null) {
                    PyType pyType = maybe_type;
                    return pyType;
                }
                Ref<PyType> typeOfProperty = this.getTypeOfProperty(context);
                if (typeOfProperty != null) {
                    PyType pyType = (PyType)typeOfProperty.get();
                    return pyType;
                }
            }
            if ((targets = PyUtil.multiResolveTopPriority(reference = this.getReference(PyResolveContext.noImplicits().withTypeEvalContext(context)))).isEmpty()) {
                PyType pyType = this.getQualifiedReferenceTypeByControlFlow(context);
                return pyType;
            }
            ArrayList<PyType> members = new ArrayList<PyType>();
            for (PsiElement target : targets) {
                if (target == this || target == null) continue;
                if (!target.isValid()) {
                    LOG.error("Reference " + this + " resolved to invalid element " + target + " (text=" + target.getText() + ")");
                    continue;
                }
                members.add(PyReferenceExpressionImpl.getTypeFromTarget(target, context, this));
            }
            PyType pyType = PyUnionType.union(members);
            return pyType;
        }
        finally {
            TypeEvalStack.evaluated((PsiElement)this);
        }
    }

    @Nullable
    public PyType getQualifiedReferenceTypeByControlFlow(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getQualifiedReferenceTypeByControlFlow"));
        }
        PyExpression qualifier = this.getQualifier();
        if (context.allowDataFlow((PsiElement)this) && qualifier != null) {
            PyExpression next = qualifier;
            while (next != null) {
                qualifier = next;
                next = qualifier instanceof PyQualifiedExpression ? ((PyQualifiedExpression)qualifier).getQualifier() : null;
            }
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)this);
            QualifiedName qname = this.asQualifiedName();
            if (qname != null && scopeOwner != null) {
                return PyReferenceExpressionImpl.getTypeByControlFlow(qname.toString(), context, qualifier, scopeOwner);
            }
        }
        return null;
    }

    @Nullable
    public Ref<PyType> getTypeOfProperty(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getTypeOfProperty"));
        }
        PyExpression qualifier = this.getQualifier();
        String name = this.getName();
        if (name != null && qualifier != null) {
            PyType qualifierType = context.getType(qualifier);
            return this.getTypeOfProperty(qualifierType, name, context);
        }
        return null;
    }

    @Nullable
    private Ref<PyType> getTypeOfProperty(@Nullable PyType qualifierType, @NotNull String name, @NotNull TypeEvalContext context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getTypeOfProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getTypeOfProperty"));
        }
        if (qualifierType instanceof PyClassType) {
            PyClassType classType = (PyClassType)qualifierType;
            PyClass pyClass = classType.getPyClass();
            Property property = pyClass.findProperty(name, true);
            if (property != null) {
                PyType type;
                if (classType.isDefinition()) {
                    return Ref.create((Object)PyBuiltinCache.getInstance(pyClass).getObjectType("property"));
                }
                if (AccessDirection.of(this) == AccessDirection.READ && (type = property.getType(context)) != null) {
                    return Ref.create((Object)type);
                }
                return Ref.create();
            }
        } else if (qualifierType instanceof PyUnionType) {
            PyUnionType unionType = (PyUnionType)qualifierType;
            for (PyType type : unionType.getMembers()) {
                Ref<PyType> result = this.getTypeOfProperty(type, name, context);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Nullable
    private PyType getTypeFromProviders(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getTypeFromProviders"));
        }
        for (PyTypeProvider provider : (PyTypeProvider[])Extensions.getExtensions(PyTypeProvider.EP_NAME)) {
            try {
                PyType type = provider.getReferenceExpressionType(this, context);
                if (type == null) continue;
                return type;
            }
            catch (AbstractMethodError e) {
                LOG.info((Throwable)new ExtensionException(provider.getClass()));
            }
        }
        return null;
    }

    @Nullable
    public static PyType getTypeFromTarget(@NotNull PsiElement target, TypeEvalContext context, PyReferenceExpression anchor) {
        PyDecoratorList decoratorList;
        PyType type;
        String name;
        ScopeOwner scopeOwner;
        PyType pyType;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getTypeFromTarget"));
        }
        if (!(target instanceof PyTargetExpression) && (pyType = PyReferenceExpressionImpl.getReferenceTypeFromProviders(target, context, (PsiElement)anchor)) != null) {
            return pyType;
        }
        if (target instanceof PyTargetExpression) {
            String name2 = ((PyTargetExpression)target).getName();
            if ("None".equals(name2)) {
                return PyNoneType.INSTANCE;
            }
            if ("True".equals(name2) || "False".equals(name2)) {
                return PyBuiltinCache.getInstance(target).getBoolType();
            }
        }
        if (target instanceof PyFile) {
            return new PyModuleType((PyFile)target);
        }
        if (target instanceof PyImportedModule) {
            return new PyImportedModuleType((PyImportedModule)target);
        }
        if ((target instanceof PyTargetExpression || target instanceof PyNamedParameter) && anchor != null && context.allowDataFlow((PsiElement)anchor) && (scopeOwner = (ScopeOwner)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)anchor, ScopeOwner.class)) != null && scopeOwner == PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)target, ScopeOwner.class) && (name = ((PyElement)target).getName()) != null && (type = PyReferenceExpressionImpl.getTypeByControlFlow(name, context, anchor, scopeOwner)) != null) {
            return type;
        }
        if (target instanceof PyFunction && (decoratorList = ((PyFunction)target).getDecoratorList()) != null) {
            PyDecorator propertyDecorator = decoratorList.findDecorator("property");
            if (propertyDecorator != null) {
                return PyBuiltinCache.getInstance(target).getObjectType("property");
            }
            for (PyDecorator decorator : decoratorList.getDecorators()) {
                QualifiedName qName = decorator.getQualifiedName();
                if (qName == null || !qName.endsWith("setter") && !qName.endsWith("deleter") && !qName.endsWith("getter")) continue;
                return PyBuiltinCache.getInstance(target).getObjectType("property");
            }
        }
        if (target instanceof PyTypedElement) {
            return context.getType((PyTypedElement)target);
        }
        if (target instanceof PsiDirectory) {
            QualifiedName qualifiedName;
            PsiFile containingFile;
            PsiDirectory dir = (PsiDirectory)target;
            PsiFile file = dir.findFile("__init__.py");
            if (file != null) {
                return PyReferenceExpressionImpl.getTypeFromTarget((PsiElement)file, context, anchor);
            }
            if (PyUtil.isPackage(dir, (PsiElement)anchor) && (containingFile = anchor.getContainingFile()) instanceof PyFile && (qualifiedName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)dir)) != null) {
                PyImportedModule module = new PyImportedModule(null, (PyFile)containingFile, qualifiedName);
                return new PyImportedModuleType(module);
            }
        }
        return null;
    }

    private static PyType getTypeByControlFlow(@NotNull String name, @NotNull TypeEvalContext context, @NotNull PyExpression anchor, @NotNull ScopeOwner scopeOwner) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getTypeByControlFlow"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getTypeByControlFlow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getTypeByControlFlow"));
        }
        if (scopeOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeOwner", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getTypeByControlFlow"));
        }
        PyAugAssignmentStatement augAssignment = (PyAugAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyAugAssignmentStatement.class);
        try {
            PyElement element = augAssignment != null ? augAssignment : anchor;
            List<ReadWriteInstruction> defs = PyDefUseUtil.getLatestDefs(scopeOwner, name, (PsiElement)element, true);
            if (!defs.isEmpty()) {
                PyType type = defs.get(0).getType(context, (PsiElement)anchor);
                for (int i = 1; i < defs.size(); ++i) {
                    type = PyUnionType.union(type, defs.get(i).getType(context, (PsiElement)anchor));
                }
                return type;
            }
        }
        catch (PyDefUseUtil.InstructionNotFoundException ignored) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static PyType getReferenceTypeFromProviders(@NotNull PsiElement target, TypeEvalContext context, @Nullable PsiElement anchor) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl", "getReferenceTypeFromProviders"));
        }
        for (PyTypeProvider provider : (PyTypeProvider[])Extensions.getExtensions(PyTypeProvider.EP_NAME)) {
            PyType result = provider.getReferenceType(target, context, anchor);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myQualifiedName = null;
    }

    public static class QualifiedResolveResultEmpty
    implements QualifiedResolveResult {
        @Override
        public List<PyExpression> getQualifiers() {
            return Collections.emptyList();
        }

        public PsiElement getElement() {
            return null;
        }

        public boolean isValidResult() {
            return false;
        }

        @Override
        public boolean isImplicit() {
            return false;
        }
    }

    private static class QualifiedResolveResultImpl
    extends RatedResolveResult
    implements QualifiedResolveResult {
        private List<PyExpression> myQualifiers;
        private boolean myIsImplicit;

        @Override
        public boolean isImplicit() {
            return this.myIsImplicit;
        }

        QualifiedResolveResultImpl(@NotNull PsiElement element, List<PyExpression> qualifiers, boolean isImplicit) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/PyReferenceExpressionImpl$QualifiedResolveResultImpl", "<init>"));
            }
            super(isImplicit ? -1000 : 0, element);
            this.myQualifiers = qualifiers;
            this.myIsImplicit = isImplicit;
        }

        @Override
        public List<PyExpression> getQualifiers() {
            return this.myQualifiers;
        }
    }
}

