/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPsiUtils {
    private static final Logger LOG = Logger.getInstance((String)PyPsiUtils.class.getName());

    private PyPsiUtils() {
    }

    @NotNull
    protected static <T extends PyElement> T[] nodesToPsi(ASTNode[] nodes, T[] array) {
        PyElement[] psiElements = (PyElement[])Array.newInstance(array.getClass().getComponentType(), nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = (PyElement)nodes[i].getPsi();
        }
        if (psiElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyPsiUtils", "nodesToPsi"));
        }
        return psiElements;
    }

    @Nullable
    protected static ASTNode getPrevComma(ASTNode after) {
        ASTNode node = after;
        PyElementType comma = PyTokenTypes.COMMA;
        while ((node = node.getTreePrev()) != null && !node.getElementType().equals((Object)comma)) {
        }
        return node;
    }

    @Nullable
    public static ASTNode getNextComma(ASTNode after) {
        ASTNode node = after;
        PyElementType comma = PyTokenTypes.COMMA;
        while ((node = node.getTreeNext()) != null && !node.getElementType().equals((Object)comma)) {
        }
        return node;
    }

    public static void addBeforeInParent(@NotNull PsiElement anchor, PsiElement ... newElements) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/psi/impl/PyPsiUtils", "addBeforeInParent"));
        }
        if (newElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElements", "com/jetbrains/python/psi/impl/PyPsiUtils", "addBeforeInParent"));
        }
        ASTNode anchorNode = anchor.getNode();
        LOG.assertTrue(anchorNode != null);
        for (PsiElement newElement : newElements) {
            anchorNode.getTreeParent().addChild(newElement.getNode(), anchorNode);
        }
    }

    public static void removeElements(PsiElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/psi/impl/PyPsiUtils", "removeElements"));
        }
        ASTNode parentNode = elements[0].getParent().getNode();
        LOG.assertTrue(parentNode != null);
        for (PsiElement element : elements) {
            parentNode.removeChild(element.getNode());
        }
    }

    @Nullable
    public static PsiElement getStatement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/PyPsiUtils", "getStatement"));
        }
        PyElement compStatement = PyPsiUtils.getStatementList(element);
        if (compStatement == null) {
            return null;
        }
        return PyPsiUtils.getStatement((PsiElement)compStatement, element);
    }

    public static PyElement getStatementList(PsiElement element) {
        return element instanceof PyFile || element instanceof PyStatementList ? (PyElement)element : (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyFile.class, PyStatementList.class});
    }

    @Nullable
    public static PsiElement getStatement(PsiElement compStatement, PsiElement element) {
        PsiElement parent = element.getParent();
        while (parent != null && parent != compStatement) {
            element = parent;
            parent = element.getParent();
        }
        return parent != null ? element : null;
    }

    public static List<PsiElement> collectElements(PsiElement statement1, PsiElement statement2) {
        ASTNode node1 = statement1.getNode();
        ASTNode node2 = statement2.getNode();
        ASTNode parentNode = node1.getTreeParent();
        boolean insideRange = false;
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (ASTNode node : parentNode.getChildren(null)) {
            if (node1 == node) {
                insideRange = true;
            }
            if (insideRange) {
                result.add(node.getPsi());
            }
            if (node == node2) break;
        }
        return result;
    }

    public static int getElementIndentation(PsiElement element) {
        PyElement compStatement = PyPsiUtils.getStatementList(element);
        PsiElement statement = PyPsiUtils.getStatement((PsiElement)compStatement, element);
        if (statement == null) {
            return 0;
        }
        PsiElement sibling = statement.getPrevSibling();
        if (sibling == null) {
            sibling = compStatement.getPrevSibling();
        }
        String whitespace = sibling instanceof PsiWhiteSpace ? sibling.getText() : "";
        int i = whitespace.lastIndexOf("\n");
        return i != -1 ? whitespace.length() - i - 1 : 0;
    }

    public static void removeRedundantPass(PyStatementList statementList) {
        PyStatement[] statements = statementList.getStatements();
        if (statements.length > 1) {
            for (PyStatement statement : statements) {
                if (!(statement instanceof PyPassStatement)) continue;
                statement.delete();
            }
        }
    }

    public static boolean isMethodContext(PsiElement element) {
        PsiNamedElement parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyFile.class, PyFunction.class, PyClass.class});
        return parent instanceof PyFunction && PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PyFile.class, PyClass.class}) instanceof PyClass;
    }

    @NotNull
    public static PsiElement getRealContext(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/PyPsiUtils", "getRealContext"));
        }
        if (!element.isValid()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PyPsiUtil.getRealContext(" + element + ") called. Returned null. Element in invalid");
            }
            PsiElement psiElement = element;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyPsiUtils", "getRealContext"));
            }
            return psiElement;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PyExpressionCodeFragment) {
            PsiElement context = file.getContext();
            if (LOG.isDebugEnabled()) {
                LOG.debug("PyPsiUtil.getRealContext(" + element + ") is called. Returned " + context + ". Element inside code fragment");
            }
            PsiElement psiElement = context != null ? context : element;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyPsiUtils", "getRealContext"));
            }
            return psiElement;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("PyPsiUtil.getRealContext(" + element + ") is called. Returned " + element + ".");
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyPsiUtils", "getRealContext"));
        }
        return psiElement;
    }

    static void deleteAdjacentComma(ASTDelegatePsiElement pyImportStatement, ASTNode child, PyElement[] elements) {
        if (ArrayUtil.contains((Object)child.getPsi(), (Object[])elements)) {
            ASTNode next = PyPsiUtils.getNextComma(child);
            if (next == null) {
                next = PyPsiUtils.getPrevComma(child);
            }
            if (next != null) {
                ASTNode prev = next.getTreePrev();
                pyImportStatement.deleteChildInternal(next);
                PyPsiUtils.removeSlash(pyImportStatement, prev);
            }
        }
    }

    private static void removeSlash(ASTDelegatePsiElement statement, ASTNode prev) {
        ArrayList<ASTNode> toDelete = new ArrayList<ASTNode>();
        while (prev instanceof PsiWhiteSpace) {
            toDelete.add(0, prev);
            prev = prev.getTreePrev();
        }
        prev = prev.getTreeNext();
        while (prev instanceof PsiWhiteSpace) {
            toDelete.add(prev);
            prev = prev.getTreeNext();
        }
        if (toDelete.size() > 0) {
            statement.deleteChildRange(((ASTNode)toDelete.get(0)).getPsi(), ((ASTNode)toDelete.get(toDelete.size() - 1)).getPsi());
        }
    }

    @NotNull
    static <T, U extends PsiElement> List<T> collectStubChildren(U e, StubElement<U> stub, final IElementType elementType, Class<T> itemClass) {
        final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        if (stub != null) {
            List children = stub.getChildrenStubs();
            for (StubElement child : children) {
                if (child.getStubType() != elementType) continue;
                result.add(child.getPsi());
            }
        } else {
            e.acceptChildren((PsiElementVisitor)new TopLevelVisitor(){

                @Override
                protected void checkAddElement(PsiElement node) {
                    if (node.getNode().getElementType() == elementType) {
                        result.add(node);
                    }
                }
            });
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyPsiUtils", "collectStubChildren"));
        }
        return arrayList;
    }

    static List<PsiElement> collectAllStubChildren(PsiElement e, StubElement stub) {
        final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        if (stub != null) {
            List children = stub.getChildrenStubs();
            for (StubElement child : children) {
                result.add(child.getPsi());
            }
        } else {
            e.acceptChildren((PsiElementVisitor)new TopLevelVisitor(){

                @Override
                protected void checkAddElement(PsiElement node) {
                    result.add(node);
                }
            });
        }
        return result;
    }

    @Nullable
    public static PsiElement getSignificantToTheRight(PsiElement element, boolean ignoreComments) {
        while (element != null && StringUtil.isEmptyOrSpaces((String)element.getText()) || ignoreComments && element instanceof PsiComment) {
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        return element;
    }

    @Nullable
    public static PsiElement getSignificantToTheLeft(PsiElement element, boolean ignoreComments) {
        while (element != null && StringUtil.isEmptyOrSpaces((String)element.getText()) || ignoreComments && element instanceof PsiComment) {
            element = PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        return element;
    }

    public static int findArgumentIndex(PyCallExpression call, PsiElement argument) {
        PyExpression[] args = call.getArguments();
        for (int i = 0; i < args.length; ++i) {
            PyExpression expression = args[i];
            if (expression instanceof PyKeywordArgument) {
                expression = ((PyKeywordArgument)expression).getValueExpression();
            }
            if ((expression = PyPsiUtils.flattenParens(expression)) != argument) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public static PyTargetExpression getAttribute(@NotNull PyFile file, @NotNull String name) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/impl/PyPsiUtils", "getAttribute"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyPsiUtils", "getAttribute"));
        }
        PyTargetExpression attr = file.findTopLevelAttribute(name);
        if (attr == null) {
            for (PyFromImportStatement element : file.getFromImports()) {
                PsiElement resolved;
                PyReferenceExpression expression = element.getImportSource();
                if (expression == null || !((resolved = expression.getReference().resolve()) instanceof PyFile) || resolved == file) continue;
                return ((PyFile)resolved).findTopLevelAttribute(name);
            }
        }
        return attr;
    }

    public static List<PyExpression> getAttributeValuesFromFile(@NotNull PyFile file, @NotNull String name) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/impl/PyPsiUtils", "getAttributeValuesFromFile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyPsiUtils", "getAttributeValuesFromFile"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        PyTargetExpression attr = file.findTopLevelAttribute(name);
        if (attr != null) {
            PyPsiUtils.sequenceToList(result, attr.findAssignedValue());
        }
        return result;
    }

    public static void sequenceToList(List<PyExpression> result, PyExpression value) {
        if ((value = PyPsiUtils.flattenParens(value)) instanceof PySequenceExpression) {
            result.addAll(ContainerUtil.newArrayList((Object[])((PySequenceExpression)value).getElements()));
        } else {
            result.add(value);
        }
    }

    public static List<String> getStringValues(PyExpression[] elements) {
        ArrayList results = ContainerUtil.newArrayList();
        for (PyExpression element : elements) {
            if (!(element instanceof PyStringLiteralExpression)) continue;
            results.add(((PyStringLiteralExpression)element).getStringValue());
        }
        return results;
    }

    @Nullable
    public static PyExpression flattenParens(@Nullable PyExpression expr) {
        while (expr instanceof PyParenthesizedExpression) {
            expr = ((PyParenthesizedExpression)expr).getContainedExpression();
        }
        return expr;
    }

    @Nullable
    public static String strValue(@Nullable PyExpression expression) {
        return expression instanceof PyStringLiteralExpression ? ((PyStringLiteralExpression)expression).getStringValue() : null;
    }

    public static boolean isBefore(@NotNull PsiElement element, @NotNull PsiElement element2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/impl/PyPsiUtils", "isBefore"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/jetbrains/python/psi/impl/PyPsiUtils", "isBefore"));
        }
        return element.getTextOffset() <= element2.getTextOffset();
    }

    @Nullable
    public static QualifiedName asQualifiedName(@Nullable PyExpression expr) {
        return expr instanceof PyQualifiedExpression ? ((PyQualifiedExpression)expr).asQualifiedName() : null;
    }

    @Nullable
    public static PyExpression getFirstQualifier(@NotNull PyQualifiedExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/python/psi/impl/PyPsiUtils", "getFirstQualifier"));
        }
        List<PyExpression> expressions = PyPsiUtils.unwindQualifiers(expr);
        if (!expressions.isEmpty()) {
            return expressions.get(0);
        }
        return null;
    }

    @NotNull
    public static String toPath(@Nullable PyQualifiedExpression expr) {
        if (expr != null) {
            QualifiedName qName = expr.asQualifiedName();
            if (qName != null) {
                String string = qName.toString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyPsiUtils", "toPath"));
                }
                return string;
            }
            String name = expr.getName();
            if (name != null) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyPsiUtils", "toPath"));
                }
                return string;
            }
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyPsiUtils", "toPath"));
        }
        return "";
    }

    @Nullable
    protected static QualifiedName asQualifiedName(@NotNull PyQualifiedExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/python/psi/impl/PyPsiUtils", "asQualifiedName"));
        }
        return PyPsiUtils.fromReferenceChain(PyPsiUtils.unwindQualifiers(expr));
    }

    @NotNull
    private static List<PyExpression> unwindQualifiers(@NotNull PyQualifiedExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/python/psi/impl/PyPsiUtils", "unwindQualifiers"));
        }
        LinkedList<PyExpression> path = new LinkedList<PyExpression>();
        PyQualifiedExpression e = expr;
        while (e != null) {
            path.add(0, e);
            PyExpression q = e.getQualifier();
            e = q instanceof PyQualifiedExpression ? (PyQualifiedExpression)q : null;
        }
        LinkedList<PyExpression> linkedList = path;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyPsiUtils", "unwindQualifiers"));
        }
        return linkedList;
    }

    @Nullable
    private static QualifiedName fromReferenceChain(@NotNull List<PyExpression> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/jetbrains/python/psi/impl/PyPsiUtils", "fromReferenceChain"));
        }
        ArrayList<String> componentNames = new ArrayList<String>(components.size());
        for (PyExpression component : components) {
            String refName;
            String string = refName = component instanceof PyQualifiedExpression ? ((PyQualifiedExpression)component).getReferencedName() : null;
            if (refName == null) {
                return null;
            }
            componentNames.add(refName);
        }
        return QualifiedName.fromComponents(componentNames);
    }

    private static abstract class TopLevelVisitor
    extends PyRecursiveElementVisitor {
        private TopLevelVisitor() {
        }

        @Override
        public void visitPyElement(PyElement node) {
            super.visitPyElement(node);
            this.checkAddElement((PsiElement)node);
        }

        @Override
        public void visitPyClass(PyClass node) {
            this.checkAddElement(node);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            this.checkAddElement(node);
        }

        protected abstract void checkAddElement(PsiElement var1);
    }
}

