/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.QualifiedNameResolver;
import com.jetbrains.python.psi.resolve.QualifiedNameResolverImpl;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyUnionType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPsiFacadeImpl
extends PyPsiFacade {
    private final Project myProject;

    public PyPsiFacadeImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public QualifiedNameResolver qualifiedNameResolver(String qNameString) {
        return new QualifiedNameResolverImpl(qNameString);
    }

    @Override
    public QualifiedNameResolver qualifiedNameResolver(QualifiedName qualifiedName) {
        return new QualifiedNameResolverImpl(qualifiedName);
    }

    @Override
    @Nullable
    public PyClass findClass(String qName) {
        return PyClassNameIndex.findClass(qName, this.myProject);
    }

    @Override
    @NotNull
    public PyClassType createClassType(@NotNull PyClass pyClass, boolean isDefinition) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/psi/impl/PyPsiFacadeImpl", "createClassType"));
        }
        PyClassTypeImpl pyClassTypeImpl = new PyClassTypeImpl(pyClass, isDefinition);
        if (pyClassTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyPsiFacadeImpl", "createClassType"));
        }
        return pyClassTypeImpl;
    }

    @Override
    @Nullable
    public PyType createUnionType(@NotNull Collection<PyType> members) {
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "com/jetbrains/python/psi/impl/PyPsiFacadeImpl", "createUnionType"));
        }
        return PyUnionType.union(members);
    }

    @Override
    @Nullable
    public PyType createTupleType(@NotNull Collection<PyType> members, @NotNull PsiElement anchor) {
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "members", "com/jetbrains/python/psi/impl/PyPsiFacadeImpl", "createTupleType"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/psi/impl/PyPsiFacadeImpl", "createTupleType"));
        }
        return PyTupleType.create(anchor, members.toArray(new PyType[members.size()]));
    }

    @Override
    @Nullable
    public PyType parseTypeAnnotation(@NotNull String annotation, @NotNull PsiElement anchor) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/jetbrains/python/psi/impl/PyPsiFacadeImpl", "parseTypeAnnotation"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/psi/impl/PyPsiFacadeImpl", "parseTypeAnnotation"));
        }
        return PyTypeParser.getTypeByName(anchor, annotation);
    }

    @Override
    @Nullable
    public String findShortestImportableName(@NotNull VirtualFile targetFile, @NotNull PsiElement anchor) {
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/jetbrains/python/psi/impl/PyPsiFacadeImpl", "findShortestImportableName"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/python/psi/impl/PyPsiFacadeImpl", "findShortestImportableName"));
        }
        return QualifiedNameFinder.findShortestImportableName(anchor, targetFile);
    }
}

