/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.references.PyOperatorReference;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPrefixExpressionImpl
extends PyElementImpl
implements PyPrefixExpression {
    public PyPrefixExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public PyExpression getOperand() {
        return (PyExpression)this.childToPsi(PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens(), 0);
    }

    @Nullable
    public PsiElement getPsiOperator() {
        ASTNode node = this.getNode();
        ASTNode child = node.findChildByType(PyElementTypes.UNARY_OPS);
        return child != null ? child.getPsi() : null;
    }

    @Override
    @NotNull
    public PyElementType getOperator() {
        PsiElement op = this.getPsiOperator();
        assert (op != null);
        PyElementType pyElementType = (PyElementType)op.getNode().getElementType();
        if (pyElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyPrefixExpressionImpl", "getOperator"));
        }
        return pyElementType;
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyPrefixExpression(this);
    }

    @Override
    public PsiReference getReference() {
        return this.getReference(PyResolveContext.noImplicits());
    }

    @Override
    @NotNull
    public PsiPolyVariantReference getReference(PyResolveContext context) {
        PyOperatorReference pyOperatorReference = new PyOperatorReference(this, context);
        if (pyOperatorReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyPrefixExpressionImpl", "getReference"));
        }
        return pyOperatorReference;
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyPrefixExpressionImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyPrefixExpressionImpl", "getType"));
        }
        if (this.getOperator() == PyTokenTypes.NOT_KEYWORD) {
            return PyBuiltinCache.getInstance((PsiElement)this).getBoolType();
        }
        PsiPolyVariantReference ref = this.getReference(PyResolveContext.noImplicits().withTypeEvalContext(context));
        PsiElement resolved = ref.resolve();
        if (resolved instanceof Callable) {
            return ((Callable)resolved).getReturnType(context, key);
        }
        return null;
    }

    @Override
    public PyExpression getQualifier() {
        return this.getOperand();
    }

    @Override
    @Nullable
    public QualifiedName asQualifiedName() {
        return PyPsiUtils.asQualifiedName(this);
    }

    @Override
    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    public String getReferencedName() {
        PyElementType t = this.getOperator();
        if (t == PyTokenTypes.PLUS) {
            return "__pos__";
        }
        if (t == PyTokenTypes.MINUS) {
            return "__neg__";
        }
        return this.getOperator().getSpecialMethodName();
    }

    @Override
    public ASTNode getNameElement() {
        PsiElement op = this.getPsiOperator();
        return op != null ? op.getNode() : null;
    }
}

