/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.stubs.PyParameterListStub;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyParameterListImpl
extends PyBaseElementImpl<PyParameterListStub>
implements PyParameterList {
    public PyParameterListImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyParameterListImpl(PyParameterListStub stub) {
        this(stub, (IStubElementType)PyElementTypes.PARAMETER_LIST);
    }

    public PyParameterListImpl(PyParameterListStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyParameterList(this);
    }

    @Override
    public PyParameter[] getParameters() {
        return (PyParameter[])this.getStubOrPsiChildren(PythonDialectsTokenSetProvider.INSTANCE.getParameterTokens(), (PsiElement[])new PyParameter[0]);
    }

    @Override
    public void addParameter(PyNamedParameter param) {
        PsiElement paren = this.getLastChild();
        if (paren != null && ")".equals(paren.getText())) {
            ASTNode beforeWhat = paren.getNode();
            PyParameter[] params = this.getParameters();
            boolean hasDefaultValue = param.hasDefaultValue();
            boolean isLast = true;
            for (PyParameter p : params) {
                PyNamedParameter named;
                if (!hasDefaultValue && p.hasDefaultValue()) {
                    beforeWhat = p.getNode();
                    isLast = false;
                    break;
                }
                if (!(p instanceof PyNamedParameter) || !(named = (PyNamedParameter)p).isKeywordContainer() && !named.isPositionalContainer()) continue;
                beforeWhat = p.getNode();
                isLast = false;
                break;
            }
            ASTNode previous = PyUtil.getPreviousNonWhitespace(beforeWhat);
            PyUtil.addListNode((PsiElement)this, (PsiElement)param, beforeWhat, !isLast || params.length == 0 || previous.getElementType() == PyTokenTypes.COMMA, isLast, beforeWhat.getElementType() != PyTokenTypes.RPAR);
        }
    }

    @Override
    public boolean hasPositionalContainer() {
        for (PyParameter parameter : this.getParameters()) {
            if (!(parameter instanceof PyNamedParameter) || !((PyNamedParameter)parameter).isPositionalContainer()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasKeywordContainer() {
        for (PyParameter parameter : this.getParameters()) {
            if (!(parameter instanceof PyNamedParameter) || !((PyNamedParameter)parameter).isKeywordContainer()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public PyNamedParameter findParameterByName(final @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyParameterListImpl", "findParameterByName"));
        }
        final Ref result = new Ref();
        ParamHelper.walkDownParamArray(this.getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                if (name.equals(param.getName())) {
                    result.set((Object)param);
                }
            }
        });
        return (PyNamedParameter)result.get();
    }

    @Override
    public String getPresentableText(final boolean includeDefaultValue) {
        final StringBuilder target = new StringBuilder();
        String COMMA = ", ";
        target.append("(");
        ParamHelper.walkDownParamArray(this.getParameters(), new ParamHelper.ParamWalker(){

            @Override
            public void enterTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                target.append("(");
            }

            @Override
            public void leaveTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                target.append(")");
                if (!last) {
                    target.append(", ");
                }
            }

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                target.append(param.getRepr(includeDefaultValue));
                if (!last) {
                    target.append(", ");
                }
            }

            @Override
            public void visitSingleStarParameter(PySingleStarParameter param, boolean first, boolean last) {
                target.append('*');
                if (!last) {
                    target.append(", ");
                }
            }
        });
        target.append(")");
        return target.toString();
    }

    @Override
    @Nullable
    public PyFunction getContainingFunction() {
        PsiElement parent = this.getStubOrPsiParent();
        return parent instanceof PyFunction ? (PyFunction)parent : null;
    }
}

