/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyNumericLiteralExpressionImpl
extends PyElementImpl
implements PyNumericLiteralExpression {
    private static final Pattern PATTERN_INT = Pattern.compile("(?:([1-9]\\d*)|(0)|(0[0-7]+)|(?:0x([0-9a-f]+)))L?", 2);
    private static final Pattern PATTERN_FLOAT = Pattern.compile("((\\d+)(?:\\.(\\d+)?)?|\\.(\\d+))(e(\\+|-)?(\\d))?", 2);

    public PyNumericLiteralExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyNumericLiteralExpression(this);
    }

    @Override
    public Long getLongValue() {
        BigInteger value = this.getBigIntegerValue();
        long longValue = value.longValue();
        if (BigInteger.valueOf(longValue).equals(value)) {
            return longValue;
        }
        return null;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        ASTNode node = this.getNode();
        String text = node.getText();
        IElementType type = node.getElementType();
        if (type == PyElementTypes.INTEGER_LITERAL_EXPRESSION) {
            return PyNumericLiteralExpressionImpl.getBigIntegerValue(text);
        }
        return this.getBigDecimalValue().toBigInteger();
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        BigDecimal whole;
        ASTNode node = this.getNode();
        String text = node.getText();
        IElementType type = node.getElementType();
        if (type == PyElementTypes.INTEGER_LITERAL_EXPRESSION) {
            return new BigDecimal(PyNumericLiteralExpressionImpl.getBigIntegerValue(text));
        }
        Matcher m = PATTERN_FLOAT.matcher(text);
        boolean matches = m.matches();
        assert (matches);
        if (m.group(2) != null) {
            whole = new BigDecimal(m.group(2));
            String fractionStr = m.group(3);
            BigDecimal fraction = BigDecimal.ZERO;
            if (fractionStr != null) {
                fraction = new BigDecimal("0." + fractionStr);
            }
            whole = whole.add(fraction);
        } else if (m.group(4) != null) {
            whole = new BigDecimal("0." + m.group(4));
        } else {
            throw new IllegalStateException("Cannot parse BigDecimal for " + text);
        }
        if (m.group(5) != null) {
            String sign = m.group(6);
            if (sign == null) {
                sign = "+";
            }
            String exp = m.group(7);
            whole = whole.multiply(new BigDecimal("1e" + sign + exp));
        }
        return whole;
    }

    @Override
    public boolean isIntegerLiteral() {
        return this.getNode().getElementType() == PyElementTypes.INTEGER_LITERAL_EXPRESSION;
    }

    @Nullable
    private static BigInteger getBigIntegerValue(String text) {
        int radix;
        Matcher m = PATTERN_INT.matcher(text);
        if (!m.matches()) {
            return null;
        }
        if (m.group(1) != null) {
            radix = 10;
        } else {
            if (m.group(2) != null) {
                return BigInteger.ZERO;
            }
            if (m.group(3) != null) {
                radix = 8;
            } else if (m.group(4) != null) {
                radix = 16;
            } else {
                throw new IllegalStateException("No radix found: " + text);
            }
        }
        if (StringUtil.endsWithIgnoreCase((String)text, (String)"L")) {
            text = text.substring(0, text.length() - 1);
        }
        return new BigInteger(text, radix);
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyNumericLiteralExpressionImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyNumericLiteralExpressionImpl", "getType"));
        }
        ASTNode node = this.getNode();
        IElementType type = node.getElementType();
        if (type == PyElementTypes.INTEGER_LITERAL_EXPRESSION) {
            return PyBuiltinCache.getInstance((PsiElement)this).getIntType();
        }
        if (type == PyElementTypes.FLOAT_LITERAL_EXPRESSION) {
            return PyBuiltinCache.getInstance((PsiElement)this).getFloatType();
        }
        if (type == PyElementTypes.IMAGINARY_LITERAL_EXPRESSION) {
            return PyBuiltinCache.getInstance((PsiElement)this).getComplexType();
        }
        return null;
    }
}

