/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.CallArgumentsMapping;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.stubs.PyNamedParameterStub;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyNamedParameterImpl
extends PyBaseElementImpl<PyNamedParameterStub>
implements PyNamedParameter {
    public PyNamedParameterImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyNamedParameterImpl(PyNamedParameterStub stub) {
        this(stub, (IStubElementType)PyElementTypes.NAMED_PARAMETER);
    }

    public PyNamedParameterImpl(PyNamedParameterStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    @Nullable
    public String getName() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.getNameIdentifierNode();
        return node != null ? node.getText() : null;
    }

    @Override
    public int getTextOffset() {
        ASTNode node = this.getNameIdentifierNode();
        return node == null ? super.getTextOffset() : node.getTextRange().getStartOffset();
    }

    @Nullable
    protected ASTNode getNameIdentifierNode() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER);
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.getNameIdentifierNode();
        return node == null ? null : node.getPsi();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/psi/impl/PyNamedParameterImpl", "setName"));
        }
        ASTNode oldNameIdentifier = this.getNameIdentifierNode();
        if (oldNameIdentifier != null) {
            ASTNode nameElement = PyUtil.createNewName(this, name);
            this.getNode().replaceChild(oldNameIdentifier, nameElement);
        }
        return this;
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyNamedParameter(this);
    }

    @Override
    public boolean isPositionalContainer() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null) {
            return stub.isPositionalContainer();
        }
        return this.getNode().findChildByType((IElementType)PyTokenTypes.MULT) != null;
    }

    @Override
    public boolean isKeywordContainer() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null) {
            return stub.isKeywordContainer();
        }
        return this.getNode().findChildByType((IElementType)PyTokenTypes.EXP) != null;
    }

    @Override
    @Nullable
    public PyExpression getDefaultValue() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null && !stub.hasDefaultValue()) {
            return null;
        }
        ASTNode[] nodes = this.getNode().getChildren(PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens());
        if (nodes.length > 0) {
            return (PyExpression)nodes[0].getPsi();
        }
        return null;
    }

    @Override
    public boolean hasDefaultValue() {
        PyNamedParameterStub stub = (PyNamedParameterStub)this.getStub();
        if (stub != null) {
            return stub.hasDefaultValue();
        }
        return this.getDefaultValue() != null;
    }

    @Override
    @NotNull
    public String getRepr(boolean includeDefaultValue) {
        PyExpression default_v;
        StringBuilder sb = new StringBuilder();
        if (this.isPositionalContainer()) {
            sb.append("*");
        } else if (this.isKeywordContainer()) {
            sb.append("**");
        }
        sb.append(this.getName());
        if (includeDefaultValue && (default_v = this.getDefaultValue()) != null) {
            sb.append("=").append(PyUtil.getReadableRepr((PsiElement)default_v, true));
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyNamedParameterImpl", "getRepr"));
        }
        return string;
    }

    @Override
    public PyAnnotation getAnnotation() {
        return this.getStubOrPsiChild(PyElementTypes.ANNOTATION);
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.PARAMETER_ICON;
    }

    @Override
    public PyNamedParameter getAsNamed() {
        return this;
    }

    @Override
    public PyTupleParameter getAsTuple() {
        return null;
    }

    @Override
    public PyType getType(final @NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        PyParameterList parameterList;
        PyFunction func;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/impl/PyNamedParameterImpl", "getType"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/psi/impl/PyNamedParameterImpl", "getType"));
        }
        PsiElement parent = this.getStubOrPsiParent();
        if (parent instanceof PyParameterList && (func = (parameterList = (PyParameterList)parent).getContainingFunction()) != null) {
            PyType type;
            PyExpression defaultValue;
            PyClass containingClass;
            String typeName;
            PyClass pyClass;
            PyType type2;
            PyAnnotation annotation = this.getAnnotation();
            if (annotation != null && (type2 = context.getType(annotation)) != null) {
                return type2;
            }
            StructuredDocString docString = func.getStructuredDocString();
            if ("__init__".equals(func.getName()) && docString == null && (pyClass = func.getContainingClass()) != null) {
                docString = pyClass.getStructuredDocString();
            }
            if (docString != null && (typeName = docString.getParamType(this.getName())) != null) {
                return PyTypeParser.getTypeByName((PsiElement)this, typeName);
            }
            if (this.isSelf() && (containingClass = func.getContainingClass()) != null) {
                PyType initType = null;
                PyFunction init = containingClass.findInitOrNew(true);
                if (init != null && init != func) {
                    initType = context.getReturnType(init);
                    if (init.getContainingClass() != containingClass && initType instanceof PyCollectionType) {
                        PyType elementType = ((PyCollectionType)initType).getElementType(context);
                        return new PyCollectionTypeImpl(containingClass, false, elementType);
                    }
                }
                if (initType != null && !(initType instanceof PyNoneType)) {
                    return initType;
                }
                PyFunction.Modifier modifier = func.getModifier();
                return new PyClassTypeImpl(containingClass, modifier == PyFunction.Modifier.CLASSMETHOD);
            }
            if (this.isKeywordContainer()) {
                return PyBuiltinCache.getInstance((PsiElement)this).getDictType();
            }
            if (this.isPositionalContainer()) {
                return PyBuiltinCache.getInstance((PsiElement)this).getTupleType();
            }
            for (PyTypeProvider provider : (PyTypeProvider[])Extensions.getExtensions(PyTypeProvider.EP_NAME)) {
                PyType result = provider.getParameterType(this, func, context);
                if (result == null) continue;
                return result;
            }
            if (context.maySwitchToAST((PsiElement)this) && (defaultValue = this.getDefaultValue()) != null && (type = context.getType(defaultValue)) != null && !(type instanceof PyNoneType)) {
                if (type instanceof PyTupleType) {
                    return PyUnionType.createWeakType(type);
                }
                return type;
            }
            if (context.allowLocalUsages((PsiElement)this)) {
                final ArrayList<PyType> types = new ArrayList<PyType>();
                PyNamedParameterImpl.processLocalCalls(func, new Processor<PyCallExpression>(){

                    public boolean process(@NotNull PyCallExpression call) {
                        if (call == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/jetbrains/python/psi/impl/PyNamedParameterImpl$1", "process"));
                        }
                        PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
                        PyArgumentList argumentList = call.getArgumentList();
                        if (argumentList != null) {
                            CallArgumentsMapping mapping = argumentList.analyzeCall(resolveContext);
                            for (Map.Entry<PyExpression, PyNamedParameter> entry : mapping.getPlainMappedParams().entrySet()) {
                                PyType type;
                                PyExpression argument;
                                if (entry.getValue() != PyNamedParameterImpl.this || (argument = entry.getKey()) == null || (type = context.getType(argument)) == null) continue;
                                types.add(type);
                                return true;
                            }
                        }
                        return true;
                    }
                });
                if (!types.isEmpty()) {
                    return PyUnionType.createWeakType(PyUnionType.union(types));
                }
            }
        }
        return null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new PyElementPresentation(this);
    }

    private static void processLocalCalls(@NotNull PyFunction function, @NotNull Processor<PyCallExpression> processor) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/psi/impl/PyNamedParameterImpl", "processLocalCalls"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/python/psi/impl/PyNamedParameterImpl", "processLocalCalls"));
        }
        PsiFile file = function.getContainingFile();
        String name = function.getName();
        if (file != null && name != null) {
            String text = file.getText();
            int pos = text.indexOf(name);
            while (pos != -1) {
                PyCallExpression expr;
                PsiReference ref = file.findReferenceAt(pos);
                if (ref != null && ref.isReferenceTo((PsiElement)function) && (expr = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(pos), PyCallExpression.class)) != null && !processor.process((Object)expr)) {
                    return;
                }
                pos = text.indexOf(name, pos + 1);
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "('" + this.getName() + "')";
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)this);
        if (owner instanceof PyFunction) {
            LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)owner);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyNamedParameterImpl", "getUseScope"));
            }
            return localSearchScope;
        }
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)this.getContainingFile());
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyNamedParameterImpl", "getUseScope"));
        }
        return localSearchScope;
    }

    @Override
    public boolean isSelf() {
        if (this.isPositionalContainer() || this.isKeywordContainer()) {
            return false;
        }
        PyFunction function = this.getStubOrPsiParentOfType(PyFunction.class);
        if (function == null) {
            return false;
        }
        PyClass cls = function.getContainingClass();
        PyParameter[] parameters = function.getParameterList().getParameters();
        if (cls != null && parameters.length > 0 && parameters[0] == this) {
            if ("__new__".equals(function.getName())) {
                return true;
            }
            PyFunction.Modifier modifier = function.getModifier();
            if (modifier != PyFunction.Modifier.STATICMETHOD) {
                return true;
            }
        }
        return false;
    }
}

